/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.DockTheme;
import bibliothek.gui.DockUI;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.action.DefaultDockActionSource;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.action.HierarchyDockActionSource;
import bibliothek.gui.dock.action.ListeningDockAction;
import bibliothek.gui.dock.action.LocationHint;
import bibliothek.gui.dock.displayer.DockableDisplayerHints;
import bibliothek.gui.dock.dockable.DockHierarchyObserver;
import bibliothek.gui.dock.event.DockHierarchyListener;
import bibliothek.gui.dock.event.DockStationAdapter;
import bibliothek.gui.dock.event.DockStationListener;
import bibliothek.gui.dock.event.DockTitleEvent;
import bibliothek.gui.dock.event.DockableListener;
import bibliothek.gui.dock.event.DoubleClickListener;
import bibliothek.gui.dock.event.SplitDockListener;
import bibliothek.gui.dock.layout.AbstractDockableProperty;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.station.DisplayerCollection;
import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.station.DockableDisplayerListener;
import bibliothek.gui.dock.station.OverpaintablePanel;
import bibliothek.gui.dock.station.StationChildHandle;
import bibliothek.gui.dock.station.split.DefaultSplitLayoutManager;
import bibliothek.gui.dock.station.split.Leaf;
import bibliothek.gui.dock.station.split.Node;
import bibliothek.gui.dock.station.split.Placeholder;
import bibliothek.gui.dock.station.split.PutInfo;
import bibliothek.gui.dock.station.split.Root;
import bibliothek.gui.dock.station.split.SplitDockAccess;
import bibliothek.gui.dock.station.split.SplitDockFullScreenProperty;
import bibliothek.gui.dock.station.split.SplitDockPathProperty;
import bibliothek.gui.dock.station.split.SplitDockPlaceholderProperty;
import bibliothek.gui.dock.station.split.SplitDockProperty;
import bibliothek.gui.dock.station.split.SplitDockStationFactory;
import bibliothek.gui.dock.station.split.SplitDockTree;
import bibliothek.gui.dock.station.split.SplitDockTreeFactory;
import bibliothek.gui.dock.station.split.SplitFullScreenAction;
import bibliothek.gui.dock.station.split.SplitLayoutManager;
import bibliothek.gui.dock.station.split.SplitNode;
import bibliothek.gui.dock.station.split.SplitNodeVisitor;
import bibliothek.gui.dock.station.split.SplitPlaceholderSet;
import bibliothek.gui.dock.station.split.SplitTreeFactory;
import bibliothek.gui.dock.station.support.CombinerWrapper;
import bibliothek.gui.dock.station.support.DisplayerFactoryWrapper;
import bibliothek.gui.dock.station.support.DockStationListenerManager;
import bibliothek.gui.dock.station.support.DockableVisibilityManager;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.gui.dock.station.support.PlaceholderStrategyListener;
import bibliothek.gui.dock.station.support.RootPlaceholderStrategy;
import bibliothek.gui.dock.station.support.StationPaintWrapper;
import bibliothek.gui.dock.title.ControllerTitleFactory;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.title.DockTitleRequest;
import bibliothek.gui.dock.title.DockTitleVersion;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.PropertyValue;
import bibliothek.gui.dock.util.property.ConstantPropertyFactory;
import bibliothek.util.Path;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplitDockStation
extends OverpaintablePanel
implements Dockable,
DockStation {
    public static final String TITLE_ID = "split";
    public static final PropertyKey<KeyStroke> MAXIMIZE_ACCELERATOR = new PropertyKey("SplitDockStation maximize accelerator");
    public static final PropertyKey<SplitLayoutManager> LAYOUT_MANAGER = new PropertyKey<DefaultSplitLayoutManager>("SplitDockStation layout manager", new ConstantPropertyFactory<DefaultSplitLayoutManager>(new DefaultSplitLayoutManager()), true);
    private DockStation parent;
    private VisibleListener visibleListener = new VisibleListener();
    private DockController controller;
    private DockTheme theme;
    private CombinerWrapper combiner = new CombinerWrapper();
    private DockTitleVersion title;
    private List<DockableListener> dockableListeners = new ArrayList<DockableListener>();
    private DockHierarchyObserver hierarchyObserver;
    private List<SplitDockListener> splitListeners = new ArrayList<SplitDockListener>();
    private DockableVisibilityManager visibility;
    private List<DockTitle> titles = new LinkedList<DockTitle>();
    private HierarchyDockActionSource globalSource;
    protected DockStationListenerManager dockStationListeners = new DockStationListenerManager(this);
    private PropertyValue<String> titleText = new PropertyValue<String>(PropertyKey.DOCK_STATION_TITLE){

        @Override
        protected void valueChanged(String string, String string2) {
            if (string == null) {
                string = "";
            }
            if (string2 == null) {
                string2 = "";
            }
            for (DockableListener dockableListener : SplitDockStation.this.dockableListeners.toArray(new DockableListener[SplitDockStation.this.dockableListeners.size()])) {
                dockableListener.titleTextChanged(SplitDockStation.this, string, string2);
            }
        }
    };
    private PropertyValue<Icon> titleIcon = new PropertyValue<Icon>(PropertyKey.DOCK_STATION_ICON){

        @Override
        protected void valueChanged(Icon icon, Icon icon2) {
            for (DockableListener dockableListener : SplitDockStation.this.dockableListeners.toArray(new DockableListener[SplitDockStation.this.dockableListeners.size()])) {
                dockableListener.titleIconChanged(SplitDockStation.this, icon, icon2);
            }
        }
    };
    private PropertyValue<String> titleToolTip = new PropertyValue<String>(PropertyKey.DOCK_STATION_TOOLTIP){

        @Override
        protected void valueChanged(String string, String string2) {
            for (DockableListener dockableListener : SplitDockStation.this.dockableListeners.toArray(new DockableListener[SplitDockStation.this.dockableListeners.size()])) {
                dockableListener.titleToolTipChanged(SplitDockStation.this, string, string2);
            }
        }
    };
    private PropertyValue<SplitLayoutManager> layoutManager = new PropertyValue<SplitLayoutManager>(LAYOUT_MANAGER){

        @Override
        protected void valueChanged(SplitLayoutManager splitLayoutManager, SplitLayoutManager splitLayoutManager2) {
            if (splitLayoutManager != null) {
                splitLayoutManager.uninstall(SplitDockStation.this);
            }
            if (splitLayoutManager2 != null) {
                splitLayoutManager2.install(SplitDockStation.this);
            }
        }
    };
    private PropertyValue<PlaceholderStrategy> placeholderStrategyProperty = new PropertyValue<PlaceholderStrategy>(PlaceholderStrategy.PLACEHOLDER_STRATEGY){

        @Override
        protected void valueChanged(PlaceholderStrategy placeholderStrategy, PlaceholderStrategy placeholderStrategy2) {
            SplitDockStation.this.placeholderStrategy.setStrategy(placeholderStrategy2);
        }
    };
    private RootPlaceholderStrategy placeholderStrategy = new RootPlaceholderStrategy(this);
    private boolean expandOnDoubleclick = true;
    private FullScreenListener fullScreenListener = new FullScreenListener();
    private List<StationChildHandle> dockables = new ArrayList<StationChildHandle>();
    private Dockable frontDockable;
    private StationChildHandle fullScreenDockable;
    private ListeningDockAction fullScreenAction;
    private int dividerSize = 4;
    private float sideSnapSize = 0.25f;
    private int borderSideSnapSize = 25;
    private boolean allowSideSnap = true;
    private SplitDockAccess access = new SplitDockAccess(){
        private long lastUniqueId = -1L;

        public StationChildHandle getFullScreenDockable() {
            return SplitDockStation.this.fullScreenDockable;
        }

        public DockTitleVersion getTitleVersion() {
            return SplitDockStation.this.title;
        }

        public SplitDockStation getOwner() {
            return SplitDockStation.this;
        }

        public double validateDivider(double d, Node node) {
            return ((SplitLayoutManager)SplitDockStation.this.layoutManager.getValue()).validateDivider(SplitDockStation.this, d, node);
        }

        public StationChildHandle newHandle(Dockable dockable) {
            return new StationChildHandle(SplitDockStation.this, SplitDockStation.this.getDisplayers(), dockable, SplitDockStation.this.title);
        }

        public void addHandle(StationChildHandle stationChildHandle, boolean bl) {
            SplitDockStation.this.addHandle(stationChildHandle, bl);
        }

        public void removeHandle(StationChildHandle stationChildHandle, boolean bl) {
            SplitDockStation.this.removeHandle(stationChildHandle, bl);
        }

        public boolean drop(Dockable dockable, SplitDockProperty splitDockProperty, SplitNode splitNode) {
            return SplitDockStation.this.drop(dockable, splitDockProperty, splitNode);
        }

        public PutInfo validatePutInfo(PutInfo putInfo) {
            return ((SplitLayoutManager)SplitDockStation.this.layoutManager.getValue()).validatePutInfo(SplitDockStation.this, putInfo);
        }

        public long uniqueID() {
            long l = System.currentTimeMillis();
            if (l <= this.lastUniqueId) {
                l = this.lastUniqueId + 1L;
            }
            while (SplitDockStation.this.getNode(l) != null) {
                ++l;
            }
            this.lastUniqueId = l;
            return l;
        }

        public boolean isTreeAutoCleanupEnabled() {
            return SplitDockStation.this.treeLock == 0;
        }

        public SplitPlaceholderSet getPlaceholderSet() {
            return SplitDockStation.this.placeholderSet;
        }
    };
    private Root root;
    private SplitPlaceholderSet placeholderSet;
    private int treeLock = 0;
    private PutInfo putInfo;
    private StationPaintWrapper paint = new StationPaintWrapper();
    private DisplayerFactoryWrapper displayerFactory = new DisplayerFactoryWrapper();
    private DisplayerCollection displayers;
    private DividerListener dividerListener;
    private boolean resizingEnabled = true;
    private boolean continousDisplay = false;
    private DockableDisplayerHints hints;

    public SplitDockStation() {
        this.setBasePane(new Content());
        this.placeholderSet = new SplitPlaceholderSet(this.access);
        this.displayers = new DisplayerCollection(this, this.displayerFactory);
        this.displayers.addDockableDisplayerListener(new DockableDisplayerListener(){

            public void discard(DockableDisplayer dockableDisplayer) {
                SplitDockStation.this.discard(dockableDisplayer);
            }
        });
        this.dividerListener = new DividerListener();
        this.fullScreenAction = this.createFullScreenAction();
        this.visibility = new DockableVisibilityManager(this.dockStationListeners);
        this.getContentPane().addMouseListener(this.dividerListener);
        this.getContentPane().addMouseMotionListener(this.dividerListener);
        this.hierarchyObserver = new DockHierarchyObserver(this);
        this.globalSource = new HierarchyDockActionSource(this);
        this.globalSource.bind();
        this.addDockStationListener(new DockStationAdapter(){

            public void dockableAdded(DockStation dockStation, Dockable dockable) {
                SplitDockStation.this.updateConfigurableDisplayerHints();
            }

            public void dockableRemoved(DockStation dockStation, Dockable dockable) {
                SplitDockStation.this.updateConfigurableDisplayerHints();
            }
        });
        this.placeholderStrategy.addListener(new PlaceholderStrategyListener(){

            @Override
            public void placeholderInvalidated(Set<Path> set) {
                SplitDockStation.this.removePlaceholders(set);
            }
        });
    }

    protected Root createRoot(SplitDockAccess splitDockAccess) {
        return new Root(splitDockAccess);
    }

    protected final Root root() {
        if (this.root == null) {
            this.root = this.createRoot(this.access);
        }
        return this.root;
    }

    @Override
    public String toString() {
        if (this.root == null) {
            return super.toString();
        }
        return this.root.toString();
    }

    @Override
    public Dimension getMinimumSize() {
        Insets insets = this.getInsets();
        Dimension dimension = this.getRoot().getMinimumSize();
        if (insets != null) {
            dimension = new Dimension(dimension.width + insets.left + insets.right, dimension.height + insets.top + insets.bottom);
        }
        return dimension;
    }

    @Override
    public DockTheme getTheme() {
        return this.theme;
    }

    @Override
    public void updateTheme() {
        DockTheme dockTheme;
        DockController dockController = this.getController();
        if (dockController != null && (dockTheme = dockController.getTheme()) != this.theme) {
            this.theme = dockTheme;
            try {
                this.callDockUiUpdateTheme();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }

    protected void callDockUiUpdateTheme() throws IOException {
        DockUI.updateTheme(this, new SplitDockStationFactory());
    }

    protected ListeningDockAction createFullScreenAction() {
        return new SplitFullScreenAction(this);
    }

    public void setFullScreenAction(ListeningDockAction listeningDockAction) {
        if (this.fullScreenAction != null) {
            throw new IllegalStateException("The fullScreenAction can only be set once");
        }
        this.fullScreenAction = listeningDockAction;
    }

    public void setExpandOnDoubleclick(boolean bl) {
        this.expandOnDoubleclick = bl;
    }

    public boolean isExpandOnDoubleclick() {
        return this.expandOnDoubleclick;
    }

    public void setResizingEnabled(boolean bl) {
        this.resizingEnabled = bl;
    }

    public boolean isResizingEnabled() {
        return this.resizingEnabled;
    }

    @Override
    public void setDockParent(DockStation dockStation) {
        if (this.parent != null) {
            this.parent.removeDockStationListener(this.visibleListener);
        }
        this.parent = dockStation;
        if (dockStation != null) {
            dockStation.addDockStationListener(this.visibleListener);
        }
        this.hierarchyObserver.update();
    }

    @Override
    public DockStation getDockParent() {
        return this.parent;
    }

    @Override
    public void setController(DockController dockController) {
        if (this.controller != dockController) {
            if (this.controller != null) {
                this.controller.getDoubleClickController().removeListener(this.fullScreenListener);
            }
            for (StationChildHandle stationChildHandle : this.dockables) {
                stationChildHandle.setTitleRequest(null);
            }
            this.controller = dockController;
            this.getDisplayers().setController(dockController);
            if (this.fullScreenAction != null) {
                this.fullScreenAction.setController(dockController);
            }
            this.titleIcon.setProperties(dockController);
            this.titleText.setProperties(dockController);
            this.layoutManager.setProperties(dockController);
            this.placeholderStrategyProperty.setProperties(dockController);
            if (dockController != null) {
                this.title = dockController.getDockTitleManager().getVersion(TITLE_ID, ControllerTitleFactory.INSTANCE);
                dockController.getDoubleClickController().addListener(this.fullScreenListener);
            } else {
                this.title = null;
            }
            for (StationChildHandle stationChildHandle : this.dockables) {
                stationChildHandle.setTitleRequest(this.title);
            }
            this.hierarchyObserver.controllerChanged(dockController);
        }
    }

    @Override
    public DockController getController() {
        return this.controller;
    }

    @Override
    public void addDockableListener(DockableListener dockableListener) {
        this.dockableListeners.add(dockableListener);
    }

    @Override
    public void removeDockableListener(DockableListener dockableListener) {
        this.dockableListeners.remove(dockableListener);
    }

    @Override
    public void addDockHierarchyListener(DockHierarchyListener dockHierarchyListener) {
        this.hierarchyObserver.addDockHierarchyListener(dockHierarchyListener);
    }

    @Override
    public void removeDockHierarchyListener(DockHierarchyListener dockHierarchyListener) {
        this.hierarchyObserver.removeDockHierarchyListener(dockHierarchyListener);
    }

    @Override
    public void addMouseInputListener(MouseInputListener mouseInputListener) {
    }

    @Override
    public void removeMouseInputListener(MouseInputListener mouseInputListener) {
    }

    @Override
    public boolean accept(DockStation dockStation) {
        return true;
    }

    @Override
    public boolean accept(DockStation dockStation, Dockable dockable) {
        return true;
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public DockElement getElement() {
        return this;
    }

    @Override
    public boolean isUsedAsTitle() {
        return false;
    }

    @Override
    public Point getPopupLocation(Point point, boolean bl) {
        if (bl) {
            return point;
        }
        return null;
    }

    @Override
    public String getTitleText() {
        String string = this.titleText.getValue();
        if (string == null) {
            return "";
        }
        return string;
    }

    public void setTitleText(String string) {
        this.titleText.setValue(string);
    }

    @Override
    public String getTitleToolTip() {
        return this.titleToolTip.getValue();
    }

    public void setTitleToolTip(String string) {
        this.titleToolTip.setValue(string);
    }

    @Override
    public Icon getTitleIcon() {
        return this.titleIcon.getValue();
    }

    public void setTitleIcon(Icon icon) {
        this.titleIcon.setValue(icon);
    }

    public void setSplitLayoutManager(SplitLayoutManager splitLayoutManager) {
        this.layoutManager.setValue(splitLayoutManager);
    }

    public SplitLayoutManager getSplitLayoutManager() {
        return this.layoutManager.getOwnValue();
    }

    public PlaceholderStrategy getPlaceholderStrategy() {
        return this.placeholderStrategy;
    }

    public void setPlaceholderStrategy(PlaceholderStrategy placeholderStrategy) {
        this.placeholderStrategyProperty.setValue(placeholderStrategy);
    }

    public void setSideSnapSize(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("sideSnapSize must not be less than 0");
        }
        this.sideSnapSize = f;
    }

    public float getSideSnapSize() {
        return this.sideSnapSize;
    }

    public void setBorderSideSnapSize(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("borderSideSnapeSize must not be less than 0");
        }
        this.borderSideSnapSize = n;
    }

    public int getBorderSideSnapSize() {
        return this.borderSideSnapSize;
    }

    public void setDividerSize(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("dividerSize must not be less than 0");
        }
        this.dividerSize = n;
        this.doLayout();
    }

    public int getDividerSize() {
        return this.dividerSize;
    }

    public void setContinousDisplay(boolean bl) {
        this.continousDisplay = bl;
    }

    public boolean isContinousDisplay() {
        return this.continousDisplay;
    }

    public void setAllowSideSnap(boolean bl) {
        this.allowSideSnap = bl;
    }

    public boolean isAllowSideSnap() {
        return this.allowSideSnap;
    }

    @Override
    public void requestDockTitle(DockTitleRequest dockTitleRequest) {
    }

    @Override
    public void changed(Dockable dockable, DockTitle dockTitle, boolean bl) {
        dockTitle.changed(new DockTitleEvent(this, dockable, bl));
    }

    @Override
    public void requestChildDockTitle(DockTitleRequest dockTitleRequest) {
    }

    @Override
    public void bind(DockTitle dockTitle) {
        if (this.titles.contains(dockTitle)) {
            throw new IllegalArgumentException("Title is already bound");
        }
        this.titles.add(dockTitle);
        for (DockableListener dockableListener : this.dockableListeners.toArray(new DockableListener[this.dockableListeners.size()])) {
            dockableListener.titleBound(this, dockTitle);
        }
    }

    @Override
    public void unbind(DockTitle dockTitle) {
        if (!this.titles.contains(dockTitle)) {
            throw new IllegalArgumentException("Title is unknown");
        }
        this.titles.remove(dockTitle);
        for (DockableListener dockableListener : this.dockableListeners.toArray(new DockableListener[this.dockableListeners.size()])) {
            dockableListener.titleUnbound(this, dockTitle);
        }
    }

    @Override
    public DockTitle[] listBoundTitles() {
        return this.titles.toArray(new DockTitle[this.titles.size()]);
    }

    @Override
    public DockActionSource getLocalActionOffers() {
        return null;
    }

    @Override
    public DockActionSource getGlobalActionOffers() {
        return this.globalSource;
    }

    @Override
    public void configureDisplayerHints(DockableDisplayerHints dockableDisplayerHints) {
        this.hints = dockableDisplayerHints;
        this.updateConfigurableDisplayerHints();
    }

    protected DockableDisplayerHints getConfigurableDisplayerHints() {
        return this.hints;
    }

    protected void updateConfigurableDisplayerHints() {
        if (this.hints != null) {
            if (this.getDockableCount() == 0) {
                this.hints.setShowBorderHint(Boolean.TRUE);
            } else {
                this.hints.setShowBorderHint(Boolean.FALSE);
            }
        }
    }

    @Override
    public DockStation asDockStation() {
        return this;
    }

    @Override
    public DefaultDockActionSource getDirectActionOffers(Dockable dockable) {
        if (this.fullScreenAction == null) {
            return null;
        }
        DefaultDockActionSource defaultDockActionSource = new DefaultDockActionSource(new LocationHint(LocationHint.DIRECT_ACTION, LocationHint.VERY_RIGHT), new DockAction[0]);
        defaultDockActionSource.add(this.fullScreenAction);
        return defaultDockActionSource;
    }

    @Override
    public DockActionSource getIndirectActionOffers(Dockable dockable) {
        if (this.fullScreenAction == null) {
            return null;
        }
        DockStation dockStation = dockable.getDockParent();
        if (dockStation == null) {
            return null;
        }
        if (dockStation instanceof SplitDockStation) {
            return null;
        }
        dockable = dockStation.asDockable();
        if (dockable == null) {
            return null;
        }
        dockStation = dockable.getDockParent();
        if (dockStation != this) {
            return null;
        }
        DefaultDockActionSource defaultDockActionSource = new DefaultDockActionSource(this.fullScreenAction);
        defaultDockActionSource.setHint(new LocationHint(LocationHint.INDIRECT_ACTION, LocationHint.VERY_RIGHT));
        return defaultDockActionSource;
    }

    @Override
    public void addDockStationListener(DockStationListener dockStationListener) {
        this.dockStationListeners.addListener(dockStationListener);
    }

    @Override
    public void removeDockStationListener(DockStationListener dockStationListener) {
        this.dockStationListeners.removeListener(dockStationListener);
    }

    public void addSplitDockStationListener(SplitDockListener splitDockListener) {
        this.splitListeners.add(splitDockListener);
    }

    public void removeSplitDockStationListener(SplitDockListener splitDockListener) {
        this.splitListeners.remove(splitDockListener);
    }

    @Override
    public boolean isVisible(Dockable dockable) {
        return this.isStationVisible() && (!this.isFullScreen() || dockable == this.getFullScreen());
    }

    @Override
    public boolean isStationVisible() {
        if (this.parent != null) {
            return this.parent.isStationVisible() && this.parent.isVisible(this);
        }
        return this.isDisplayable();
    }

    @Override
    public int getDockableCount() {
        return this.dockables.size();
    }

    @Override
    public Dockable getDockable(int n) {
        return this.dockables.get(n).getDockable();
    }

    @Override
    public DockableProperty getDockableProperty(Dockable dockable, Dockable dockable2) {
        AbstractDockableProperty abstractDockableProperty = this.getDockablePlaceholderProperty(dockable, dockable2);
        if (abstractDockableProperty == null) {
            abstractDockableProperty = this.getDockablePathProperty(dockable);
        }
        return abstractDockableProperty;
    }

    public SplitDockPathProperty getDockablePathProperty(final Dockable dockable) {
        final SplitDockPathProperty splitDockPathProperty = new SplitDockPathProperty();
        this.root().submit(new SplitTreeFactory<Object>(){

            @Override
            public Object leaf(Dockable dockable2, long l, Path[] pathArray, PlaceholderMap placeholderMap) {
                if (dockable == dockable2) {
                    splitDockPathProperty.setLeafId(l);
                    return this;
                }
                return null;
            }

            @Override
            public Object placeholder(long l, Path[] pathArray, PlaceholderMap placeholderMap) {
                return null;
            }

            @Override
            public Object root(Object object, long l) {
                return object;
            }

            @Override
            public Object horizontal(Object object, Object object2, double d, long l, Path[] pathArray, PlaceholderMap placeholderMap, boolean bl) {
                if (object != null) {
                    if (bl) {
                        splitDockPathProperty.insert(SplitDockPathProperty.Location.LEFT, d, 0, l);
                    }
                    return object;
                }
                if (object2 != null) {
                    if (bl) {
                        splitDockPathProperty.insert(SplitDockPathProperty.Location.RIGHT, 1.0 - d, 0, l);
                    }
                    return object2;
                }
                return null;
            }

            @Override
            public Object vertical(Object object, Object object2, double d, long l, Path[] pathArray, PlaceholderMap placeholderMap, boolean bl) {
                if (object != null) {
                    if (bl) {
                        splitDockPathProperty.insert(SplitDockPathProperty.Location.TOP, d, 0, l);
                    }
                    return object;
                }
                if (object2 != null) {
                    if (bl) {
                        splitDockPathProperty.insert(SplitDockPathProperty.Location.BOTTOM, 1.0 - d, 0, l);
                    }
                    return object2;
                }
                return null;
            }
        });
        return splitDockPathProperty;
    }

    public SplitDockProperty getDockableLocationProperty(Dockable dockable) {
        Leaf leaf = this.getRoot().getLeaf(dockable);
        return new SplitDockProperty(leaf.getX(), leaf.getY(), leaf.getWidth(), leaf.getHeight());
    }

    public SplitDockPlaceholderProperty getDockablePlaceholderProperty(Dockable dockable, Dockable dockable2) {
        Leaf leaf = this.getRoot().getLeaf(dockable);
        if (leaf == null) {
            throw new IllegalArgumentException("dockable not known to this station");
        }
        Path path = this.getPlaceholderStrategy().getPlaceholderFor(dockable2 == null ? dockable : dockable2);
        if (path == null) {
            return null;
        }
        this.placeholderSet.set((SplitNode)leaf, path, new SplitNode[0]);
        return new SplitDockPlaceholderProperty(path, this.getDockablePathProperty(dockable));
    }

    @Override
    public Dockable getFrontDockable() {
        if (this.isFullScreen()) {
            return this.getFullScreen();
        }
        if (this.frontDockable == null && this.dockables.size() > 0) {
            this.frontDockable = this.dockables.get(0).getDockable();
        }
        return this.frontDockable;
    }

    @Override
    public void setFrontDockable(Dockable dockable) {
        Dockable dockable2 = this.getFrontDockable();
        this.frontDockable = dockable;
        if (this.isFullScreen() && dockable != null) {
            this.setFullScreen(dockable);
        }
        if (dockable2 != dockable) {
            this.dockStationListeners.fireDockableSelected(dockable2, dockable);
        }
    }

    public boolean isFullScreen() {
        return this.fullScreenDockable != null;
    }

    public Dockable getFullScreen() {
        return this.fullScreenDockable == null ? null : this.fullScreenDockable.getDockable();
    }

    public void setFullScreen(Dockable dockable) {
        dockable = this.layoutManager.getValue().willMakeFullscreen(this, dockable);
        Dockable dockable2 = this.getFullScreen();
        if (dockable2 != dockable) {
            if (dockable != null) {
                Leaf leaf = this.getRoot().getLeaf(dockable);
                if (leaf == null) {
                    throw new IllegalArgumentException("Dockable not child of this station");
                }
                this.fullScreenDockable = leaf.getDockableHandle();
                for (StationChildHandle stationChildHandle : this.dockables) {
                    stationChildHandle.getDisplayer().getComponent().setVisible(stationChildHandle == this.fullScreenDockable);
                }
            } else {
                this.fullScreenDockable = null;
                for (StationChildHandle stationChildHandle : this.dockables) {
                    stationChildHandle.getDisplayer().getComponent().setVisible(true);
                }
            }
            this.doLayout();
            this.fireFullScreenChanged(dockable2, this.getFullScreen());
            this.visibility.fire();
        }
    }

    public void setNextFullScreen() {
        if (this.dockables.size() > 0) {
            if (this.fullScreenDockable == null) {
                this.setFullScreen(this.getDockable(0));
            } else {
                int n = this.indexOfDockable(this.fullScreenDockable.getDockable());
                ++n;
                this.setFullScreen(this.getDockable(n %= this.getDockableCount()));
            }
        }
    }

    @Override
    public boolean accept(Dockable dockable) {
        return true;
    }

    @Override
    public PlaceholderMap getPlaceholders() {
        return null;
    }

    @Override
    public void setPlaceholders(PlaceholderMap placeholderMap) {
    }

    @Override
    public boolean prepareDrop(int n, int n2, int n3, int n4, boolean bl, Dockable dockable) {
        this.putInfo = SwingUtilities.isDescendingFrom(this.getComponent(), dockable.getComponent()) ? null : this.layoutManager.getValue().prepareDrop(this, n, n2, n3, n4, bl, dockable);
        return this.putInfo != null;
    }

    @Override
    public void drop(Dockable dockable) {
        this.addDockable(dockable, true);
    }

    @Override
    public boolean drop(Dockable dockable, DockableProperty dockableProperty) {
        if (dockableProperty instanceof SplitDockProperty) {
            return this.drop(dockable, (SplitDockProperty)dockableProperty);
        }
        if (dockableProperty instanceof SplitDockPathProperty) {
            return this.drop(dockable, (SplitDockPathProperty)dockableProperty);
        }
        if (dockableProperty instanceof SplitDockPlaceholderProperty) {
            return this.drop(dockable, (SplitDockPlaceholderProperty)dockableProperty);
        }
        if (dockableProperty instanceof SplitDockFullScreenProperty) {
            return this.drop(dockable, (SplitDockFullScreenProperty)dockableProperty);
        }
        return false;
    }

    public boolean drop(Dockable dockable, SplitDockProperty splitDockProperty) {
        return this.drop(dockable, splitDockProperty, this.root());
    }

    private boolean drop(Dockable dockable, final SplitDockProperty splitDockProperty, SplitNode splitNode) {
        DockUtilities.ensureTreeValidity(this, dockable);
        if (this.getDockableCount() == 0) {
            this.drop(dockable);
            return true;
        }
        this.updateBounds();
        class DropInfo {
            public Leaf bestLeaf;
            public double bestLeafIntersection;
            public SplitNode bestNode;
            public double bestNodeIntersection = Double.POSITIVE_INFINITY;
            public PutInfo.Put bestNodePut;

            DropInfo() {
            }
        }
        final DropInfo dropInfo = new DropInfo();
        splitNode.visit(new SplitNodeVisitor(){
            {
            }

            public void handleLeaf(Leaf leaf) {
                double d = leaf.intersection(splitDockProperty);
                if (d > dropInfo.bestLeafIntersection) {
                    dropInfo.bestLeafIntersection = d;
                    dropInfo.bestLeaf = leaf;
                }
                this.handleNeighbour(leaf);
            }

            public void handleNode(Node node) {
                if (node.isVisible()) {
                    this.handleNeighbour(node);
                }
            }

            public void handleRoot(Root root) {
            }

            public void handlePlaceholder(Placeholder placeholder) {
            }

            private void handleNeighbour(SplitNode splitNode) {
                double d;
                double d2;
                double d3;
                double d4 = splitNode.getX();
                double d5 = splitNode.getY();
                double d6 = splitNode.getWidth();
                double d7 = splitNode.getHeight();
                double d8 = Math.abs(d4 - splitDockProperty.getX());
                double d9 = Math.abs(d4 + d6 - splitDockProperty.getX() - splitDockProperty.getWidth());
                double d10 = Math.abs(d5 - splitDockProperty.getY());
                double d11 = Math.abs(d5 + d7 - splitDockProperty.getY() - splitDockProperty.getHeight());
                double d12 = d8 + d9 + d10 + d11;
                d12 -= Math.max(Math.max(d8, d9), Math.max(d10, d11));
                double d13 = splitDockProperty.getX() + splitDockProperty.getWidth() / 2.0;
                PutInfo.Put put = splitNode.relativeSidePut(d13, d3 = splitDockProperty.getY() + splitDockProperty.getHeight() / 2.0);
                if (put == PutInfo.Put.TOP) {
                    d2 = d4 + 0.5 * d6;
                    d = d5 + 0.25 * d7;
                } else if (put == PutInfo.Put.BOTTOM) {
                    d2 = d4 + 0.5 * d6;
                    d = d5 + 0.75 * d7;
                } else if (put == PutInfo.Put.LEFT) {
                    d2 = d4 + 0.25 * d6;
                    d = d5 + 0.5 * d7;
                } else {
                    d2 = d4 + 0.5 * d6;
                    d = d5 + 0.75 * d7;
                }
                double d14 = Math.pow((d13 - d2) * (d13 - d2) + (d3 - d) * (d3 - d), 0.25);
                d12 *= d14;
                if (d12 < dropInfo.bestNodeIntersection) {
                    dropInfo.bestNodeIntersection = d12;
                    dropInfo.bestNode = splitNode;
                    dropInfo.bestNodePut = put;
                }
            }
        });
        if (dropInfo.bestLeaf != null) {
            DockStation dockStation = dropInfo.bestLeaf.getDockable().asDockStation();
            DockableProperty dockableProperty = splitDockProperty.getSuccessor();
            if (dockStation != null && dockableProperty != null && dockStation.drop(dockable, dockableProperty)) {
                this.validate();
                return true;
            }
            if (dropInfo.bestLeafIntersection > 0.75) {
                if (dockStation != null && dockStation.accept(dockable) && dockable.accept(dockStation)) {
                    dockStation.drop(dockable);
                    this.validate();
                    return true;
                }
                boolean bl = this.dropOver(dropInfo.bestLeaf, dockable, splitDockProperty.getSuccessor());
                this.validate();
                return bl;
            }
        }
        if (dropInfo.bestNode != null) {
            if (!this.accept(dockable) || !dockable.accept(this)) {
                return false;
            }
            double d = 0.5;
            if (dropInfo.bestNodePut == PutInfo.Put.LEFT) {
                d = splitDockProperty.getWidth() / dropInfo.bestNode.getWidth();
            } else if (dropInfo.bestNodePut == PutInfo.Put.RIGHT) {
                d = 1.0 - splitDockProperty.getWidth() / dropInfo.bestNode.getWidth();
            } else if (dropInfo.bestNodePut == PutInfo.Put.TOP) {
                d = splitDockProperty.getHeight() / dropInfo.bestNode.getHeight();
            } else if (dropInfo.bestNodePut == PutInfo.Put.BOTTOM) {
                d = 1.0 - splitDockProperty.getHeight() / dropInfo.bestNode.getHeight();
            }
            d = Math.max(0.0, Math.min(1.0, d));
            this.dropAside(dropInfo.bestNode, dropInfo.bestNodePut, dockable, null, d, true);
            return true;
        }
        this.repaint();
        return false;
    }

    public boolean drop(Dockable dockable, SplitDockPathProperty splitDockPathProperty) {
        DockUtilities.ensureTreeValidity(this, dockable);
        int n = 0;
        SplitNode splitNode = null;
        long l = splitDockPathProperty.getLeafId();
        if (l != -1L && (splitNode = this.getNode(l)) != null) {
            n = splitDockPathProperty.size();
        }
        if (splitNode == null) {
            SplitDockPathProperty.Node node;
            long l2;
            for (n = splitDockPathProperty.size() - 1; n >= 0 && splitNode == null && ((l2 = (node = splitDockPathProperty.getNode(n)).getId()) == -1L || (splitNode = this.getNode(l2)) == null); --n) {
            }
        }
        if (splitNode == null) {
            splitNode = this.root();
            n = 0;
        }
        this.updateBounds();
        boolean bl = splitNode.insert(splitDockPathProperty, n, dockable);
        if (bl) {
            this.revalidate();
        }
        return bl;
    }

    public boolean drop(Dockable dockable, SplitDockPlaceholderProperty splitDockPlaceholderProperty) {
        DockUtilities.ensureTreeValidity(this, dockable);
        this.validate();
        return this.root().insert(splitDockPlaceholderProperty, dockable);
    }

    public boolean drop(Dockable dockable, SplitDockFullScreenProperty splitDockFullScreenProperty) {
        DockUtilities.ensureTreeValidity(this, dockable);
        DockableProperty dockableProperty = splitDockFullScreenProperty.getSuccessor();
        if (dockable.getDockParent() == this) {
            this.setFullScreen(dockable);
            return true;
        }
        Dockable dockable2 = this.getFullScreen();
        if (dockable2 == null) {
            return false;
        }
        DockStation dockStation = dockable2.asDockStation();
        if (dockStation != null) {
            return dockableProperty != null && dockStation.drop(dockable, dockableProperty);
        }
        Leaf leaf = this.getRoot().getLeaf(dockable2);
        this.setFullScreen(null);
        if (!this.dropOver(leaf, dockable, dockableProperty)) {
            return false;
        }
        Dockable dockable3 = dockable;
        while (dockable != null && dockable != this) {
            dockable3 = dockable;
            DockStation dockStation2 = dockable.getDockParent();
            dockable = dockStation2 == null ? null : dockStation2.asDockable();
        }
        if (dockable3 != null) {
            this.setFullScreen(dockable3);
        }
        return true;
    }

    @Override
    public void drop() {
        this.drop(true);
    }

    private void drop(boolean bl) {
        this.drop(this.putInfo, bl);
    }

    private void drop(PutInfo putInfo, boolean bl) {
        if (putInfo.getNode() == null) {
            if (bl) {
                DockUtilities.ensureTreeValidity(this, putInfo.getDockable());
                this.dockStationListeners.fireDockableAdding(putInfo.getDockable());
            }
            this.addDockable(putInfo.getDockable(), false);
            if (bl) {
                this.dockStationListeners.fireDockableAdded(putInfo.getDockable());
            }
        } else {
            boolean bl2 = false;
            if (putInfo.getPut() == PutInfo.Put.CENTER || putInfo.getPut() == PutInfo.Put.TITLE) {
                if (putInfo.getNode() instanceof Leaf) {
                    if (putInfo.getLeaf() != null) {
                        putInfo.getLeaf().setDockable(null, bl);
                        putInfo.setLeaf(null);
                    }
                    if (this.dropOver((Leaf)putInfo.getNode(), putInfo.getDockable())) {
                        bl2 = true;
                    }
                } else {
                    putInfo.setPut(PutInfo.Put.TOP);
                }
            }
            if (!bl2) {
                this.updateBounds();
                this.layoutManager.getValue().calculateDivider(this, putInfo, this.root().getLeaf(putInfo.getDockable()));
                this.dropAside(putInfo.getNode(), putInfo.getPut(), putInfo.getDockable(), putInfo.getLeaf(), putInfo.getDivider(), bl);
            }
        }
        this.revalidate();
    }

    protected boolean dropOver(Leaf leaf, Dockable dockable) {
        return this.dropOver(leaf, dockable, null);
    }

    protected boolean dropOver(Leaf leaf, Dockable dockable, DockableProperty dockableProperty) {
        DockStation dockStation;
        DockUtilities.ensureTreeValidity(this, dockable);
        Dockable dockable2 = leaf.getDockable();
        leaf.setDockable(null, true);
        Dockable dockable3 = DockUI.getCombiner(this.combiner, this).combine(dockable2, dockable, this, leaf.getPlaceholderMap());
        leaf.setPlaceholderMap(null);
        if (dockableProperty != null && (dockStation = dockable3.asDockStation()) != null && dockable.getDockParent() == dockStation) {
            dockStation.move(dockable, dockableProperty);
        }
        this.dockStationListeners.fireDockableAdding(dockable3);
        leaf.setDockable(dockable3, false);
        this.dockStationListeners.fireDockableAdded(dockable3);
        this.revalidate();
        this.repaint();
        return true;
    }

    protected void dropAside(SplitNode splitNode, PutInfo.Put put, Dockable dockable, Leaf leaf, double d, boolean bl) {
        if (bl) {
            DockUtilities.ensureTreeValidity(this, dockable);
            this.dockStationListeners.fireDockableAdding(dockable);
        }
        boolean bl2 = false;
        if (leaf == null) {
            leaf = new Leaf(this.access);
            bl2 = true;
        }
        SplitNode splitNode2 = splitNode.getParent();
        Node node = null;
        this.updateBounds();
        int n = splitNode2.getChildLocation(splitNode);
        node = put == PutInfo.Put.TOP ? new Node(this.access, (SplitNode)leaf, splitNode, Orientation.VERTICAL) : (put == PutInfo.Put.BOTTOM ? new Node(this.access, splitNode, (SplitNode)leaf, Orientation.VERTICAL) : (put == PutInfo.Put.LEFT ? new Node(this.access, (SplitNode)leaf, splitNode, Orientation.HORIZONTAL) : new Node(this.access, splitNode, (SplitNode)leaf, Orientation.HORIZONTAL)));
        node.setDivider(d);
        splitNode2.setChild(node, n);
        if (bl2) {
            leaf.setDockable(dockable, false);
        }
        if (bl) {
            this.dockStationListeners.fireDockableAdded(dockable);
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    public boolean prepareMove(int n, int n2, int n3, int n4, boolean bl, Dockable dockable) {
        this.putInfo = this.layoutManager.getValue().prepareMove(this, n, n2, n3, n4, bl, dockable);
        return this.putInfo != null;
    }

    @Override
    public void move() {
        Root root = this.root();
        Leaf leaf = root.getLeaf(this.putInfo.getDockable());
        if (leaf.getParent() == this.putInfo.getNode()) {
            if (this.putInfo.getNode() == root) {
                return;
            }
            Node node = (Node)this.putInfo.getNode();
            if (node.getLeft() == leaf) {
                this.putInfo.setNode(node.getRight());
            } else {
                this.putInfo.setNode(node.getLeft());
            }
        }
        this.putInfo.setLeaf(leaf);
        if (this.putInfo.getPut() == PutInfo.Put.CENTER) {
            leaf.placehold(false);
        } else {
            leaf.delete(true);
        }
        this.drop(false);
    }

    @Override
    public void move(Dockable dockable, DockableProperty dockableProperty) {
    }

    public void dropTree(SplitDockTree splitDockTree) {
        this.dropTree(splitDockTree, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropTree(SplitDockTree splitDockTree, boolean bl) {
        if (splitDockTree == null) {
            throw new IllegalArgumentException("Tree must not be null");
        }
        DockController dockController = this.getController();
        try {
            ++this.treeLock;
            if (dockController != null) {
                dockController.freezeLayout();
            }
            this.setFullScreen(null);
            this.removeAllDockables();
            for (Dockable dockable : splitDockTree.getDockables()) {
                DockUtilities.ensureTreeValidity(this, dockable);
            }
            SplitDockTree.Key key = splitDockTree.getRoot();
            if (key != null) {
                HashMap<Leaf, Dockable> hashMap = new HashMap<Leaf, Dockable>();
                this.root().evolve(key, bl, hashMap);
                for (Map.Entry entry : hashMap.entrySet()) {
                    ((Leaf)entry.getKey()).setDockable((Dockable)entry.getValue(), true);
                }
                this.updateBounds();
            }
        }
        finally {
            --this.treeLock;
            if (dockController != null) {
                dockController.meltLayout();
            }
        }
    }

    public SplitDockTree createTree() {
        SplitDockTree splitDockTree = new SplitDockTree();
        this.createTree(new SplitDockTreeFactory(splitDockTree));
        return splitDockTree;
    }

    public void createTree(SplitDockTreeFactory splitDockTreeFactory) {
        this.root().submit(splitDockTreeFactory);
    }

    public <N> N visit(SplitTreeFactory<N> splitTreeFactory) {
        return this.root().submit(splitTreeFactory);
    }

    @Override
    public void draw() {
        this.putInfo.setDraw(true);
        this.repaint();
    }

    @Override
    public void forget() {
        this.putInfo = null;
        this.repaint();
    }

    @Override
    public <D extends Dockable & DockStation> boolean isInOverrideZone(int n, int n2, D d, Dockable dockable) {
        if (this.isFullScreen()) {
            return false;
        }
        if (this.getDockParent() != null && this.getDockParent().isInOverrideZone(n, n2, d, dockable)) {
            return true;
        }
        Point point = new Point(n, n2);
        SwingUtilities.convertPointFromScreen(point, this);
        return this.root().isInOverrideZone(point.x, point.y);
    }

    @Override
    public boolean canDrag(Dockable dockable) {
        return true;
    }

    @Override
    public void drag(Dockable dockable) {
        if (dockable.getDockParent() != this) {
            throw new IllegalArgumentException("The dockable cannot be dragged, it is not child of this station.");
        }
        this.removeDockable(dockable);
    }

    protected void fireFullScreenChanged(Dockable dockable, Dockable dockable2) {
        for (SplitDockListener splitDockListener : this.splitListeners.toArray(new SplitDockListener[this.splitListeners.size()])) {
            splitDockListener.fullScreenDockableChanged(this, dockable, dockable2);
        }
    }

    protected void fireTitleExchanged(DockTitle dockTitle) {
        for (DockableListener dockableListener : this.dockableListeners.toArray(new DockableListener[this.dockableListeners.size()])) {
            dockableListener.titleExchanged(this, dockTitle);
        }
    }

    protected void fireTitleExchanged() {
        DockTitle[] dockTitleArray;
        for (DockTitle dockTitle : dockTitleArray = this.listBoundTitles()) {
            this.fireTitleExchanged(dockTitle);
        }
        this.fireTitleExchanged(null);
    }

    @Override
    public Rectangle getStationBounds() {
        Point point = new Point(0, 0);
        SwingUtilities.convertPointToScreen(point, this);
        if (this.isAllowSideSnap()) {
            return new Rectangle(point.x - this.borderSideSnapSize, point.y - this.borderSideSnapSize, this.getWidth() + 2 * this.borderSideSnapSize, this.getHeight() + 2 * this.borderSideSnapSize);
        }
        return new Rectangle(point.x, point.y, this.getWidth(), this.getHeight());
    }

    @Override
    public boolean canCompare(DockStation dockStation) {
        if (!this.isAllowSideSnap()) {
            return false;
        }
        if (dockStation.asDockable() != null) {
            Component component = dockStation.asDockable().getComponent();
            Component component2 = SwingUtilities.getRoot(this.getComponent());
            if (component2 != null && component2 == SwingUtilities.getRoot(component)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int compare(DockStation dockStation) {
        if (!this.isAllowSideSnap()) {
            return 0;
        }
        if (dockStation.asDockable() != null) {
            Component component = dockStation.asDockable().getComponent();
            Component component2 = SwingUtilities.getRoot(this.getComponent());
            if (component2 != null && component2 == SwingUtilities.getRoot(component)) {
                Rectangle rectangle = this.getStationBounds();
                Rectangle rectangle2 = dockStation.getStationBounds();
                if (rectangle == null && rectangle2 == null) {
                    return 0;
                }
                if (rectangle == null) {
                    return -1;
                }
                if (rectangle2 == null) {
                    return 1;
                }
                if (rectangle.width * rectangle.height > rectangle2.width * rectangle2.height) {
                    return -1;
                }
                if (rectangle.width * rectangle.height < rectangle2.width * rectangle2.height) {
                    return 1;
                }
            }
        }
        return 0;
    }

    @Override
    public Dockable asDockable() {
        return this;
    }

    public StationPaintWrapper getPaint() {
        return this.paint;
    }

    public DisplayerFactoryWrapper getDisplayerFactory() {
        return this.displayerFactory;
    }

    public DisplayerCollection getDisplayers() {
        return this.displayers;
    }

    public CombinerWrapper getCombiner() {
        return this.combiner;
    }

    @Override
    protected void paintOverlay(Graphics graphics) {
        if (this.putInfo != null && this.putInfo.isDraw()) {
            StationPaintWrapper stationPaintWrapper = this.getPaint();
            if (this.putInfo.getNode() == null) {
                Rectangle rectangle = new Rectangle(0, 0, this.getWidth(), this.getHeight());
                stationPaintWrapper.drawInsertion(graphics, this, rectangle, rectangle);
            } else {
                Rectangle rectangle = this.putInfo.getNode().getBounds();
                if (this.putInfo.getPut() == PutInfo.Put.LEFT) {
                    rectangle.width = (int)((double)rectangle.width * this.putInfo.getDivider() + 0.5);
                } else if (this.putInfo.getPut() == PutInfo.Put.RIGHT) {
                    int n = rectangle.width;
                    rectangle.width = (int)((double)rectangle.width * (1.0 - this.putInfo.getDivider()) + 0.5);
                    rectangle.x += n - rectangle.width;
                } else if (this.putInfo.getPut() == PutInfo.Put.TOP) {
                    rectangle.height = (int)((double)rectangle.height * this.putInfo.getDivider() + 0.5);
                } else if (this.putInfo.getPut() == PutInfo.Put.BOTTOM) {
                    int n = rectangle.height;
                    rectangle.height = (int)((double)rectangle.height * (1.0 - this.putInfo.getDivider()) + 0.5);
                    rectangle.y += n - rectangle.height;
                }
                stationPaintWrapper.drawInsertion(graphics, this, this.putInfo.getNode().getBounds(), rectangle);
            }
        }
        this.dividerListener.paint(graphics);
    }

    public void addDockable(Dockable dockable) {
        this.addDockable(dockable, true);
    }

    private void addDockable(Dockable dockable, boolean bl) {
        if (bl) {
            DockUtilities.ensureTreeValidity(this, dockable);
            this.dockStationListeners.fireDockableAdding(dockable);
        }
        Leaf leaf = new Leaf(this.access);
        Root root = this.root();
        if (root.getChild() == null) {
            root.setChild(leaf);
        } else {
            SplitNode splitNode = root.getChild();
            root.setChild(null);
            Node node = new Node(this.access, leaf, splitNode);
            root.setChild(node);
        }
        leaf.setDockable(dockable, false);
        if (bl) {
            this.dockStationListeners.fireDockableAdded(dockable);
        }
        this.revalidate();
    }

    @Override
    public boolean canReplace(Dockable dockable, Dockable dockable2) {
        return true;
    }

    @Override
    public void replace(DockStation dockStation, Dockable dockable) {
        this.replace(dockStation.asDockable(), dockable, true);
    }

    @Override
    public void replace(Dockable dockable, Dockable dockable2) {
        this.replace(dockable, dockable2, false);
    }

    private void replace(Dockable dockable, Dockable dockable2, boolean bl) {
        if (dockable == null) {
            throw new NullPointerException("previous must not be null");
        }
        if (dockable2 == null) {
            throw new NullPointerException("next must not be null");
        }
        if (dockable != dockable2) {
            Leaf leaf = this.root().getLeaf(dockable);
            if (leaf == null) {
                throw new IllegalArgumentException("Previous is not child of this station");
            }
            DockUtilities.ensureTreeValidity(this, dockable2);
            boolean bl2 = this.isFullScreen() && this.getFullScreen() == dockable;
            leaf.setDockable(dockable2, true, true, bl);
            if (bl2) {
                this.setFullScreen(dockable2);
            }
            this.revalidate();
            this.repaint();
        }
    }

    private void addHandle(StationChildHandle stationChildHandle, boolean bl) {
        Dockable dockable = stationChildHandle.getDockable();
        DockUtilities.ensureTreeValidity(this, dockable);
        if (bl) {
            this.dockStationListeners.fireDockableAdding(dockable);
        }
        this.dockables.add(stationChildHandle);
        dockable.setDockParent(this);
        stationChildHandle.updateDisplayer();
        DockableDisplayer dockableDisplayer = stationChildHandle.getDisplayer();
        this.getContentPane().add(dockableDisplayer.getComponent());
        dockableDisplayer.getComponent().setVisible(!this.isFullScreen());
        if (bl) {
            this.dockStationListeners.fireDockableAdded(dockable);
        }
    }

    protected void discard(DockableDisplayer dockableDisplayer) {
        int n = this.indexOfDockable(dockableDisplayer.getDockable());
        if (n < 0) {
            throw new IllegalArgumentException("displayer unknown to this station: " + dockableDisplayer);
        }
        Dockable dockable = dockableDisplayer.getDockable();
        boolean bl = dockableDisplayer.getComponent().isVisible();
        Leaf leaf = this.root().getLeaf(dockable);
        this.getContentPane().remove(dockableDisplayer.getComponent());
        StationChildHandle stationChildHandle = leaf.getDockableHandle();
        stationChildHandle.updateDisplayer();
        dockableDisplayer = stationChildHandle.getDisplayer();
        this.getContentPane().add(dockableDisplayer.getComponent());
        dockableDisplayer.getComponent().setVisible(bl);
        this.revalidate();
    }

    public int indexOfDockable(Dockable dockable) {
        int n = this.dockables.size();
        for (int i = 0; i < n; ++i) {
            if (this.dockables.get(i).getDockable() != dockable) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllDockables() {
        DockController dockController = this.getController();
        try {
            if (dockController != null) {
                dockController.freezeLayout();
            }
            for (int i = this.getDockableCount() - 1; i >= 0; --i) {
                this.removeDisplayer(i, true);
            }
            this.root().setChild(null);
        }
        finally {
            if (dockController != null) {
                dockController.meltLayout();
            }
        }
    }

    public void removeDockable(Dockable dockable) {
        Leaf leaf = this.root().getLeaf(dockable);
        if (leaf != null) {
            leaf.setDockable(null, true, true, dockable.asDockStation() != null);
            leaf.placehold(true);
        }
    }

    public void removePlaceholder(Path path) {
        HashSet<Path> hashSet = new HashSet<Path>();
        hashSet.add(path);
        this.removePlaceholder(path);
    }

    public void removePlaceholders(final Set<Path> set) {
        if (set.isEmpty()) {
            return;
        }
        final ArrayList arrayList = new ArrayList();
        this.root().visit(new SplitNodeVisitor(){

            public void handleRoot(Root root) {
                this.handle(root);
            }

            public void handlePlaceholder(Placeholder placeholder) {
                this.handle(SplitDockStation.this.root);
            }

            public void handleNode(Node node) {
                this.handle(SplitDockStation.this.root);
            }

            public void handleLeaf(Leaf leaf) {
                this.handle(SplitDockStation.this.root);
            }

            private void handle(SplitNode splitNode) {
                splitNode.removePlaceholders(set);
                if (!splitNode.isOfUse()) {
                    arrayList.add(splitNode);
                }
            }
        });
        for (SplitNode splitNode : arrayList) {
            splitNode.delete(true);
        }
    }

    private void removeHandle(StationChildHandle stationChildHandle, boolean bl) {
        int n = this.dockables.indexOf(stationChildHandle);
        if (n >= 0) {
            this.removeDisplayer(n, bl);
        }
    }

    private void removeDisplayer(int n, boolean bl) {
        StationChildHandle stationChildHandle = this.dockables.get(n);
        if (stationChildHandle == this.fullScreenDockable) {
            this.setNextFullScreen();
            if (stationChildHandle == this.fullScreenDockable) {
                this.setFullScreen(null);
            }
        }
        Dockable dockable = stationChildHandle.getDockable();
        if (bl) {
            this.dockStationListeners.fireDockableRemoving(dockable);
        }
        this.dockables.remove(n);
        DockableDisplayer dockableDisplayer = stationChildHandle.getDisplayer();
        dockableDisplayer.getComponent().setVisible(true);
        this.getContentPane().remove(dockableDisplayer.getComponent());
        stationChildHandle.destroy();
        if (dockable == this.frontDockable) {
            this.setFrontDockable(null);
        }
        dockable.setDockParent(null);
        if (bl) {
            this.dockStationListeners.fireDockableRemoved(dockable);
        }
    }

    public Root getRoot() {
        return this.root();
    }

    public SplitNode getNode(final long l) {
        if (this.root == null) {
            return null;
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Visitor
        implements SplitNodeVisitor {
            private SplitNode result;

            Visitor() {
            }

            @Override
            public void handleRoot(Root root) {
                if (root.getId() == l) {
                    this.result = root;
                }
            }

            @Override
            public void handleLeaf(Leaf leaf) {
                if (leaf.getId() == l) {
                    this.result = leaf;
                }
            }

            @Override
            public void handlePlaceholder(Placeholder placeholder) {
                if (placeholder.getId() == l) {
                    this.result = placeholder;
                }
            }

            @Override
            public void handleNode(Node node) {
                if (node.getId() == l) {
                    this.result = node;
                }
            }
        }
        Visitor visitor = new Visitor();
        this.getRoot().visit(visitor);
        return visitor.result;
    }

    @Override
    public String getFactoryID() {
        return "SplitDockStationFactory";
    }

    public void updateBounds() {
        Insets insets = this.getBasePane().getInsets();
        double d = this.getWidth() - insets.left - insets.right;
        double d2 = this.getHeight() - insets.top - insets.bottom;
        SplitLayoutManager splitLayoutManager = this.layoutManager.getValue();
        if (d <= 0.0 || d2 <= 0.0) {
            splitLayoutManager.updateBounds(this.root(), 0.0, 0.0, 0.0, 0.0);
        } else {
            splitLayoutManager.updateBounds(this.root(), (double)insets.left / d, (double)insets.top / d2, d, d2);
        }
    }

    protected void checkMousePositionAsync() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                PointerInfo pointerInfo = MouseInfo.getPointerInfo();
                Point point = pointerInfo.getLocation();
                SwingUtilities.convertPointFromScreen(point, SplitDockStation.this.getContentPane());
                SplitDockStation.this.dividerListener.current = SplitDockStation.this.root().getDividerNode(point.x, point.y);
                if (SplitDockStation.this.dividerListener.current == null) {
                    SplitDockStation.this.setCursor(null);
                }
            }
        });
    }

    private class FullScreenListener
    implements DoubleClickListener {
        private FullScreenListener() {
        }

        public DockElement getTreeLocation() {
            return SplitDockStation.this;
        }

        public boolean process(Dockable dockable, MouseEvent mouseEvent) {
            if (mouseEvent.isConsumed() || !SplitDockStation.this.isExpandOnDoubleclick()) {
                return false;
            }
            if (dockable == SplitDockStation.this) {
                return false;
            }
            if ((dockable = this.unwrap(dockable)) != null) {
                if (SplitDockStation.this.isFullScreen()) {
                    if (SplitDockStation.this.getFullScreen() == dockable) {
                        SplitDockStation.this.setFullScreen(null);
                        mouseEvent.consume();
                    }
                } else {
                    SplitDockStation.this.setFullScreen(dockable);
                    mouseEvent.consume();
                }
                return true;
            }
            return false;
        }

        private Dockable unwrap(Dockable dockable) {
            while (dockable.getDockParent() != SplitDockStation.this) {
                DockStation dockStation = dockable.getDockParent();
                if (dockStation == null) {
                    return null;
                }
                dockable = dockStation.asDockable();
                if (dockable != null) continue;
                return null;
            }
            return dockable;
        }
    }

    private class DividerListener
    extends MouseInputAdapter {
        private Node current;
        private double divider;
        private boolean pressed = false;
        private Rectangle bounds = new Rectangle();
        private int deltaX;
        private int deltaY;

        private DividerListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (SplitDockStation.this.isResizingEnabled() && !this.pressed) {
                this.pressed = true;
                this.mouseMoved(mouseEvent);
                if (this.current != null) {
                    this.divider = this.current.getDividerAt(mouseEvent.getX() + this.deltaX, mouseEvent.getY() + this.deltaY);
                    SplitDockStation.this.repaint(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
                    this.bounds = this.current.getDividerBounds(this.divider, this.bounds);
                    SplitDockStation.this.repaint(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
                }
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (SplitDockStation.this.isResizingEnabled() && this.pressed && this.current != null) {
                this.divider = this.current.getDividerAt(mouseEvent.getX() + this.deltaX, mouseEvent.getY() + this.deltaY);
                this.divider = ((SplitLayoutManager)SplitDockStation.this.layoutManager.getValue()).validateDivider(SplitDockStation.this, this.divider, this.current);
                SplitDockStation.this.repaint(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
                this.bounds = this.current.getDividerBounds(this.divider, this.bounds);
                SplitDockStation.this.repaint(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
                if (SplitDockStation.this.continousDisplay && this.current != null) {
                    this.current.setDivider(this.divider);
                    SplitDockStation.this.updateBounds();
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.pressed) {
                this.pressed = false;
                if (this.current != null) {
                    this.current.setDivider(this.divider);
                    SplitDockStation.this.repaint(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
                    SplitDockStation.this.updateBounds();
                }
                SplitDockStation.this.setCursor(null);
                this.mouseMoved(mouseEvent);
                SplitDockStation.this.checkMousePositionAsync();
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (SplitDockStation.this.isResizingEnabled()) {
                this.current = SplitDockStation.this.root().getDividerNode(mouseEvent.getX(), mouseEvent.getY());
                if (this.current == null) {
                    SplitDockStation.this.setCursor(null);
                } else if (this.current.getOrientation() == Orientation.HORIZONTAL) {
                    SplitDockStation.this.setCursor(Cursor.getPredefinedCursor(10));
                } else {
                    SplitDockStation.this.setCursor(Cursor.getPredefinedCursor(8));
                }
                if (this.current != null) {
                    this.bounds = this.current.getDividerBounds(this.current.getDivider(), this.bounds);
                    this.deltaX = this.bounds.width / 2 + this.bounds.x - mouseEvent.getX();
                    this.deltaY = this.bounds.height / 2 + this.bounds.y - mouseEvent.getY();
                }
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (SplitDockStation.this.isResizingEnabled() && !this.pressed) {
                this.current = null;
                SplitDockStation.this.setCursor(null);
            }
        }

        public void paint(Graphics graphics) {
            if (SplitDockStation.this.isResizingEnabled() && this.current != null && this.pressed) {
                SplitDockStation.this.getPaint().drawDivider(graphics, SplitDockStation.this, this.bounds);
            }
        }
    }

    private class VisibleListener
    extends DockStationAdapter {
        private VisibleListener() {
        }

        public void dockableVisibiltySet(DockStation dockStation, Dockable dockable, boolean bl) {
            SplitDockStation.this.visibility.fire();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Orientation {
        HORIZONTAL,
        VERTICAL;

    }

    private class Content
    extends JPanel {
        private Content() {
        }

        public void doLayout() {
            SplitDockStation.this.updateBounds();
            Insets insets = this.getInsets();
            if (SplitDockStation.this.fullScreenDockable != null) {
                SplitDockStation.this.fullScreenDockable.getDisplayer().getComponent().setBounds(insets.left, insets.top, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.bottom - insets.top);
            }
        }
    }
}

