/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.control;

import bibliothek.gui.DockController;
import bibliothek.gui.dock.DockElementRepresentative;
import bibliothek.gui.dock.event.ComponentHierarchyObserverEvent;
import bibliothek.gui.dock.event.ComponentHierarchyObserverListener;
import bibliothek.gui.dock.event.DockControllerRepresentativeListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentHierarchyObserver {
    private Set<Component> roots = new HashSet<Component>();
    private Set<Component> components = new HashSet<Component>();
    private Listener listener = new Listener();
    private DockController controller;
    private List<ComponentHierarchyObserverListener> listeners = new ArrayList<ComponentHierarchyObserverListener>();

    public ComponentHierarchyObserver(DockController dockController) {
        this.controller = dockController;
        dockController.addRepresentativeListener(new DockControllerRepresentativeListener(){

            public void representativeAdded(DockController dockController, DockElementRepresentative dockElementRepresentative) {
                ComponentHierarchyObserver.this.add(dockElementRepresentative.getComponent());
            }

            public void representativeRemoved(DockController dockController, DockElementRepresentative dockElementRepresentative) {
                ComponentHierarchyObserver.this.remove(dockElementRepresentative.getComponent());
            }
        });
    }

    public Set<Component> getComponents() {
        return Collections.unmodifiableSet(this.components);
    }

    public DockController getController() {
        return this.controller;
    }

    public void addListener(ComponentHierarchyObserverListener componentHierarchyObserverListener) {
        if (componentHierarchyObserverListener == null) {
            throw new NullPointerException("listener must not be null");
        }
        this.listeners.add(componentHierarchyObserverListener);
    }

    public void removeListener(ComponentHierarchyObserverListener componentHierarchyObserverListener) {
        this.listeners.remove(componentHierarchyObserverListener);
    }

    protected ComponentHierarchyObserverListener[] listeners() {
        return this.listeners.toArray(new ComponentHierarchyObserverListener[this.listeners.size()]);
    }

    public void add(Component component) {
        this.roots.add(component);
        this.add(component, null);
    }

    private void add(Component component, List<Component> list) {
        Object object;
        boolean bl;
        boolean bl2 = bl = list == null;
        if (bl) {
            list = new LinkedList<Component>();
        }
        if (this.components.add(component)) {
            list.add(component);
            if (component instanceof Container) {
                object = (Container)component;
                ((Container)object).addContainerListener(this.listener);
                int n = ((Container)object).getComponentCount();
                for (int i = 0; i < n; ++i) {
                    this.add(((Container)object).getComponent(i), list);
                }
            }
        }
        if (bl && !list.isEmpty()) {
            list = Collections.unmodifiableList(list);
            object = new ComponentHierarchyObserverEvent(this.controller, list);
            for (ComponentHierarchyObserverListener componentHierarchyObserverListener : this.listeners()) {
                componentHierarchyObserverListener.added((ComponentHierarchyObserverEvent)object);
            }
        }
    }

    public void remove(Component component) {
        this.roots.remove(component);
        this.remove(component, null);
    }

    private void remove(Component component, List<Component> list) {
        if (!this.roots.contains(component)) {
            Object object;
            boolean bl;
            boolean bl2 = bl = list == null;
            if (bl) {
                list = new LinkedList<Component>();
            }
            if (this.components.remove(component)) {
                list.add(component);
                if (component instanceof Container) {
                    object = (Container)component;
                    ((Container)object).removeContainerListener(this.listener);
                    int n = ((Container)object).getComponentCount();
                    for (int i = 0; i < n; ++i) {
                        this.remove(((Container)object).getComponent(i), list);
                    }
                }
            }
            if (bl && !list.isEmpty()) {
                list = Collections.unmodifiableList(list);
                object = new ComponentHierarchyObserverEvent(this.controller, list);
                for (ComponentHierarchyObserverListener componentHierarchyObserverListener : this.listeners()) {
                    componentHierarchyObserverListener.removed((ComponentHierarchyObserverEvent)object);
                }
            }
        }
    }

    private class Listener
    implements ContainerListener {
        private Listener() {
        }

        public void componentAdded(ContainerEvent containerEvent) {
            ComponentHierarchyObserver.this.add(containerEvent.getChild(), null);
        }

        public void componentRemoved(ContainerEvent containerEvent) {
            ComponentHierarchyObserver.this.remove(containerEvent.getChild(), null);
        }
    }
}

