/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.layout;

import bibliothek.gui.dock.layout.DockLayoutComposition;
import bibliothek.gui.dock.layout.DockLayoutInfo;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.layout.LocationEstimationMap;
import java.util.ArrayList;
import java.util.List;

public class DefaultLocationEstimationMap
implements LocationEstimationMap {
    private Node root;

    public DefaultLocationEstimationMap(DockLayoutComposition dockLayoutComposition) {
        this(new Node(dockLayoutComposition, false));
    }

    private DefaultLocationEstimationMap(Node node) {
        this.root = node;
        node.prepare();
    }

    public DefaultLocationEstimationMap subMap(int n) {
        return new DefaultLocationEstimationMap(this.root.children.get(n));
    }

    public DockLayoutComposition getRoot() {
        return this.root.composition;
    }

    public void finish() {
        for (Node node : this.root.children) {
            DockableProperty dockableProperty = node.validLocation();
            for (Node node2 : node.leafs) {
                DockableProperty dockableProperty2 = node2.validLocation();
                if (dockableProperty2 == null && dockableProperty != null) {
                    dockableProperty2 = dockableProperty.copy();
                }
                if (dockableProperty2 != null) {
                    dockableProperty2.setSuccessor(node2.oldLocation);
                    node2.composition.getLayout().setLocation(dockableProperty2);
                    continue;
                }
                node2.invalidate();
            }
        }
    }

    public int getChildCount() {
        return this.root.children.size();
    }

    public DockLayoutInfo getChild(int n) {
        if (n < 0 || n >= this.getChildCount()) {
            return null;
        }
        return this.root.children.get((int)n).composition.getLayout();
    }

    public int getSubChildCount(int n) {
        return this.root.children.get((int)n).leafs.size();
    }

    public DockLayoutInfo getSubChild(int n, int n2) {
        return this.root.children.get((int)n).leafs.get((int)n2).composition.getLayout();
    }

    public void setLocation(int n, DockableProperty dockableProperty) {
        if (dockableProperty != null) {
            this.getChild(n).setLocation(dockableProperty);
        }
    }

    public void setLocation(int n, int n2, DockableProperty dockableProperty) {
        if (dockableProperty != null) {
            this.getSubChild(n, n2).setLocation(dockableProperty);
        }
    }

    private static class Node {
        public final DockLayoutComposition composition;
        private DockableProperty oldLocation;
        private boolean valid = true;
        public final List<Node> children = new ArrayList<Node>();
        public final List<Node> leafs;

        public Node(DockLayoutComposition dockLayoutComposition, boolean bl) {
            this.leafs = bl ? new ArrayList<Node>() : null;
            this.composition = dockLayoutComposition;
            for (DockLayoutComposition dockLayoutComposition2 : dockLayoutComposition.getChildren()) {
                Node node = new Node(dockLayoutComposition2, true);
                this.children.add(node);
                if (!bl) continue;
                if (node.isLeaf()) {
                    this.leafs.add(node);
                    continue;
                }
                this.leafs.addAll(node.leafs);
            }
        }

        public boolean isLeaf() {
            return this.children.isEmpty();
        }

        public void prepare() {
            if (this.valid) {
                this.oldLocation = this.composition.getLayout().getLocation();
                for (Node node : this.children) {
                    node.prepare();
                }
            }
        }

        public void invalidate() {
            this.valid = false;
        }

        public DockableProperty validLocation() {
            DockableProperty dockableProperty = this.composition.getLayout().getLocation();
            if (dockableProperty != this.oldLocation) {
                return dockableProperty;
            }
            return null;
        }
    }
}

