/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.layout;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.DockFactory;
import bibliothek.gui.dock.dockable.DefaultDockableFactory;
import bibliothek.gui.dock.layout.AdjacentDockFactory;
import bibliothek.gui.dock.layout.DefaultLocationEstimationMap;
import bibliothek.gui.dock.layout.DockLayout;
import bibliothek.gui.dock.layout.DockLayoutComposition;
import bibliothek.gui.dock.layout.DockLayoutInfo;
import bibliothek.gui.dock.layout.DockSituationIgnore;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.layout.MissingDockFactory;
import bibliothek.gui.dock.security.SecureFlapDockStationFactory;
import bibliothek.gui.dock.security.SecureSplitDockStationFactory;
import bibliothek.gui.dock.security.SecureStackDockStationFactory;
import bibliothek.gui.dock.station.flap.FlapDockStationFactory;
import bibliothek.gui.dock.station.split.SplitDockStationFactory;
import bibliothek.gui.dock.station.stack.StackDockStationFactory;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.util.Path;
import bibliothek.util.Version;
import bibliothek.util.xml.XAttribute;
import bibliothek.util.xml.XElement;
import bibliothek.util.xml.XException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DockSituation {
    private Map<String, DockFactory<?, ?>> factories = new HashMap();
    private MissingDockFactory missingFactory;
    private Map<String, AdjacentDockFactory<?>> adjacent = new HashMap();
    private MissingDockFactory missingAdjacent;
    private DockSituationIgnore ignore;
    private PlaceholderStrategy placeholders;

    public DockSituation(DockFactory<?, ?> ... dockFactoryArray) {
        for (DockFactory<?, ?> dockFactory : dockFactoryArray) {
            this.factories.put(this.getID(dockFactory), dockFactory);
        }
    }

    public DockSituation() {
        this(new DefaultDockableFactory(), new SplitDockStationFactory(), new SecureSplitDockStationFactory(), new StackDockStationFactory(), new SecureStackDockStationFactory(), new FlapDockStationFactory(), new SecureFlapDockStationFactory());
    }

    public void setIgnore(DockSituationIgnore dockSituationIgnore) {
        this.ignore = dockSituationIgnore;
    }

    public DockSituationIgnore getIgnore() {
        return this.ignore;
    }

    public void setPlaceholderStrategy(PlaceholderStrategy placeholderStrategy) {
        this.placeholders = placeholderStrategy;
    }

    public PlaceholderStrategy getPlaceholderStrategy() {
        return this.placeholders;
    }

    protected Path getPlaceholder(DockElement dockElement) {
        if (this.placeholders == null) {
            return null;
        }
        Dockable dockable = dockElement.asDockable();
        if (dockable == null) {
            return null;
        }
        return this.placeholders.getPlaceholderFor(dockable);
    }

    public void add(DockFactory<?, ?> dockFactory) {
        this.factories.put(this.getID(dockFactory), dockFactory);
    }

    public void addAdjacent(AdjacentDockFactory<?> adjacentDockFactory) {
        this.adjacent.put(this.getAdjacentID(adjacentDockFactory), adjacentDockFactory);
    }

    public void setMissingFactory(MissingDockFactory missingDockFactory) {
        this.missingFactory = missingDockFactory;
    }

    public MissingDockFactory getMissingFactory() {
        return this.missingFactory;
    }

    public void setMissingAdjacentFactory(MissingDockFactory missingDockFactory) {
        this.missingAdjacent = missingDockFactory;
    }

    public MissingDockFactory getMissingAdjacentFactory() {
        return this.missingAdjacent;
    }

    public DockLayoutComposition convert(DockElement dockElement) {
        Object object;
        if (this.ignoreElement(dockElement)) {
            return null;
        }
        String string = this.getID(dockElement);
        DockFactory<DockElement, ?> dockFactory = this.getFactory(string);
        if (dockFactory == null) {
            throw new IllegalArgumentException("Unknown factory-id: " + dockElement.getFactoryID());
        }
        DockStation dockStation = dockElement.asDockStation();
        HashMap<Dockable, Integer> hashMap = new HashMap<Dockable, Integer>();
        ArrayList<DockLayoutComposition> arrayList = new ArrayList<DockLayoutComposition>();
        boolean bl = false;
        if (dockStation != null && !(bl = this.ignoreChildren(dockStation))) {
            int n = 0;
            int n2 = dockStation.getDockableCount();
            for (int i = 0; i < n2; ++i) {
                object = dockStation.getDockable(i);
                DockLayoutComposition object2 = this.convert((DockElement)object);
                if (object2 == null) continue;
                arrayList.add(object2);
                hashMap.put((Dockable)object, n++);
            }
        }
        Object l = dockFactory.getLayout(dockElement, hashMap);
        DockLayout dockLayout = new DockLayout(string, l);
        ArrayList arrayList2 = null;
        for (AdjacentDockFactory adjacentDockFactory : this.adjacent.values()) {
            if (!adjacentDockFactory.interested(dockElement)) continue;
            Object l2 = adjacentDockFactory.getLayout(dockElement, hashMap);
            if (arrayList2 == null) {
                arrayList2 = new ArrayList();
            }
            arrayList2.add(new DockLayout(this.getAdjacentID(adjacentDockFactory), l2));
        }
        object = new DockLayoutInfo(dockLayout);
        ((DockLayoutInfo)object).setPlaceholder(this.getPlaceholder(dockElement));
        return new DockLayoutComposition((DockLayoutInfo)object, arrayList2, arrayList, bl);
    }

    public DockElement convert(DockLayoutComposition dockLayoutComposition) {
        AdjacentDockFactory<?> adjacentDockFactory;
        Iterator iterator;
        Object object;
        DockLayoutInfo dockLayoutInfo = dockLayoutComposition.getLayout();
        if (dockLayoutInfo == null) {
            return null;
        }
        DockLayout<?> dockLayout = dockLayoutInfo.getDataLayout();
        if (dockLayout == null) {
            return null;
        }
        DockFactory<DockElement, ?> dockFactory = this.getFactory(dockLayout.getFactoryID());
        if (dockFactory == null) {
            return null;
        }
        DockElement dockElement = null;
        HashMap<Integer, Dockable> hashMap = null;
        if (dockLayoutComposition.isIgnoreChildren()) {
            object = dockLayoutComposition.getChildren().iterator();
            while (object.hasNext()) {
                iterator = object.next();
                this.convert((DockLayoutComposition)((Object)iterator));
            }
            dockElement = dockFactory.layout(dockLayout.getData());
        } else {
            hashMap = new HashMap<Integer, Dockable>();
            int n = 0;
            for (DockLayoutComposition object2 : dockLayoutComposition.getChildren()) {
                Dockable dockable;
                adjacentDockFactory = this.convert(object2);
                if (adjacentDockFactory != null && (dockable = adjacentDockFactory.asDockable()) != null) {
                    hashMap.put(n, dockable);
                }
                ++n;
            }
            dockElement = dockFactory.layout(dockLayout.getData(), hashMap);
        }
        if (dockElement != null && (object = dockLayoutComposition.getAdjacent()) != null) {
            iterator = object.iterator();
            while (iterator.hasNext()) {
                DockLayout dockLayout2 = (DockLayout)iterator.next();
                adjacentDockFactory = this.getAdjacentFactory(dockLayout2.getFactoryID());
                if (adjacentDockFactory == null) continue;
                if (hashMap == null) {
                    adjacentDockFactory.setLayout(dockElement, dockLayout2.getData());
                    continue;
                }
                adjacentDockFactory.setLayout(dockElement, dockLayout2.getData(), hashMap);
            }
        }
        return dockElement;
    }

    public void writeComposition(DockLayoutComposition dockLayoutComposition, DataOutputStream dataOutputStream) throws IOException {
        Version.write(dataOutputStream, Version.VERSION_1_0_8);
        this.writeCompositionStream(dockLayoutComposition, dataOutputStream);
    }

    private void writeCompositionStream(DockLayoutComposition dockLayoutComposition, DataOutputStream dataOutputStream) throws IOException {
        AdjacentDockFactory<?> adjacentDockFactory;
        Object object;
        Object object2;
        DockLayout<?> dockLayout;
        DockLayoutInfo dockLayoutInfo = dockLayoutComposition.getLayout();
        Path path = dockLayoutInfo.getPlaceholder();
        dataOutputStream.writeBoolean(path != null);
        if (path != null) {
            dataOutputStream.writeUTF(path.toString());
        }
        if (dockLayoutInfo.getKind() == DockLayoutInfo.Data.BYTE) {
            dataOutputStream.write(dockLayoutInfo.getDataByte());
        } else if (dockLayoutInfo.getKind() == DockLayoutInfo.Data.DOCK_LAYOUT) {
            dockLayout = dockLayoutInfo.getDataLayout();
            object2 = this.getFactory(dockLayout.getFactoryID());
            if (object2 == null) {
                throw new IOException("Missing factory: " + dockLayout.getFactoryID());
            }
            dataOutputStream.writeUTF(this.getID((DockFactory<?, ?>)object2));
            object = new ByteArrayOutputStream();
            adjacentDockFactory = new DataOutputStream((OutputStream)object);
            object2.write(dockLayout.getData(), (DataOutputStream)((Object)adjacentDockFactory));
            ((FilterOutputStream)((Object)adjacentDockFactory)).close();
            dataOutputStream.writeInt(((ByteArrayOutputStream)object).size());
            ((ByteArrayOutputStream)object).writeTo(dataOutputStream);
        } else {
            throw new IllegalArgumentException("Cannot store layout in stream: it was never translated and its raw format is not a byte stream");
        }
        dockLayout = dockLayoutComposition.getAdjacent();
        if (dockLayout == null) {
            dataOutputStream.writeInt(0);
        } else {
            dataOutputStream.writeInt(dockLayout.size());
            object2 = dockLayout.iterator();
            while (object2.hasNext()) {
                object = (DockLayout)object2.next();
                adjacentDockFactory = this.getAdjacentFactory(((DockLayout)object).getFactoryID());
                if (adjacentDockFactory == null) {
                    throw new IOException("Missing adjacent factory: " + ((DockLayout)object).getFactoryID());
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream2 = new DataOutputStream(byteArrayOutputStream);
                adjacentDockFactory.write(((DockLayout)object).getData(), dataOutputStream2);
                dataOutputStream2.close();
                dataOutputStream.writeUTF(this.getAdjacentID(adjacentDockFactory));
                dataOutputStream.writeInt(byteArrayOutputStream.size());
                byteArrayOutputStream.writeTo(dataOutputStream);
            }
        }
        dataOutputStream.writeBoolean(dockLayoutComposition.isIgnoreChildren());
        object2 = dockLayoutComposition.getChildren();
        dataOutputStream.writeInt(object2.size());
        object = object2.iterator();
        while (object.hasNext()) {
            adjacentDockFactory = object.next();
            this.writeCompositionStream((DockLayoutComposition)((Object)adjacentDockFactory), dataOutputStream);
        }
    }

    public DockLayoutComposition readComposition(DataInputStream dataInputStream) throws IOException {
        Version version = Version.read(dataInputStream);
        version.checkCurrent();
        return this.readCompositionStream(dataInputStream, version);
    }

    private DockLayoutComposition readCompositionStream(DataInputStream dataInputStream, Version version) throws IOException {
        int n;
        int n2;
        Path path = null;
        if (Version.VERSION_1_0_8.compareTo(version) <= 0 && dataInputStream.readBoolean()) {
            path = new Path(dataInputStream.readUTF());
        }
        byte[] byArray = this.readBuffer(dataInputStream);
        DockLayoutInfo dockLayoutInfo = this.readEntry(byArray, path);
        ArrayList arrayList = null;
        if (Version.VERSION_1_0_7.compareTo(version) <= 0 && (n2 = dataInputStream.readInt()) > 0) {
            arrayList = new ArrayList(n2);
            for (int i = 0; i < n2; ++i) {
                Object object;
                DataInputStream dataInputStream2;
                String string = dataInputStream.readUTF();
                AdjacentDockFactory<?> adjacentDockFactory = this.getAdjacentFactory(string);
                if (adjacentDockFactory == null) {
                    if (this.missingAdjacent == null) {
                        int n3;
                        for (n = dataInputStream.readInt(); n > 0; n -= n3) {
                            n3 = (int)dataInputStream.skip(n);
                            if (n3 > 0) continue;
                            throw new EOFException();
                        }
                        continue;
                    }
                    dataInputStream2 = this.readBuffer(dataInputStream, n);
                    object = this.missingAdjacent.read(this.getAdjacentFactoryID(string), dataInputStream2, n);
                    if (object != null) {
                        arrayList.add(new DockLayout(string, object));
                    }
                    dataInputStream2.close();
                    continue;
                }
                dataInputStream2 = this.readBuffer(dataInputStream, n);
                object = adjacentDockFactory.read(dataInputStream2, this.placeholders);
                if (object != null) {
                    arrayList.add(new DockLayout(string, object));
                }
                dataInputStream2.close();
            }
        }
        n2 = dataInputStream.readBoolean() ? 1 : 0;
        ArrayList<DockLayoutComposition> arrayList2 = new ArrayList<DockLayoutComposition>();
        int n4 = dataInputStream.readInt();
        for (n = 0; n < n4; ++n) {
            arrayList2.add(this.readCompositionStream(dataInputStream, version));
        }
        return new DockLayoutComposition(dockLayoutInfo, arrayList, arrayList2, n2 != 0);
    }

    private DockLayoutInfo readEntry(byte[] byArray, Path path) throws IOException {
        DockLayoutInfo dockLayoutInfo;
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        String string = dataInputStream.readUTF();
        DockFactory<DockElement, ?> dockFactory = this.getFactory(string);
        int n = dataInputStream.readInt();
        if (dockFactory == null) {
            dockLayoutInfo = null;
            if (this.missingFactory != null) {
                Object object = this.missingFactory.read(this.getFactoryID(string), dataInputStream, n);
                dataInputStream.close();
                if (object != null) {
                    dockLayoutInfo = new DockLayoutInfo(new DockLayout<Object>(string, object));
                    dockLayoutInfo.setPlaceholder(path);
                }
            }
            if (dockLayoutInfo == null) {
                dockLayoutInfo = new DockLayoutInfo(byArray);
                dockLayoutInfo.setPlaceholder(path);
            }
        } else {
            Object l = dockFactory.read(dataInputStream, this.placeholders);
            if (l == null) {
                dockLayoutInfo = null;
            } else {
                dockLayoutInfo = new DockLayoutInfo(new DockLayout(string, l));
                dockLayoutInfo.setPlaceholder(path);
            }
            dataInputStream.close();
        }
        return dockLayoutInfo;
    }

    private DataInputStream readBuffer(DataInputStream dataInputStream, int n) throws IOException {
        int n2;
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; i += n2) {
            n2 = dataInputStream.read(byArray, i, n - i);
            if (n2 >= 0) continue;
            throw new EOFException();
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream2 = new DataInputStream(byteArrayInputStream);
        return dataInputStream2;
    }

    private byte[] readBuffer(DataInputStream dataInputStream) throws IOException {
        String string = dataInputStream.readUTF();
        int n = dataInputStream.readInt();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(string.length() * 4 + 4 + n);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeUTF(string);
        dataOutputStream.writeInt(n);
        for (int i = 0; i < n; ++i) {
            int n2 = dataInputStream.read();
            if (n2 == -1) {
                throw new EOFException("unexpectetly reached end of file");
            }
            dataOutputStream.write(n2);
        }
        dataOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] write(Map<String, DockStation> map) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        this.write(map, dataOutputStream);
        dataOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public void write(Map<String, DockStation> map, DataOutputStream dataOutputStream) throws IOException {
        Version.write(dataOutputStream, Version.VERSION_1_0_4);
        dataOutputStream.writeInt(map.size());
        for (Map.Entry<String, DockStation> entry : map.entrySet()) {
            DockLayoutComposition dockLayoutComposition = this.convert(entry.getValue());
            if (dockLayoutComposition == null) continue;
            dataOutputStream.writeUTF(entry.getKey());
            this.writeComposition(dockLayoutComposition, dataOutputStream);
        }
    }

    public Map<String, DockStation> read(byte[] byArray) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        Map<String, DockStation> map = this.read(dataInputStream);
        dataInputStream.close();
        return map;
    }

    public Map<String, DockStation> read(DataInputStream dataInputStream) throws IOException {
        Version version = Version.read(dataInputStream);
        version.checkCurrent();
        int n = dataInputStream.readInt();
        HashMap<String, DockStation> hashMap = new HashMap<String, DockStation>();
        for (int i = 0; i < n; ++i) {
            DockStation dockStation;
            String string = dataInputStream.readUTF();
            DockLayoutComposition dockLayoutComposition = this.readComposition(dataInputStream);
            DockElement dockElement = dockLayoutComposition == null ? null : this.convert(dockLayoutComposition);
            DockStation dockStation2 = dockStation = dockElement == null ? null : dockElement.asDockStation();
            if (dockStation == null) continue;
            hashMap.put(string, dockStation);
        }
        return hashMap;
    }

    public void writeCompositionXML(DockLayoutComposition dockLayoutComposition, XElement xElement) {
        AdjacentDockFactory<?> adjacentDockFactory;
        Iterator<DockLayoutComposition> iterator;
        DockFactory<? extends DockElement, ?> dockFactory;
        DockLayout<?> dockLayout;
        DockLayoutInfo dockLayoutInfo = dockLayoutComposition.getLayout();
        if (dockLayoutInfo.getKind() == DockLayoutInfo.Data.XML) {
            xElement.addElement(dockLayoutInfo.getDataXML());
        } else if (dockLayoutInfo.getKind() == DockLayoutInfo.Data.DOCK_LAYOUT) {
            dockLayout = dockLayoutInfo.getDataLayout();
            dockFactory = this.getFactory(dockLayout.getFactoryID());
            if (dockFactory == null) {
                throw new IllegalArgumentException("Missing factory: " + dockLayout.getFactoryID());
            }
            iterator = xElement.addElement("layout");
            ((XElement)((Object)iterator)).addString("factory", this.getID(dockFactory));
            Path object2 = dockLayoutInfo.getPlaceholder();
            if (object2 != null) {
                ((XElement)((Object)iterator)).addString("placeholder", object2.toString());
            }
            dockFactory.write(dockLayout.getData(), (XElement)((Object)iterator));
        } else {
            throw new IllegalArgumentException("Cannot store layout as XML: it was never translated and its raw format is not XML");
        }
        dockLayout = dockLayoutComposition.getAdjacent();
        if (dockLayout != null) {
            dockFactory = xElement.addElement("adjacent");
            iterator = dockLayout.iterator();
            while (iterator.hasNext()) {
                DockLayout dockLayout2 = (DockLayout)iterator.next();
                adjacentDockFactory = this.getAdjacentFactory(dockLayout2.getFactoryID());
                if (adjacentDockFactory == null) {
                    throw new IllegalArgumentException("Missing adjacent factory: " + dockLayout2.getFactoryID());
                }
                XElement xElement2 = ((XElement)((Object)dockFactory)).addElement("layout");
                xElement2.addString("factory", this.getAdjacentID(adjacentDockFactory));
                adjacentDockFactory.write(dockLayout2.getData(), xElement2);
            }
        }
        dockFactory = xElement.addElement("children");
        ((XElement)((Object)dockFactory)).addBoolean("ignore", dockLayoutComposition.isIgnoreChildren());
        for (DockLayoutComposition dockLayoutComposition2 : dockLayoutComposition.getChildren()) {
            adjacentDockFactory = ((XElement)((Object)dockFactory)).addElement("child");
            this.writeCompositionXML(dockLayoutComposition2, (XElement)((Object)adjacentDockFactory));
        }
    }

    public DockLayoutComposition readCompositionXML(XElement xElement) {
        XElement xElement2 = xElement.getElement("layout");
        DockLayoutInfo dockLayoutInfo = this.readEntry(xElement2);
        XElement xElement3 = xElement.getElement("adjacent");
        ArrayList arrayList = null;
        if (xElement3 != null) {
            arrayList = new ArrayList();
            for (XElement xElementArray : xElement3.getElements("layout")) {
                Object object;
                String string = xElementArray.getString("factory");
                AdjacentDockFactory<?> adjacentDockFactory = this.getAdjacentFactory(string);
                if (adjacentDockFactory != null) {
                    Object l = adjacentDockFactory.read(xElementArray, this.placeholders);
                    if (l == null) continue;
                    arrayList.add(new DockLayout(string, l));
                    continue;
                }
                if (this.missingAdjacent == null || (object = this.missingAdjacent.readXML(this.getAdjacentFactoryID(string), xElementArray)) == null) continue;
                arrayList.add(new DockLayout<Object>(string, object));
            }
        }
        XElement[] xElementArray = xElement.getElement("children");
        int n = 1;
        ArrayList<DockLayoutComposition> arrayList2 = new ArrayList<DockLayoutComposition>();
        if (xElementArray != null) {
            n = xElementArray.getBoolean("ignore") ? 1 : 0;
            for (XElement xElement4 : xElementArray.getElements("child")) {
                arrayList2.add(this.readCompositionXML(xElement4));
            }
        }
        return new DockLayoutComposition(dockLayoutInfo, arrayList, arrayList2, n != 0);
    }

    private DockLayoutInfo readEntry(XElement xElement) {
        DockLayoutInfo dockLayoutInfo = null;
        if (xElement != null) {
            DockFactory<DockElement, ?> dockFactory;
            String string = xElement.getString("factory");
            Path path = null;
            XAttribute xAttribute = xElement.getAttribute("placeholder");
            if (xAttribute != null) {
                path = new Path(xAttribute.getString());
            }
            if ((dockFactory = this.getFactory(string)) != null) {
                Object l = dockFactory.read(xElement, this.placeholders);
                if (l != null) {
                    dockLayoutInfo = new DockLayoutInfo(new DockLayout(string, l));
                    dockLayoutInfo.setPlaceholder(path);
                }
            } else {
                Object object;
                dockLayoutInfo = null;
                if (this.missingFactory != null && (object = this.missingFactory.readXML(this.getFactoryID(string), xElement)) != null) {
                    dockLayoutInfo = new DockLayoutInfo(new DockLayout<Object>(string, object));
                    dockLayoutInfo.setPlaceholder(path);
                }
                if (dockLayoutInfo == null) {
                    dockLayoutInfo = new DockLayoutInfo(xElement);
                    dockLayoutInfo.setPlaceholder(path);
                }
            }
        }
        return dockLayoutInfo;
    }

    public void writeXML(Map<String, DockStation> map, XElement xElement) throws IOException {
        for (Map.Entry<String, DockStation> entry : map.entrySet()) {
            DockLayoutComposition dockLayoutComposition = this.convert(entry.getValue());
            if (dockLayoutComposition == null) continue;
            XElement xElement2 = xElement.addElement("element");
            xElement2.addString("name", entry.getKey());
            this.writeCompositionXML(dockLayoutComposition, xElement2);
        }
    }

    public Map<String, DockStation> readXML(XElement xElement) {
        HashMap<String, DockStation> hashMap = new HashMap<String, DockStation>();
        for (XElement xElement2 : xElement.getElements("element")) {
            DockStation dockStation;
            String string = xElement2.getString("name");
            DockLayoutComposition dockLayoutComposition = this.readCompositionXML(xElement2);
            DockElement dockElement = dockLayoutComposition == null ? null : this.convert(dockLayoutComposition);
            DockStation dockStation2 = dockStation = dockElement == null ? null : dockElement.asDockStation();
            if (dockStation == null) continue;
            hashMap.put(string, dockStation);
        }
        return hashMap;
    }

    public DockLayoutComposition fillMissing(DockLayoutComposition dockLayoutComposition) throws IOException, XException {
        ArrayList<DockLayoutComposition> arrayList;
        DockLayoutInfo dockLayoutInfo;
        DockLayoutInfo dockLayoutInfo2 = dockLayoutInfo = dockLayoutComposition.getLayout();
        if (dockLayoutInfo.getKind() == DockLayoutInfo.Data.BYTE) {
            if ((dockLayoutInfo = this.readEntry(dockLayoutInfo.getDataByte(), dockLayoutInfo.getPlaceholder())) != null && dockLayoutInfo.getKind() == DockLayoutInfo.Data.BYTE) {
                dockLayoutInfo = dockLayoutInfo2;
            }
        } else if (dockLayoutInfo.getKind() == DockLayoutInfo.Data.XML && (dockLayoutInfo = this.readEntry(dockLayoutInfo.getDataXML())) != null && dockLayoutInfo.getKind() == DockLayoutInfo.Data.XML) {
            dockLayoutInfo = dockLayoutInfo2;
        }
        if (dockLayoutInfo.getKind() == DockLayoutInfo.Data.DOCK_LAYOUT) {
            dockLayoutInfo = this.fillMissing(dockLayoutInfo);
        }
        boolean bl = dockLayoutInfo != dockLayoutInfo2;
        List<DockLayoutComposition> list = dockLayoutComposition.getChildren();
        if (list != null) {
            arrayList = new ArrayList<DockLayoutComposition>(list.size());
            for (DockLayoutComposition dockLayoutComposition2 : list) {
                DockLayoutComposition dockLayoutComposition3 = this.fillMissing(dockLayoutComposition2);
                arrayList.add(dockLayoutComposition3);
                if (dockLayoutComposition2 == dockLayoutComposition3) continue;
                bl = true;
            }
        } else {
            arrayList = null;
        }
        if (dockLayoutInfo != null && dockLayoutInfo != dockLayoutInfo2) {
            dockLayoutInfo.setLocation(dockLayoutInfo2.getLocation());
        }
        if (bl) {
            return new DockLayoutComposition(dockLayoutInfo, dockLayoutComposition.getAdjacent(), arrayList, dockLayoutComposition.isIgnoreChildren());
        }
        return dockLayoutComposition;
    }

    protected DockLayoutInfo fillMissing(DockLayoutInfo dockLayoutInfo) {
        return dockLayoutInfo;
    }

    public void estimateLocations(DockLayoutComposition dockLayoutComposition) {
        this.estimateLocations(dockLayoutComposition, dockLayoutComposition.getLayout().getLocation());
    }

    public void estimateLocations(DockLayoutComposition dockLayoutComposition, DockableProperty dockableProperty) {
        DefaultLocationEstimationMap defaultLocationEstimationMap = new DefaultLocationEstimationMap(dockLayoutComposition);
        this.estimateLocations(defaultLocationEstimationMap);
        defaultLocationEstimationMap.finish();
        if (dockableProperty != null) {
            this.appendFirstOnEstimate(dockLayoutComposition, dockableProperty);
        }
    }

    private void appendFirstOnEstimate(DockLayoutComposition dockLayoutComposition, DockableProperty dockableProperty) {
        DockLayoutInfo dockLayoutInfo = dockLayoutComposition.getLayout();
        DockableProperty dockableProperty2 = dockLayoutInfo.getLocation();
        if (dockableProperty2 != null) {
            dockLayoutInfo.setLocation(DockUtilities.append(dockableProperty2, dockableProperty));
        }
        for (DockLayoutComposition dockLayoutComposition2 : dockLayoutComposition.getChildren()) {
            this.appendFirstOnEstimate(dockLayoutComposition2, dockableProperty);
        }
    }

    protected void estimateLocations(DefaultLocationEstimationMap defaultLocationEstimationMap) {
        DockLayoutComposition dockLayoutComposition = defaultLocationEstimationMap.getRoot();
        List<DockLayoutComposition> list = dockLayoutComposition.getChildren();
        if (list == null || list.size() == 0) {
            return;
        }
        DockLayout<?> dockLayout = dockLayoutComposition.getLayout().getDataLayout();
        if (dockLayout == null) {
            return;
        }
        DockFactory<DockElement, ?> dockFactory = this.getFactory(dockLayout.getFactoryID());
        if (dockFactory == null) {
            return;
        }
        int n = defaultLocationEstimationMap.getChildCount();
        for (int i = 0; i < n; ++i) {
            DefaultLocationEstimationMap defaultLocationEstimationMap2 = defaultLocationEstimationMap.subMap(i);
            this.estimateLocations(defaultLocationEstimationMap2);
            defaultLocationEstimationMap2.finish();
        }
        dockFactory.estimateLocations(dockLayout.getData(), defaultLocationEstimationMap);
    }

    protected boolean ignoreElement(DockElement dockElement) {
        if (this.ignore == null) {
            return false;
        }
        return this.ignore.ignoreElement(dockElement);
    }

    protected boolean ignoreChildren(DockStation dockStation) {
        if (this.ignore == null) {
            return false;
        }
        return this.ignore.ignoreChildren(dockStation);
    }

    protected String getID(DockElement dockElement) {
        return dockElement.getFactoryID();
    }

    protected String getID(DockFactory<?, ?> dockFactory) {
        return dockFactory.getID();
    }

    protected String getFactoryID(DockLayoutInfo dockLayoutInfo) {
        if (dockLayoutInfo.getKind() == DockLayoutInfo.Data.BYTE) {
            try {
                DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(dockLayoutInfo.getDataByte()));
                String string = dataInputStream.readUTF();
                dataInputStream.close();
                return string;
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("byte entry not in the correct format", iOException);
            }
        }
        if (dockLayoutInfo.getKind() == DockLayoutInfo.Data.XML) {
            return dockLayoutInfo.getDataXML().getString("factory");
        }
        if (dockLayoutInfo.getKind() == DockLayoutInfo.Data.DOCK_LAYOUT) {
            return dockLayoutInfo.getDataLayout().getFactoryID();
        }
        return null;
    }

    public String convertFactoryId(DockFactory<?, ?> dockFactory) {
        return this.getID(dockFactory);
    }

    public String convertFactoryId(String string) {
        return this.getFactoryID(string);
    }

    protected String getFactoryID(String string) {
        return string;
    }

    protected String getAdjacentID(AdjacentDockFactory<?> adjacentDockFactory) {
        return adjacentDockFactory.getID();
    }

    protected String getAdjacentFactoryID(String string) {
        return string;
    }

    protected DockFactory<? extends DockElement, ?> getFactory(String string) {
        return this.factories.get(string);
    }

    protected AdjacentDockFactory<?> getAdjacentFactory(String string) {
        return this.adjacent.get(string);
    }
}

