/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.security;

import bibliothek.gui.DockController;
import bibliothek.gui.dock.control.ControllerSetupCollection;
import bibliothek.gui.dock.control.KeyboardController;
import bibliothek.gui.dock.event.ComponentHierarchyObserverEvent;
import bibliothek.gui.dock.event.ComponentHierarchyObserverListener;
import bibliothek.gui.dock.event.ControllerSetupListener;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.List;

public class SecureKeyboardController
extends KeyboardController {
    private Listener listener = new Listener();

    public SecureKeyboardController(DockController dockController, ControllerSetupCollection controllerSetupCollection) {
        super(dockController);
        controllerSetupCollection.add(new ControllerSetupListener(){

            public void done(DockController dockController) {
                dockController.getComponentHierarchyObserver().addListener(new ComponentHierarchyObserverListener(){

                    public void added(ComponentHierarchyObserverEvent componentHierarchyObserverEvent) {
                        List<Component> list = componentHierarchyObserverEvent.getComponents();
                        if (SecureKeyboardController.this.listener != null) {
                            for (Component component : list) {
                                component.addKeyListener(SecureKeyboardController.this.listener);
                            }
                        }
                    }

                    public void removed(ComponentHierarchyObserverEvent componentHierarchyObserverEvent) {
                        List<Component> list = componentHierarchyObserverEvent.getComponents();
                        if (SecureKeyboardController.this.listener != null) {
                            for (Component component : list) {
                                component.removeKeyListener(SecureKeyboardController.this.listener);
                            }
                        }
                    }
                });
            }
        });
    }

    public void kill() {
        if (this.listener != null) {
            for (Component component : this.getController().getComponentHierarchyObserver().getComponents()) {
                component.removeKeyListener(this.listener);
            }
            this.listener = null;
        }
    }

    private class Listener
    implements KeyListener {
        private Listener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            SecureKeyboardController.this.fireKeyPressed(keyEvent);
        }

        public void keyReleased(KeyEvent keyEvent) {
            SecureKeyboardController.this.fireKeyReleased(keyEvent);
        }

        public void keyTyped(KeyEvent keyEvent) {
            SecureKeyboardController.this.fireKeyTyped(keyEvent);
        }
    }
}

