/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.screen;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.ScreenDockStation;
import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.station.DockableDisplayerListener;
import bibliothek.gui.dock.station.StationChildHandle;
import bibliothek.gui.dock.station.screen.ScreenDockFullscreenStrategy;
import bibliothek.gui.dock.station.screen.ScreenDockWindow;
import bibliothek.gui.dock.station.screen.ScreenDockWindowListener;
import bibliothek.gui.dock.title.DockTitle;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;

public abstract class DisplayerScreenDockWindow
implements ScreenDockWindow {
    private ScreenDockStation station;
    private StationChildHandle handle;
    private List<ScreenDockWindowListener> listeners = new ArrayList<ScreenDockWindowListener>();
    private DockableDisplayerListener displayerListener = new DockableDisplayerListener(){

        public void discard(DockableDisplayer dockableDisplayer) {
            DisplayerScreenDockWindow.this.discardDisplayer();
        }
    };
    private DockController controller;
    private boolean showTitle = true;
    private ScreenDockFullscreenStrategy strategy;
    private Rectangle normalBounds;

    public DisplayerScreenDockWindow(ScreenDockStation screenDockStation) {
        if (screenDockStation == null) {
            throw new IllegalArgumentException("station must not be null");
        }
        this.station = screenDockStation;
    }

    public void addScreenDockWindowListener(ScreenDockWindowListener screenDockWindowListener) {
        this.listeners.add(screenDockWindowListener);
    }

    public void removeScreenDockWindowListener(ScreenDockWindowListener screenDockWindowListener) {
        this.listeners.remove(screenDockWindowListener);
    }

    protected ScreenDockWindowListener[] listeners() {
        return this.listeners.toArray(new ScreenDockWindowListener[this.listeners.size()]);
    }

    protected void fireFullscreenChanged() {
        for (ScreenDockWindowListener screenDockWindowListener : this.listeners()) {
            screenDockWindowListener.fullscreenStateChanged(this);
        }
    }

    protected void fireVisibilityChanged() {
        for (ScreenDockWindowListener screenDockWindowListener : this.listeners()) {
            screenDockWindowListener.visibilityChanged(this);
        }
    }

    protected void fireShapeChanged() {
        for (ScreenDockWindowListener screenDockWindowListener : this.listeners()) {
            screenDockWindowListener.shapeChanged(this);
        }
    }

    protected abstract void showDisplayer(DockableDisplayer var1);

    protected abstract Component getWindowComponent();

    public void setShowTitle(boolean bl) {
        if (this.showTitle != bl) {
            this.showTitle = bl;
            if (this.handle != null) {
                if (bl) {
                    this.handle.setTitleRequest(this.station.getTitleVersion());
                } else {
                    this.handle.setTitleRequest(null);
                }
            }
        }
    }

    public boolean isShowTitle() {
        return this.showTitle;
    }

    public Dockable getDockable() {
        if (this.handle == null) {
            return null;
        }
        return this.handle.getDockable();
    }

    public void setDockable(Dockable dockable) {
        DockableDisplayer dockableDisplayer;
        if (this.handle != null) {
            dockableDisplayer = this.handle.getDisplayer();
            dockableDisplayer.removeDockableDisplayerListener(this.displayerListener);
            this.handle.destroy();
            this.handle = null;
        }
        dockableDisplayer = null;
        if (dockable != null) {
            this.handle = new StationChildHandle(this.station, this.station.getDisplayers(), dockable, this.showTitle ? this.station.getTitleVersion() : null);
            this.handle.updateDisplayer();
            dockableDisplayer = this.handle.getDisplayer();
            dockableDisplayer.addDockableDisplayerListener(this.displayerListener);
        }
        this.showDisplayer(dockableDisplayer);
    }

    protected void discardDisplayer() {
        DockableDisplayer dockableDisplayer = this.handle.getDisplayer();
        dockableDisplayer.removeDockableDisplayerListener(this.displayerListener);
        this.handle.updateDisplayer();
        dockableDisplayer = this.handle.getDisplayer();
        dockableDisplayer.addDockableDisplayerListener(this.displayerListener);
        this.showDisplayer(dockableDisplayer);
    }

    public void setFullscreenStrategy(ScreenDockFullscreenStrategy screenDockFullscreenStrategy) {
        this.strategy = screenDockFullscreenStrategy;
    }

    public boolean isFullscreen() {
        if (this.strategy == null) {
            throw new IllegalStateException("no strategy available");
        }
        return this.strategy.isFullscreen(this);
    }

    public void setFullscreen(boolean bl) {
        if (this.strategy == null) {
            throw new IllegalStateException("no strategy available");
        }
        boolean bl2 = this.isFullscreen();
        if (bl2 != bl) {
            this.strategy.setFullscreen(this, bl);
            this.fireFullscreenChanged();
        }
    }

    public void setNormalBounds(Rectangle rectangle) {
        this.normalBounds = rectangle;
    }

    public Rectangle getNormalBounds() {
        return this.normalBounds;
    }

    public void setController(DockController dockController) {
        if (this.handle != null && this.controller != null) {
            this.handle.setTitleRequest(null);
        }
        this.controller = dockController;
        if (this.handle != null && this.controller != null && this.isShowTitle()) {
            this.handle.setTitleRequest(this.station.getTitleVersion());
        }
    }

    public Point getOffsetDrop() {
        if (this.handle == null) {
            return null;
        }
        DockableDisplayer dockableDisplayer = this.handle.getDisplayer();
        if (dockableDisplayer == null) {
            return null;
        }
        Insets insets = this.getDockableInsets();
        return new Point(insets.left, insets.top);
    }

    public Point getOffsetMove() {
        if (this.handle == null) {
            return null;
        }
        DockableDisplayer dockableDisplayer = this.handle.getDisplayer();
        if (dockableDisplayer == null) {
            return null;
        }
        DockTitle dockTitle = dockableDisplayer.getTitle();
        if (dockTitle == null) {
            return null;
        }
        Component component = this.getWindowComponent();
        if (component == null) {
            return null;
        }
        Point point = new Point(0, 0);
        point = SwingUtilities.convertPoint(dockTitle.getComponent(), point, component);
        return point;
    }

    public boolean inCombineArea(int n, int n2) {
        if (this.handle == null) {
            return false;
        }
        DockableDisplayer dockableDisplayer = this.handle.getDisplayer();
        if (dockableDisplayer == null) {
            return false;
        }
        Point point = new Point(n, n2);
        SwingUtilities.convertPointFromScreen(point, dockableDisplayer.getComponent());
        return dockableDisplayer.titleContains(point.x, point.y);
    }

    public DockController getController() {
        return this.controller;
    }

    public ScreenDockStation getStation() {
        return this.station;
    }
}

