/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.screen;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockFactory;
import bibliothek.gui.dock.ScreenDockStation;
import bibliothek.gui.dock.layout.DockLayoutInfo;
import bibliothek.gui.dock.layout.LocationEstimationMap;
import bibliothek.gui.dock.station.screen.RetroScreenDockStationLayout;
import bibliothek.gui.dock.station.screen.ScreenDockProperty;
import bibliothek.gui.dock.station.screen.ScreenDockStationLayout;
import bibliothek.gui.dock.station.support.ConvertedPlaceholderListItem;
import bibliothek.gui.dock.station.support.PlaceholderList;
import bibliothek.gui.dock.station.support.PlaceholderListItem;
import bibliothek.gui.dock.station.support.PlaceholderListItemAdapter;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.gui.dock.util.DirectWindowProvider;
import bibliothek.gui.dock.util.WindowProvider;
import bibliothek.util.Path;
import bibliothek.util.Version;
import bibliothek.util.xml.XElement;
import java.awt.Rectangle;
import java.awt.Window;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScreenDockStationFactory
implements DockFactory<ScreenDockStation, ScreenDockStationLayout> {
    public static final String ID = "screen dock";
    private WindowProvider owner;

    public ScreenDockStationFactory(Window window) {
        if (window == null) {
            throw new IllegalArgumentException("Owner must not be null");
        }
        this.owner = new DirectWindowProvider(window);
    }

    public ScreenDockStationFactory(WindowProvider windowProvider) {
        if (windowProvider == null) {
            throw new IllegalArgumentException("Owner must not be null");
        }
        this.owner = windowProvider;
    }

    @Deprecated
    public Window getOwner() {
        return this.owner.searchWindow();
    }

    public WindowProvider getProvider() {
        return this.owner;
    }

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public void estimateLocations(ScreenDockStationLayout screenDockStationLayout, final LocationEstimationMap locationEstimationMap) {
        if (screenDockStationLayout instanceof RetroScreenDockStationLayout) {
            RetroScreenDockStationLayout retroScreenDockStationLayout = (RetroScreenDockStationLayout)screenDockStationLayout;
            int n = retroScreenDockStationLayout.size();
            for (int i = 0; i < n; ++i) {
                DockLayoutInfo dockLayoutInfo = locationEstimationMap.getChild(retroScreenDockStationLayout.id(i));
                if (dockLayoutInfo == null) continue;
                ScreenDockProperty screenDockProperty = new ScreenDockProperty(retroScreenDockStationLayout.x(i), retroScreenDockStationLayout.y(i), retroScreenDockStationLayout.width(i), retroScreenDockStationLayout.height(i), null);
                dockLayoutInfo.setLocation(screenDockProperty);
            }
        } else {
            PlaceholderList.simulatedRead(screenDockStationLayout.getPlaceholders(), new PlaceholderListItemAdapter<PlaceholderListItem>(){

                @Override
                public PlaceholderListItem convert(ConvertedPlaceholderListItem convertedPlaceholderListItem) {
                    int n = convertedPlaceholderListItem.getInt("id");
                    int n2 = convertedPlaceholderListItem.getInt("x");
                    int n3 = convertedPlaceholderListItem.getInt("y");
                    int n4 = convertedPlaceholderListItem.getInt("width");
                    int n5 = convertedPlaceholderListItem.getInt("height");
                    boolean bl = convertedPlaceholderListItem.getBoolean("fullscreen");
                    Path path = null;
                    if (convertedPlaceholderListItem.contains("placeholder")) {
                        path = new Path(convertedPlaceholderListItem.getString("placeholder"));
                    }
                    ScreenDockProperty screenDockProperty = new ScreenDockProperty(n2, n3, n4, n5, path, bl);
                    locationEstimationMap.getChild(n).setLocation(screenDockProperty);
                    int n6 = locationEstimationMap.getSubChildCount(n);
                    for (int i = 0; i < n6; ++i) {
                        DockLayoutInfo dockLayoutInfo = locationEstimationMap.getSubChild(n, i);
                        dockLayoutInfo.setLocation(new ScreenDockProperty(n2, n3, n4, n5, dockLayoutInfo.getPlaceholder(), bl));
                    }
                    return null;
                }
            });
        }
    }

    @Override
    public ScreenDockStationLayout getLayout(ScreenDockStation screenDockStation, Map<Dockable, Integer> map) {
        return new ScreenDockStationLayout(screenDockStation.getPlaceholders(map));
    }

    @Override
    public void setLayout(ScreenDockStation screenDockStation, ScreenDockStationLayout screenDockStationLayout) {
    }

    @Override
    public void setLayout(ScreenDockStation screenDockStation, ScreenDockStationLayout screenDockStationLayout, Map<Integer, Dockable> map) {
        for (int i = screenDockStation.getDockableCount() - 1; i >= 0; --i) {
            screenDockStation.removeDockable(i);
        }
        if (screenDockStationLayout instanceof RetroScreenDockStationLayout) {
            RetroScreenDockStationLayout retroScreenDockStationLayout = (RetroScreenDockStationLayout)screenDockStationLayout;
            int n = retroScreenDockStationLayout.size();
            for (int i = 0; i < n; ++i) {
                Dockable dockable = map.get(retroScreenDockStationLayout.id(i));
                if (dockable == null) continue;
                Rectangle rectangle = new Rectangle(retroScreenDockStationLayout.x(i), retroScreenDockStationLayout.y(i), retroScreenDockStationLayout.width(i), retroScreenDockStationLayout.height(i));
                screenDockStation.addDockable(dockable, rectangle, true);
            }
        } else {
            screenDockStation.setPlaceholders(screenDockStationLayout.getPlaceholders(), map);
        }
    }

    @Override
    public ScreenDockStation layout(ScreenDockStationLayout screenDockStationLayout) {
        ScreenDockStation screenDockStation = this.createStation();
        this.setLayout(screenDockStation, screenDockStationLayout);
        return screenDockStation;
    }

    @Override
    public ScreenDockStation layout(ScreenDockStationLayout screenDockStationLayout, Map<Integer, Dockable> map) {
        ScreenDockStation screenDockStation = this.createStation();
        this.setLayout(screenDockStation, screenDockStationLayout, map);
        return screenDockStation;
    }

    @Override
    public void write(ScreenDockStationLayout screenDockStationLayout, DataOutputStream dataOutputStream) throws IOException {
        if (screenDockStationLayout instanceof RetroScreenDockStationLayout) {
            RetroScreenDockStationLayout retroScreenDockStationLayout = (RetroScreenDockStationLayout)screenDockStationLayout;
            Version.write(dataOutputStream, Version.VERSION_1_0_4);
            dataOutputStream.writeInt(retroScreenDockStationLayout.size());
            int n = retroScreenDockStationLayout.size();
            for (int i = 0; i < n; ++i) {
                dataOutputStream.writeInt(retroScreenDockStationLayout.id(i));
                dataOutputStream.writeInt(retroScreenDockStationLayout.x(i));
                dataOutputStream.writeInt(retroScreenDockStationLayout.y(i));
                dataOutputStream.writeInt(retroScreenDockStationLayout.width(i));
                dataOutputStream.writeInt(retroScreenDockStationLayout.height(i));
            }
        } else {
            PlaceholderMap placeholderMap = screenDockStationLayout.getPlaceholders();
            Version.write(dataOutputStream, Version.VERSION_1_0_8);
            placeholderMap.write(dataOutputStream);
        }
    }

    @Override
    public ScreenDockStationLayout read(DataInputStream dataInputStream, PlaceholderStrategy placeholderStrategy) throws IOException {
        boolean bl;
        Version version = Version.read(dataInputStream);
        version.checkCurrent();
        boolean bl2 = bl = version.compareTo(Version.VERSION_1_0_8) >= 0;
        if (bl) {
            PlaceholderMap placeholderMap = new PlaceholderMap(dataInputStream, placeholderStrategy);
            return new ScreenDockStationLayout(placeholderMap);
        }
        RetroScreenDockStationLayout retroScreenDockStationLayout = new RetroScreenDockStationLayout();
        int n = dataInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            int n2 = dataInputStream.readInt();
            int n3 = dataInputStream.readInt();
            int n4 = dataInputStream.readInt();
            int n5 = dataInputStream.readInt();
            int n6 = dataInputStream.readInt();
            retroScreenDockStationLayout.add(n2, n3, n4, n5, n6);
        }
        return retroScreenDockStationLayout;
    }

    @Override
    public void write(ScreenDockStationLayout screenDockStationLayout, XElement xElement) {
        if (screenDockStationLayout instanceof RetroScreenDockStationLayout) {
            RetroScreenDockStationLayout retroScreenDockStationLayout = (RetroScreenDockStationLayout)screenDockStationLayout;
            int n = retroScreenDockStationLayout.size();
            for (int i = 0; i < n; ++i) {
                XElement xElement2 = xElement.addElement("child");
                xElement2.addInt("id", retroScreenDockStationLayout.id(i));
                xElement2.addInt("x", retroScreenDockStationLayout.x(i));
                xElement2.addInt("y", retroScreenDockStationLayout.y(i));
                xElement2.addInt("width", retroScreenDockStationLayout.width(i));
                xElement2.addInt("height", retroScreenDockStationLayout.height(i));
            }
        } else {
            screenDockStationLayout.getPlaceholders().write(xElement.addElement("placeholders"));
        }
    }

    @Override
    public ScreenDockStationLayout read(XElement xElement, PlaceholderStrategy placeholderStrategy) {
        XElement xElement2 = xElement.getElement("placeholders");
        if (xElement2 != null) {
            return new ScreenDockStationLayout(new PlaceholderMap(xElement2, placeholderStrategy));
        }
        RetroScreenDockStationLayout retroScreenDockStationLayout = new RetroScreenDockStationLayout();
        for (XElement xElement3 : xElement.getElements("child")) {
            retroScreenDockStationLayout.add(xElement3.getInt("id"), xElement3.getInt("x"), xElement3.getInt("y"), xElement3.getInt("width"), xElement3.getInt("height"));
        }
        return retroScreenDockStationLayout;
    }

    protected ScreenDockStation createStation() {
        return new ScreenDockStation(this.owner);
    }
}

