/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.stack.tab;

import bibliothek.gui.dock.station.stack.tab.AxisConversion;
import bibliothek.gui.dock.station.stack.tab.layouting.TabPlacement;
import java.awt.Dimension;
import java.awt.Rectangle;

public class DefaultAxisConversion
implements AxisConversion {
    private TabPlacement side;
    private Rectangle space;

    public DefaultAxisConversion(Rectangle rectangle, TabPlacement tabPlacement) {
        if (rectangle == null) {
            throw new IllegalArgumentException("space must not be null");
        }
        if (tabPlacement == null) {
            throw new IllegalArgumentException("side must not be null");
        }
        this.side = tabPlacement;
        this.space = rectangle;
    }

    public Dimension modelToView(Dimension dimension) {
        switch (this.side) {
            case TOP_OF_DOCKABLE: 
            case BOTTOM_OF_DOCKABLE: {
                return new Dimension(dimension);
            }
            case LEFT_OF_DOCKABLE: 
            case RIGHT_OF_DOCKABLE: {
                return new Dimension(dimension.height, dimension.width);
            }
        }
        throw new IllegalStateException("unknown side: " + (Object)((Object)this.side));
    }

    public Rectangle modelToView(Rectangle rectangle) {
        switch (this.side) {
            case TOP_OF_DOCKABLE: {
                return new Rectangle(this.space.x + rectangle.x, this.space.y + rectangle.y, rectangle.width, rectangle.height);
            }
            case BOTTOM_OF_DOCKABLE: {
                return new Rectangle(this.space.x + rectangle.x, this.space.y + this.space.height - rectangle.height - rectangle.y, rectangle.width, rectangle.height);
            }
            case LEFT_OF_DOCKABLE: {
                return new Rectangle(this.space.x + rectangle.y, this.space.y + rectangle.x, rectangle.height, rectangle.width);
            }
            case RIGHT_OF_DOCKABLE: {
                return new Rectangle(this.space.x + this.space.width - rectangle.y - rectangle.height, this.space.y + rectangle.x, rectangle.height, rectangle.width);
            }
        }
        throw new IllegalStateException("unknown side: " + (Object)((Object)this.side));
    }

    public Dimension viewToModel(Dimension dimension) {
        switch (this.side) {
            case TOP_OF_DOCKABLE: 
            case BOTTOM_OF_DOCKABLE: {
                return new Dimension(dimension);
            }
            case LEFT_OF_DOCKABLE: 
            case RIGHT_OF_DOCKABLE: {
                return new Dimension(dimension.height, dimension.width);
            }
        }
        throw new IllegalStateException("unknown side: " + (Object)((Object)this.side));
    }

    public Rectangle viewToModel(Rectangle rectangle) {
        switch (this.side) {
            case TOP_OF_DOCKABLE: {
                return new Rectangle(rectangle.x - this.space.x, rectangle.y - this.space.y, rectangle.width, rectangle.height);
            }
            case BOTTOM_OF_DOCKABLE: {
                return new Rectangle(rectangle.x - this.space.x, rectangle.y + rectangle.height - this.space.y - this.space.height, rectangle.width, rectangle.height);
            }
            case LEFT_OF_DOCKABLE: {
                return new Rectangle(this.space.x - rectangle.y, rectangle.x - this.space.y, rectangle.height, rectangle.width);
            }
            case RIGHT_OF_DOCKABLE: {
                return new Rectangle(this.space.y - rectangle.y, this.space.x + this.space.width - rectangle.width - rectangle.x, rectangle.height, rectangle.width);
            }
        }
        throw new IllegalStateException("unknown side: " + (Object)((Object)this.side));
    }
}

