/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.stack.tab.layouting;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.station.stack.tab.Tab;
import bibliothek.gui.dock.station.stack.tab.TabPane;
import bibliothek.gui.dock.station.stack.tab.layouting.LayoutBlock;
import bibliothek.gui.dock.station.stack.tab.layouting.Size;
import bibliothek.gui.dock.station.stack.tab.layouting.TabPlacement;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;

public abstract class TabsLayoutBlock
implements LayoutBlock {
    private List<Tab> tabs = new ArrayList<Tab>();
    private Rectangle bounds = new Rectangle();
    private TabPane pane;
    private TabPlacement orientation = TabPlacement.TOP_OF_DOCKABLE;

    public void setPane(TabPane tabPane) {
        this.pane = tabPane;
    }

    public TabPane getPane() {
        return this.pane;
    }

    public TabPlacement getOrientation() {
        return this.orientation;
    }

    public void setOrientation(TabPlacement tabPlacement) {
        if (tabPlacement == null) {
            throw new IllegalArgumentException("side must not be null");
        }
        if (this.orientation != tabPlacement) {
            this.orientation = tabPlacement;
            for (Tab tab : this.tabs) {
                tab.setOrientation(tabPlacement);
            }
        }
    }

    public Tab getSelectedTab() {
        if (this.pane == null) {
            return null;
        }
        Dockable dockable = this.pane.getSelectedDockable();
        for (Tab tab : this.tabs) {
            if (tab.getDockable() != dockable) continue;
            return tab;
        }
        return null;
    }

    public void checkExistence() {
        ListIterator<Tab> listIterator = this.tabs.listIterator();
        Tab[] tabArray = this.pane.getTabs();
        while (listIterator.hasNext()) {
            Tab tab = listIterator.next();
            boolean bl = false;
            for (Tab tab2 : tabArray) {
                if (tab != tab2) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            listIterator.remove();
        }
    }

    public Tab[] getTabs() {
        return this.tabs.toArray(new Tab[this.tabs.size()]);
    }

    public int getTabsCount() {
        return this.tabs.size();
    }

    public void addTab(Tab tab) {
        this.insertTab(tab, this.tabs.size());
    }

    public void insertTab(Tab tab) {
        int n;
        int n2;
        int[] nArray = this.getOriginalTabLocations();
        TabPane tabPane = this.getPane();
        Dockable[] dockableArray = tabPane.getDockables();
        int n3 = -1;
        for (n2 = 0; n2 < dockableArray.length; ++n2) {
            if (dockableArray[n2] != tab.getDockable()) continue;
            n3 = n2;
            break;
        }
        if (n3 == -1) {
            throw new IllegalArgumentException(tab.getDockable() + " is not a child of the TabPane");
        }
        n2 = 0;
        int n4 = 0;
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] >= n3) continue;
            ++n2;
        }
        n = 0;
        int n5 = n4 + n2;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] < n3) {
                --n2;
            } else if (nArray[i] > n3) {
                ++n4;
            }
            int n6 = n2 + n4;
            if (n6 >= n5) continue;
            n5 = n6;
            n = i + 1;
        }
        this.insertTab(tab, n);
    }

    public int indexOfTab(Tab tab) {
        return this.tabs.indexOf(tab);
    }

    public Tab[] getTabsOrderedByImportance() {
        int n;
        int n2;
        int n3;
        if (this.pane == null) {
            throw new IllegalStateException("no TabPane available");
        }
        Dockable[] dockableArray = this.pane.getDockables();
        Tab[] tabArray = new Tab[dockableArray.length];
        int[] nArray = this.getOriginalTabLocations();
        for (int i = 0; i < tabArray.length; ++i) {
            tabArray[i] = this.pane.getOnTab(dockableArray[i]);
        }
        Tab[] tabArray2 = new Tab[tabArray.length];
        int n4 = 0;
        Dockable dockable = this.pane.getSelectedDockable();
        Tab tab = null;
        Tab[] tabArray3 = tabArray;
        int n5 = tabArray3.length;
        for (n3 = 0; n3 < n5; ++n3) {
            Tab tab2 = tabArray3[n3];
            if (tab2.getDockable() != dockable) continue;
            tab = tab2;
            break;
        }
        for (n2 = 0; n2 < tabArray.length; ++n2) {
            if (tab != tabArray[n2]) continue;
            tabArray[n2] = null;
            tabArray2[n4++] = tab;
            break;
        }
        int n6 = n2 = tab == null ? -1 : this.indexOfTab(tab);
        if (n2 == -1) {
            for (n5 = 0; n5 < nArray.length; ++n5) {
                Tab tab3;
                if (nArray[n5] == -1 || (tab3 = tabArray[nArray[n5]]) == null) continue;
                tabArray2[n4++] = tab3;
                tabArray[nArray[n5]] = null;
            }
        } else {
            for (n5 = n2 - 1; n5 >= 0; --n5) {
                Tab tab4;
                if (nArray[n5] == -1 || (tab4 = tabArray[nArray[n5]]) == null) continue;
                tabArray2[n4++] = tab4;
                tabArray[nArray[n5]] = null;
            }
            for (n5 = n2 + 1; n5 < nArray.length; ++n5) {
                Tab tab5;
                if (nArray[n5] == -1 || (tab5 = tabArray[nArray[n5]]) == null) continue;
                tabArray2[n4++] = tab5;
                tabArray[nArray[n5]] = null;
            }
        }
        n5 = -1;
        n3 = -1;
        for (n = 0; n < tabArray.length; ++n) {
            if (tabArray[n] != null) continue;
            n5 = n;
            break;
        }
        for (n = tabArray.length - 1; n >= 0; --n) {
            if (tabArray[n] != null) continue;
            n3 = n;
            break;
        }
        for (n = n5 + 1; n < n3; ++n) {
            if (tabArray[n] == null) continue;
            tabArray2[n4++] = tabArray[n];
            tabArray[n] = null;
        }
        for (n = n5 - 1; n >= 0; --n) {
            if (tabArray[n] == null) continue;
            tabArray2[n4++] = tabArray[n];
            tabArray[n] = null;
        }
        for (n = Math.max(0, n3); n < tabArray.length; ++n) {
            if (tabArray[n] == null) continue;
            tabArray2[n4++] = tabArray[n];
            tabArray[n] = null;
        }
        return tabArray2;
    }

    public int[] getOriginalTabLocations() {
        TabPane tabPane = this.getPane();
        if (tabPane == null) {
            throw new IllegalStateException("no TabPane available");
        }
        Tab[] tabArray = this.getTabs();
        Dockable[] dockableArray = tabPane.getDockables();
        int[] nArray = new int[tabArray.length];
        int n = 0;
        block0: for (int i = 0; i < tabArray.length; ++i) {
            Dockable dockable = tabArray[i].getDockable();
            nArray[i] = -1;
            for (int j = 0; j < dockableArray.length; ++j) {
                if (dockableArray[n] == dockable) {
                    nArray[i] = n;
                    continue block0;
                }
                n = (n + 1) % dockableArray.length;
            }
        }
        return nArray;
    }

    public Tab[] getDockableTabMap() {
        TabPane tabPane = this.getPane();
        if (tabPane == null) {
            throw new IllegalStateException("missing the TabPane");
        }
        Tab[] tabArray = this.getTabs();
        Dockable[] dockableArray = tabPane.getDockables();
        Tab[] tabArray2 = new Tab[dockableArray.length];
        int n = 0;
        block0: for (int i = 0; i < tabArray.length; ++i) {
            Dockable dockable = tabArray[i].getDockable();
            for (int j = 0; j < dockableArray.length; ++j) {
                if (dockableArray[n] == dockable) {
                    tabArray2[n] = tabArray[i];
                    continue block0;
                }
                n = (n + 1) % dockableArray.length;
            }
        }
        return tabArray2;
    }

    public void insertTab(Tab tab, int n) {
        if (tab == null) {
            throw new IllegalArgumentException("tab must not be null");
        }
        this.tabs.add(n, tab);
        tab.setOrientation(this.getOrientation());
    }

    public boolean removeTab(Tab tab) {
        return this.tabs.remove(tab);
    }

    public Tab removeTab(int n) {
        return this.tabs.remove(n);
    }

    public void removeAllTabs() {
        this.tabs.clear();
    }

    public abstract void doLayout();

    public void setLayout(Size size) {
        if (size instanceof TabsSize) {
            Tab[] tabArray;
            Tab[] tabArray2 = ((TabsSize)size).getTabs();
            if (tabArray2.length == (tabArray = this.getTabs()).length) {
                boolean bl = true;
                for (int i = 0; i < tabArray2.length && bl; ++i) {
                    bl = tabArray2[i] == tabArray[i];
                }
                if (bl) {
                    return;
                }
            }
            this.removeAllTabs();
            for (Tab tab : tabArray2) {
                tab = this.pane.putOnTab(tab.getDockable());
                this.insertTab(tab);
            }
        } else {
            throw new IllegalArgumentException("not a size created by this block");
        }
    }

    public boolean isVisible() {
        return true;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.bounds.setBounds(n, n2, n3, n4);
        this.doLayout();
    }

    public Rectangle getBounds() {
        return new Rectangle(this.bounds);
    }

    protected class TabsSize
    extends Size {
        private Tab[] tabs;

        public TabsSize(Size.Type type, int n, int n2, Tab[] tabArray) {
            super(type, n, n2);
            this.tabs = tabArray;
        }

        public TabsSize(Size.Type type, Dimension dimension, Tab[] tabArray) {
            super(type, dimension);
            this.tabs = tabArray;
        }

        public Tab[] getTabs() {
            return this.tabs;
        }

        public int getTabCount() {
            return this.tabs.length;
        }

        public String toString() {
            return "[width=" + this.getWidth() + ", height=" + this.getHeight() + ", tabs=" + Arrays.toString(this.tabs) + "]";
        }
    }
}

