/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.doc.number;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.odftoolkit.odfdom.OdfElement;
import org.odftoolkit.odfdom.OdfFileDom;
import org.odftoolkit.odfdom.doc.number.OdfNumber;
import org.odftoolkit.odfdom.doc.number.OdfNumberCurrencySymbol;
import org.odftoolkit.odfdom.doc.number.OdfNumberText;
import org.odftoolkit.odfdom.doc.style.OdfStyleMap;
import org.odftoolkit.odfdom.dom.OdfNamespaceNames;
import org.odftoolkit.odfdom.dom.element.number.NumberCurrencyStyleElement;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OdfNumberCurrencyStyle
extends NumberCurrencyStyleElement {
    public OdfNumberCurrencyStyle(OdfFileDom ownerDoc) {
        super(ownerDoc);
    }

    public OdfNumberCurrencyStyle(OdfFileDom ownerDoc, String currencySymbol, String format, String styleName) {
        super(ownerDoc);
        this.setStyleNameAttribute(styleName);
        this.buildFromFormat(currencySymbol, format);
    }

    public String getFormat() {
        String result = "";
        for (Node m = this.getFirstChild(); m != null; m = m.getNextSibling()) {
            if (m instanceof OdfNumberCurrencySymbol) {
                result = result + m.getTextContent();
                continue;
            }
            if (m instanceof OdfNumber) {
                result = result + this.getNumberFormat();
                continue;
            }
            if (!(m instanceof OdfNumberText)) continue;
            String textcontent = m.getTextContent();
            if (textcontent == null || textcontent.length() == 0) {
                textcontent = " ";
            }
            result = result + textcontent;
        }
        return result;
    }

    public String getNumberFormat() {
        int i;
        String result = "";
        OdfNumber number = OdfElement.findFirstChildNode(OdfNumber.class, (Node)((Object)this));
        boolean isGroup = number.getNumberGroupingAttribute();
        int decimalPos = number.getNumberDecimalPlacesAttribute() == null ? 0 : number.getNumberDecimalPlacesAttribute();
        int minInt = number.getNumberMinIntegerDigitsAttribute() == null ? 1 : number.getNumberMinIntegerDigitsAttribute();
        for (i = 0; i < minInt; ++i) {
            result = (i + 1) % 3 == 0 && isGroup ? ",0" + result : "0" + result;
        }
        while (isGroup && result.indexOf(44) == -1) {
            result = (i + 1) % 3 == 0 && isGroup ? ",#" + result : "#" + result;
            ++i;
        }
        result = "#" + result;
        if (decimalPos > 0) {
            result = result + ".";
            for (i = 0; i < decimalPos; ++i) {
                result = result + "0";
            }
        }
        return result;
    }

    public String getConditionStyleName(double value) {
        OdfStyleMap map = OdfElement.findFirstChildNode(OdfStyleMap.class, (Node)((Object)this));
        while (map != null) {
            String condition = map.getStyleConditionAttribute();
            if (this.isTrue(condition, value)) {
                return map.getStyleApplyStyleNameAttribute();
            }
            map = OdfElement.findNextChildNode(OdfStyleMap.class, (Node)((Object)map));
        }
        return this.getStyleNameAttribute();
    }

    private boolean isTrue(String condition, double value) {
        double rightOp = this.getLastNumber(condition);
        if (condition.indexOf(62) != -1 ? value > rightOp : condition.indexOf(60) != -1 && value < rightOp) {
            return true;
        }
        return condition.indexOf(33) != -1 ? value != rightOp : condition.indexOf(61) != -1 && value == rightOp;
    }

    private Double getLastNumber(String condition) {
        String results = "";
        for (int i = condition.length() - 1; i >= 0 && condition.charAt(i) >= '0' && condition.charAt(i) <= '9'; --i) {
            results = results + condition.charAt(i);
        }
        return Double.parseDouble(results);
    }

    public void buildFromFormat(String currencySymbol, String format) {
        Pattern p = Pattern.compile("[#0,.]+");
        Matcher m = p.matcher(format);
        if (m.find()) {
            char ch;
            int pos;
            String preMatch = format.substring(0, m.start());
            String numberSpec = format.substring(m.start(), m.end());
            String postMatch = format.substring(m.end());
            this.processText(preMatch, currencySymbol);
            OdfNumber number = new OdfNumber((OdfFileDom)((Object)this.getOwnerDocument()));
            int nDigits = 0;
            for (pos = 0; pos < numberSpec.length() && (ch = numberSpec.charAt(pos)) != '.'; ++pos) {
                if (ch == ',') {
                    number.setNumberGroupingAttribute(new Boolean(true));
                    continue;
                }
                if (ch != '0') continue;
                ++nDigits;
            }
            number.setNumberMinIntegerDigitsAttribute(nDigits);
            if (pos < numberSpec.length()) {
                number.setNumberDecimalPlacesAttribute(numberSpec.length() - (pos + 1));
            }
            this.appendChild((Node)((Object)number));
            this.processText(postMatch, currencySymbol);
        }
    }

    private void processText(String text, String currencySymbol) {
        OdfFileDom dom = (OdfFileDom)((Object)this.getOwnerDocument());
        int currencyPos = text.indexOf(currencySymbol);
        if (currencyPos >= 0) {
            this.emitText(text.substring(0, currencyPos));
            OdfNumberCurrencySymbol cSymbol = new OdfNumberCurrencySymbol(dom);
            cSymbol.appendChild(dom.createTextNode(currencySymbol));
            this.appendChild((Node)((Object)cSymbol));
            this.emitText(text.substring(currencyPos + currencySymbol.length()));
        } else {
            this.emitText(text);
        }
    }

    private void emitText(String textBuffer) {
        if (!textBuffer.equals("")) {
            OdfNumberText textElement = new OdfNumberText((OdfFileDom)((Object)this.getOwnerDocument()));
            textElement.setTextContent(textBuffer);
            this.appendChild((Node)((Object)textElement));
        }
    }

    public OdfNumberCurrencySymbol getCurrencySymbolElement() {
        OdfNumberCurrencySymbol cSymbol = null;
        NodeList list = this.getElementsByTagNameNS(OdfNamespaceNames.NUMBER.getUri(), "currency-symbol");
        if (list.getLength() > 0) {
            cSymbol = (OdfNumberCurrencySymbol)((Object)list.item(0));
        }
        return cSymbol;
    }

    public void setCurrencyLocale(String language, String country) {
        OdfNumberCurrencySymbol cSymbol = this.getCurrencySymbolElement();
        cSymbol.setNumberCountryAttribute(country);
        cSymbol.setNumberLanguageAttribute(language);
    }

    public void setCurrencyLocale(String locale) {
        OdfNumberCurrencySymbol cSymbol = this.getCurrencySymbolElement();
        int pos = locale.indexOf(45);
        if (pos >= 0) {
            cSymbol.setNumberLanguageAttribute(locale.substring(0, pos));
            cSymbol.setNumberCountryAttribute(locale.substring(pos + 1));
        } else {
            cSymbol.setNumberLanguageAttribute(locale);
        }
    }

    public void setMapPositive(String mapName) {
        OdfStyleMap map = new OdfStyleMap((OdfFileDom)((Object)this.getOwnerDocument()));
        map.setStyleApplyStyleNameAttribute(mapName);
        map.setStyleConditionAttribute("value()>0");
        this.appendChild((Node)((Object)map));
    }

    public void setMapNegative(String mapName) {
        OdfStyleMap map = new OdfStyleMap((OdfFileDom)((Object)this.getOwnerDocument()));
        map.setStyleApplyStyleNameAttribute(mapName);
        map.setStyleConditionAttribute("value()<0");
        this.appendChild((Node)((Object)map));
    }
}

