/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern.color;

import bibliothek.gui.dock.common.intern.color.TabColorTransmitter;
import bibliothek.gui.dock.themes.ColorBridgeFactory;
import bibliothek.gui.dock.util.color.ColorManager;
import bibliothek.util.Colors;
import java.awt.Color;

public class BubbleTabTransmitter
extends TabColorTransmitter {
    public static final ColorBridgeFactory FACTORY = new ColorBridgeFactory(){

        public BubbleTabTransmitter create(ColorManager colorManager) {
            return new BubbleTabTransmitter(colorManager);
        }
    };
    private static final String[] KEYS = new String[]{"stack.tab.background.top.mouse", "stack.tab.background.bottom.mouse", "stack.tab.border.mouse", "stack.tab.foreground.mouse", "stack.tab.background.top", "stack.tab.background.bottom", "stack.tab.border", "stack.tab.foreground", "stack.tab.background.top.selected.mouse", "stack.tab.background.bottom.selected.mouse", "stack.tab.border.selected.mouse", "stack.tab.foreground.selected.mouse", "stack.tab.background.top.selected", "stack.tab.background.bottom.selected", "stack.tab.border.selected", "stack.tab.foreground.selected", "stack.tab.background.top.focused.mouse", "stack.tab.background.bottom.focused.mouse", "stack.tab.border.focused.mouse", "stack.tab.foreground.focused.mouse", "stack.tab.background.top.focused", "stack.tab.background.bottom.focused", "stack.tab.border.focused", "stack.tab.foreground.focused"};

    public BubbleTabTransmitter(ColorManager colorManager) {
        super(colorManager, KEYS);
    }

    protected boolean isFocused(String string) {
        return string.contains("focused");
    }

    protected boolean isForeground(String string) {
        return string.contains("foreground");
    }

    protected boolean isSelected(String string) {
        return string.contains("selected");
    }

    protected Color convert(Color color, String string) {
        if (string.contains("selected")) {
            return this.convertSelected(Colors.undiffMirror(color, 0.2), string);
        }
        if (string.contains("focused")) {
            return this.convertFocused(Colors.diffMirror(color, 0.2), string);
        }
        if ("stack.tab.background.top.mouse".equals(string)) {
            return Colors.fuller(color, 0.3);
        }
        if ("stack.tab.background.bottom.mouse".equals(string)) {
            return Colors.fuller(Colors.diffMirror(color, 0.3), 0.3);
        }
        if ("stack.tab.border.mouse".equals(string)) {
            return Colors.fuller(Colors.diffMirror(color, 0.6), 0.3);
        }
        if ("stack.tab.foreground.mouse".equals(string)) {
            return Colors.fuller(Colors.diffMirror(color, 0.9), 0.3);
        }
        if ("stack.tab.background.top".equals(string)) {
            return color;
        }
        if ("stack.tab.background.bottom".equals(string)) {
            return Colors.diffMirror(color, 0.3);
        }
        if ("stack.tab.border".equals(string)) {
            return Colors.diffMirror(color, 0.6);
        }
        if ("stack.tab.foreground".equals(string)) {
            return Colors.diffMirror(color, 0.9);
        }
        return null;
    }

    protected Color convertSelected(Color color, String string) {
        if (string.contains("focused")) {
            return this.convertFocused(Colors.diffMirror(color, 0.2), string);
        }
        if ("stack.tab.background.top.selected.mouse".equals(string)) {
            return Colors.fuller(color, 0.3);
        }
        if ("stack.tab.background.bottom.selected.mouse".equals(string)) {
            return Colors.fuller(Colors.diffMirror(color, 0.3), 0.3);
        }
        if ("stack.tab.border.selected.mouse".equals(string)) {
            return Colors.fuller(Colors.diffMirror(color, 0.6), 0.3);
        }
        if ("stack.tab.foreground.selected.mouse".equals(string)) {
            return Colors.fuller(Colors.diffMirror(color, 0.9), 0.3);
        }
        if ("stack.tab.background.top.selected".equals(string)) {
            return color;
        }
        if ("stack.tab.background.bottom.selected".equals(string)) {
            return Colors.diffMirror(color, 0.3);
        }
        if ("stack.tab.border.selected".equals(string)) {
            return Colors.diffMirror(color, 0.6);
        }
        if ("stack.tab.foreground.selected".equals(string)) {
            return Colors.diffMirror(color, 0.9);
        }
        return null;
    }

    protected Color convertFocused(Color color, String string) {
        if ("stack.tab.background.top.focused.mouse".equals(string)) {
            return Colors.fuller(color, 0.3);
        }
        if ("stack.tab.background.bottom.focused.mouse".equals(string)) {
            return Colors.fuller(Colors.diffMirror(color, 0.3), 0.3);
        }
        if ("stack.tab.border.focused.mouse".equals(string)) {
            return Colors.fuller(Colors.diffMirror(color, 0.6), 0.3);
        }
        if ("stack.tab.foreground.focused.mouse".equals(string)) {
            return Colors.fuller(Colors.diffMirror(color, 0.9), 0.3);
        }
        if ("stack.tab.background.top.focused".equals(string)) {
            return color;
        }
        if ("stack.tab.background.bottom.focused".equals(string)) {
            return Colors.diffMirror(color, 0.3);
        }
        if ("stack.tab.border.focused".equals(string)) {
            return Colors.diffMirror(color, 0.6);
        }
        if ("stack.tab.foreground.focused".equals(string)) {
            return Colors.diffMirror(color, 0.9);
        }
        return null;
    }
}

