/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern.font;

import bibliothek.gui.dock.common.FontMap;
import bibliothek.gui.dock.common.event.FontMapListener;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.ui.UITransmitter;
import bibliothek.gui.dock.util.font.DockFont;
import bibliothek.gui.dock.util.font.FontBridge;
import bibliothek.gui.dock.util.font.FontManager;
import bibliothek.gui.dock.util.font.FontModifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FontTransmitter
extends UITransmitter<FontModifier, DockFont>
implements FontBridge {
    private Listener listener = new Listener();
    private FontManager manager;
    private String[] keys;

    public FontTransmitter(FontManager fontManager, String ... stringArray) {
        super(stringArray);
        this.manager = fontManager;
        this.keys = stringArray;
    }

    protected FontModifier getFirstNonNull(FontMap fontMap, String ... stringArray) {
        for (String string : stringArray) {
            FontModifier fontModifier = fontMap.getFont(string);
            if (fontModifier == null) continue;
            return fontModifier;
        }
        return null;
    }

    @Override
    protected void connect(CDockable cDockable) {
        cDockable.getFonts().addListener(this.listener);
    }

    @Override
    protected void disconnect(CDockable cDockable) {
        cDockable.getFonts().removeListener(this.listener);
    }

    @Override
    protected void update(CDockable cDockable, String string, FontModifier fontModifier) {
        if (this.isObservedMapKey(string)) {
            for (String string2 : this.keys) {
                this.set(string2, this.get((FontModifier)this.manager.get(string2), string2, cDockable), cDockable);
            }
        }
    }

    protected abstract boolean isObservedMapKey(String var1);

    @Override
    protected abstract FontModifier get(FontModifier var1, String var2, CDockable var3);

    private class Listener
    implements FontMapListener {
        private Listener() {
        }

        public void fontChanged(FontMap fontMap, String string, FontModifier fontModifier) {
            FontTransmitter.this.update(fontMap.getDockable(), string, fontModifier);
        }
    }
}

