/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.location;

import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.location.AbstractStackholdingLocation;
import bibliothek.gui.dock.common.location.CFlapLocation;
import bibliothek.gui.dock.common.mode.ExtendedMode;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.station.flap.FlapDockProperty;

public class CFlapIndexLocation
extends AbstractStackholdingLocation {
    private int index;
    private CFlapLocation parent;

    public CFlapIndexLocation(CFlapLocation cFlapLocation, int n) {
        if (cFlapLocation == null) {
            throw new NullPointerException("parent must not be null");
        }
        this.parent = cFlapLocation;
        this.index = n;
    }

    public int getIndex() {
        return this.index;
    }

    public CLocation aside() {
        if (this.index == Integer.MAX_VALUE) {
            return this;
        }
        return new CFlapIndexLocation(this.parent, this.index + 1);
    }

    public ExtendedMode findMode() {
        return ExtendedMode.MINIMIZED;
    }

    public DockableProperty findProperty(DockableProperty dockableProperty) {
        FlapDockProperty flapDockProperty = new FlapDockProperty(this.index);
        flapDockProperty.setSuccessor(dockableProperty);
        return flapDockProperty;
    }

    public String findRoot() {
        return this.parent.findRoot();
    }

    public CLocation expandProperty(DockableProperty dockableProperty) {
        if (dockableProperty instanceof FlapDockProperty) {
            int n = ((FlapDockProperty)dockableProperty).getIndex();
            CFlapIndexLocation cFlapIndexLocation = new CFlapIndexLocation(this.parent, n);
            DockableProperty dockableProperty2 = dockableProperty.getSuccessor();
            if (dockableProperty2 == null) {
                return cFlapIndexLocation;
            }
            return cFlapIndexLocation.expandProperty(dockableProperty2);
        }
        return super.expandProperty(dockableProperty);
    }

    public String toString() {
        return String.valueOf(this.parent) + " [index " + this.index + "]";
    }
}

