/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockFactory;
import bibliothek.gui.dock.common.CStation;
import bibliothek.gui.dock.common.MultipleCDockable;
import bibliothek.gui.dock.common.MultipleCDockableFactory;
import bibliothek.gui.dock.common.MultipleCDockableLayout;
import bibliothek.gui.dock.common.intern.CControlAccess;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.common.intern.CommonMultipleDockableLayout;
import bibliothek.gui.dock.common.perspective.CElementPerspective;
import bibliothek.gui.dock.common.perspective.CPerspective;
import bibliothek.gui.dock.common.perspective.CPerspectiveMultipleIdentifierCollection;
import bibliothek.gui.dock.common.perspective.CStationPerspective;
import bibliothek.gui.dock.common.perspective.CommonElementPerspective;
import bibliothek.gui.dock.common.perspective.MultipleCDockablePerspective;
import bibliothek.gui.dock.common.perspective.SingleCDockablePerspective;
import bibliothek.gui.dock.layout.LocationEstimationMap;
import bibliothek.gui.dock.perspective.PerspectiveDockable;
import bibliothek.gui.dock.perspective.PerspectiveElement;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.util.Version;
import bibliothek.util.xml.XElement;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonMultipleDockableFactory
implements DockFactory<CommonDockable, CommonElementPerspective, CommonMultipleDockableLayout> {
    private String id;
    private MultipleCDockableFactory<MultipleCDockable, MultipleCDockableLayout> delegate;
    private CControlAccess controlAccess;
    private CPerspectiveMultipleIdentifierCollection perspectiveIdentifiers;

    public CommonMultipleDockableFactory(String id, MultipleCDockableFactory<?, ?> delegate, CControlAccess access) {
        this.id = id;
        this.delegate = delegate;
        this.controlAccess = access;
    }

    public CommonMultipleDockableFactory(String id, MultipleCDockableFactory<?, ?> delegate, CControlAccess access, CPerspective perspective) {
        this.id = id;
        this.delegate = delegate;
        this.controlAccess = access;
        this.perspectiveIdentifiers = new CPerspectiveMultipleIdentifierCollection(id, perspective);
    }

    @Override
    public String getID() {
        return this.id;
    }

    public MultipleCDockableFactory<?, ?> getFactory() {
        return this.delegate;
    }

    @Override
    public void estimateLocations(CommonMultipleDockableLayout layout, LocationEstimationMap children) {
    }

    @Override
    public CommonMultipleDockableLayout getLayout(CommonDockable element, Map<Dockable, Integer> children) {
        MultipleCDockable dockable = (MultipleCDockable)element.getDockable();
        MultipleCDockableLayout layout = this.delegate.write(dockable);
        CommonMultipleDockableLayout flayout = new CommonMultipleDockableLayout();
        flayout.setLayout(layout);
        String uniqueId = this.controlAccess.access(element.getDockable()).getUniqueId();
        uniqueId = this.controlAccess.getRegister().multiToNormalId(uniqueId);
        flayout.setId(uniqueId);
        if (element.getDockable().getWorkingArea() != null) {
            flayout.setArea(element.getDockable().getWorkingArea().getUniqueId());
        }
        return flayout;
    }

    @Override
    public CommonMultipleDockableLayout getPerspectiveLayout(CommonElementPerspective element, Map<PerspectiveDockable, Integer> children) {
        MultipleCDockablePerspective dockable = (MultipleCDockablePerspective)element.getElement();
        MultipleCDockableLayout layout = dockable.getLayout();
        CommonMultipleDockableLayout flayout = new CommonMultipleDockableLayout();
        flayout.setLayout(layout);
        String uniqueId = this.perspectiveIdentifiers.getUniqueId(dockable);
        flayout.setId(uniqueId);
        if (dockable.getWorkingArea() != null) {
            flayout.setArea(dockable.getWorkingArea().getUniqueId());
        }
        return flayout;
    }

    @Override
    public void layoutPerspective(CommonElementPerspective perspective, CommonMultipleDockableLayout layout, Map<Integer, PerspectiveDockable> children) {
        MultipleCDockablePerspective multiple = (MultipleCDockablePerspective)perspective.getElement();
        multiple.setLayout(layout.getLayout());
        this.perspectiveIdentifiers.putDockable(layout.getId(), multiple);
        String areaId = layout.getArea();
        if (areaId != null) {
            CStationPerspective station = this.perspectiveIdentifiers.getPerspective().getRoot(areaId);
            if (station != null) {
                multiple.setWorkingArea(station);
            } else {
                Iterator<PerspectiveElement> elements = this.perspectiveIdentifiers.getPerspective().elements();
                while (elements.hasNext()) {
                    SingleCDockablePerspective single;
                    CElementPerspective celement;
                    PerspectiveElement next = elements.next();
                    if (!(next instanceof CommonElementPerspective) || !((celement = ((CommonElementPerspective)next).getElement()) instanceof SingleCDockablePerspective) || !areaId.equals((single = (SingleCDockablePerspective)celement).getUniqueId())) continue;
                    multiple.setWorkingArea(single.asStation());
                    break;
                }
            }
        }
    }

    @Override
    public CommonElementPerspective layoutPerspective(CommonMultipleDockableLayout layout, Map<Integer, PerspectiveDockable> children) {
        MultipleCDockablePerspective perspective = new MultipleCDockablePerspective(this.getID(), null);
        this.layoutPerspective(perspective.intern(), layout, children);
        return perspective.intern();
    }

    @Override
    public CommonDockable layout(CommonMultipleDockableLayout layout, Map<Integer, Dockable> children, PlaceholderStrategy placeholders) {
        return this.layout(layout, placeholders);
    }

    @Override
    public CommonDockable layout(CommonMultipleDockableLayout layout, PlaceholderStrategy placeholders) {
        MultipleCDockable dockable;
        block4: {
            String areaId;
            block5: {
                dockable = this.delegate.read(layout.getLayout());
                if (dockable == null) {
                    return null;
                }
                String id = layout.getId();
                MultipleCDockable oldDockable = this.controlAccess.getOwner().getMultipleDockable(id);
                if (oldDockable != null) {
                    this.controlAccess.getOwner().replace(oldDockable, dockable);
                } else {
                    this.controlAccess.getOwner().addDockable(id, dockable);
                }
                areaId = layout.getArea();
                if (areaId == null) break block4;
                CStation<?> station = this.controlAccess.getOwner().getStation(areaId);
                if (station == null) break block5;
                if (!station.isWorkingArea()) break block4;
                dockable.setWorkingArea(station);
                break block4;
            }
            int n = this.controlAccess.getOwner().getCDockableCount();
            for (int i = 0; i < n; ++i) {
                CDockable check = this.controlAccess.getOwner().getCDockable(i);
                CStation<?> checkStation = check.asStation();
                if (checkStation == null || !checkStation.isWorkingArea() || !checkStation.getUniqueId().equals(areaId)) continue;
                dockable.setWorkingArea(checkStation);
                break;
            }
        }
        return dockable.intern();
    }

    @Override
    public void setLayout(CommonDockable element, CommonMultipleDockableLayout layout, Map<Integer, Dockable> children, PlaceholderStrategy placeholders) {
    }

    @Override
    public void setLayout(CommonDockable element, CommonMultipleDockableLayout layout, PlaceholderStrategy placeholders) {
    }

    @Override
    public CommonMultipleDockableLayout read(DataInputStream in, PlaceholderStrategy placeholders) throws IOException {
        Version version = Version.read(in);
        version.checkCurrent();
        CommonMultipleDockableLayout layout = new CommonMultipleDockableLayout();
        layout.setLayout(this.delegate.create());
        layout.getLayout().readStream(in);
        layout.setId(in.readUTF());
        if (in.readBoolean()) {
            layout.setArea(in.readUTF());
        }
        return layout;
    }

    @Override
    public CommonMultipleDockableLayout read(XElement element, PlaceholderStrategy placeholders) {
        CommonMultipleDockableLayout layout = new CommonMultipleDockableLayout();
        layout.setLayout(this.delegate.create());
        layout.getLayout().readXML(element.getElement("multiple"));
        layout.setId(element.getElement("id").getString());
        XElement xarea = element.getElement("area");
        if (xarea != null) {
            layout.setArea(xarea.getString());
        }
        return layout;
    }

    @Override
    public void write(CommonMultipleDockableLayout layout, DataOutputStream out) throws IOException {
        Version.write(out, Version.VERSION_1_0_4);
        layout.getLayout().writeStream(out);
        out.writeUTF(layout.getId());
        if (layout.getArea() == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeUTF(layout.getArea());
        }
    }

    @Override
    public void write(CommonMultipleDockableLayout layout, XElement element) {
        element.addElement("id").setString(layout.getId());
        if (layout.getArea() != null) {
            element.addElement("area").setString(layout.getArea());
        }
        layout.getLayout().writeXML(element.addElement("multiple"));
    }
}

