/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.title;

import bibliothek.gui.DockController;
import bibliothek.gui.dock.title.DockTitleFactory;
import bibliothek.gui.dock.title.DockTitleVersion;
import bibliothek.gui.dock.title.NullTitleFactory;
import bibliothek.gui.dock.util.Priority;
import java.util.Hashtable;
import java.util.Map;

public class DockTitleManager {
    public static final String THEME_FACTORY_ID = "theme";
    private Map<String, DockTitleVersion> titleVersions = new Hashtable<String, DockTitleVersion>();
    private DockController controller;

    public DockTitleManager(DockController controller) {
        if (controller == null) {
            throw new IllegalArgumentException("Controller must not be null");
        }
        this.controller = controller;
        this.getVersion(THEME_FACTORY_ID, NullTitleFactory.INSTANCE);
    }

    public boolean existsTitleVersion(String id) {
        return this.titleVersions.containsKey(id);
    }

    public DockTitleVersion getVersion(String id) {
        return this.titleVersions.get(id);
    }

    public DockTitleVersion getVersion(String id, DockTitleFactory factory) {
        DockTitleVersion version = this.titleVersions.get(id);
        if (version == null) {
            version = new DockTitleVersion(this.controller, id);
            this.titleVersions.put(id, version);
        }
        if (version.getFactory(Priority.DEFAULT) == null) {
            version.setFactory(factory, Priority.DEFAULT);
        }
        return version;
    }

    public DockTitleVersion registerClient(String id, DockTitleFactory factory) {
        return this.register(id, factory, Priority.CLIENT);
    }

    public DockTitleVersion registerTheme(String id, DockTitleFactory factory) {
        return this.register(id, factory, Priority.THEME);
    }

    public DockTitleVersion registerDefault(String id, DockTitleFactory factory) {
        return this.register(id, factory, Priority.DEFAULT);
    }

    public DockTitleVersion register(String id, DockTitleFactory factory, Priority priority) {
        DockTitleVersion version = this.titleVersions.get(id);
        if (version == null) {
            version = new DockTitleVersion(this.controller, id);
            this.titleVersions.put(id, version);
        }
        version.setFactory(factory, priority);
        return version;
    }

    public void clearThemeFactories() {
        for (DockTitleVersion version : this.titleVersions.values()) {
            version.setFactory(null, Priority.THEME);
        }
    }
}

