/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.doc;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.odftoolkit.odfdom.OdfElement;
import org.odftoolkit.odfdom.OdfFileDom;
import org.odftoolkit.odfdom.OdfName;
import org.odftoolkit.odfdom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.doc.draw.OdfDrawPage;
import org.odftoolkit.odfdom.doc.office.OdfOfficeAutomaticStyles;
import org.odftoolkit.odfdom.doc.office.OdfOfficeStyles;
import org.odftoolkit.odfdom.dom.OdfNamespaceNames;
import org.odftoolkit.odfdom.dom.attribute.presentation.PresentationClassAttribute;
import org.odftoolkit.odfdom.dom.element.OdfStyleBase;
import org.odftoolkit.odfdom.dom.element.draw.DrawFrameElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawPageElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawPageThumbnailElement;
import org.odftoolkit.odfdom.dom.element.office.OfficePresentationElement;
import org.odftoolkit.odfdom.dom.element.presentation.PresentationNotesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleGraphicPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StylePresentationPageLayoutElement;
import org.odftoolkit.odfdom.pkg.manifest.OdfFileEntry;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OdfPresentationDocument
extends OdfDocument {
    private static String EMPTY_PRESENTATION_DOCUMENT_PATH = "/OdfPresentationDocument.odp";
    private static OdfDocument.Resource EMPTY_PRESENTATION_DOCUMENT_RESOURCE = new OdfDocument.Resource(EMPTY_PRESENTATION_DOCUMENT_PATH);
    private boolean hasCheckSlideName = false;
    private HashMap<String, List<String>> styleRenameMap = new HashMap();
    private HashMap<String, Boolean> styleAppendMap = new HashMap();

    public static OdfPresentationDocument newPresentationDocument() throws Exception {
        return (OdfPresentationDocument)OdfDocument.loadTemplate(EMPTY_PRESENTATION_DOCUMENT_RESOURCE);
    }

    public static OdfPresentationDocument newPresentationTemplateDocument() throws Exception {
        OdfPresentationDocument doc = (OdfPresentationDocument)OdfDocument.loadTemplate(EMPTY_PRESENTATION_DOCUMENT_RESOURCE);
        doc.changeMode(OdfMediaType.PRESENTATION_TEMPLATE);
        return doc;
    }

    protected OdfPresentationDocument() {
    }

    public OfficePresentationElement getContentRoot() throws Exception {
        return super.getContentRoot(OfficePresentationElement.class);
    }

    public void changeMode(OdfMediaType type) {
        this.setMediaType(type.getOdfMediaType());
        this.getPackage().setMediaType(type.toString());
    }

    public OdfDrawPage getSlideByIndex(int index) {
        this.checkAllSlideName();
        OfficePresentationElement contentRoot = null;
        try {
            contentRoot = this.getContentRoot();
        }
        catch (Exception e) {
            Logger.getLogger(OdfPresentationDocument.class.getName()).log(Level.SEVERE, null, e);
            return null;
        }
        NodeList slideNodes = contentRoot.getElementsByTagNameNS(OdfNamespace.newNamespace(OdfNamespaceNames.DRAW).toString(), "page");
        if (index >= slideNodes.getLength() || index < 0) {
            return null;
        }
        DrawPageElement slideElement = (DrawPageElement)((Object)slideNodes.item(index));
        return OdfDrawPage.getInstance(slideElement);
    }

    public int getSlideCount() {
        this.checkAllSlideName();
        OfficePresentationElement contentRoot = null;
        try {
            contentRoot = this.getContentRoot();
        }
        catch (Exception e) {
            Logger.getLogger(OdfPresentationDocument.class.getName()).log(Level.SEVERE, null, e);
            return 0;
        }
        NodeList slideNodes = contentRoot.getElementsByTagNameNS(OdfNamespace.newNamespace(OdfNamespaceNames.DRAW).toString(), "page");
        return slideNodes.getLength();
    }

    public OdfDrawPage getSlideByName(String name) {
        this.checkAllSlideName();
        if (name == null) {
            return null;
        }
        OfficePresentationElement contentRoot = null;
        try {
            contentRoot = this.getContentRoot();
        }
        catch (Exception e) {
            Logger.getLogger(OdfPresentationDocument.class.getName()).log(Level.SEVERE, null, e);
            return null;
        }
        NodeList slideNodes = contentRoot.getElementsByTagNameNS(OdfNamespace.newNamespace(OdfNamespaceNames.DRAW).toString(), "page");
        for (int i = 0; i < slideNodes.getLength(); ++i) {
            DrawPageElement slideElement = (DrawPageElement)((Object)slideNodes.item(i));
            OdfDrawPage slide = OdfDrawPage.getInstance(slideElement);
            String slideName = slide.getSlideName();
            if (!slideName.equals(name)) continue;
            return slide;
        }
        return null;
    }

    private void checkAllSlideName() {
        if (this.hasCheckSlideName) {
            return;
        }
        ArrayList<String> slideNameList = new ArrayList<String>();
        OfficePresentationElement contentRoot = null;
        try {
            contentRoot = this.getContentRoot();
        }
        catch (Exception e) {
            Logger.getLogger(OdfPresentationDocument.class.getName()).log(Level.SEVERE, null, e);
            return;
        }
        NodeList slideNodes = contentRoot.getElementsByTagNameNS(OdfNamespace.newNamespace(OdfNamespaceNames.DRAW).toString(), "page");
        for (int i = 0; i < slideNodes.getLength(); ++i) {
            DrawPageElement slideElement = (DrawPageElement)((Object)slideNodes.item(i));
            String slideName = slideElement.getDrawNameAttribute();
            if (slideName == null || slideNameList.contains(slideName)) {
                slideName = "page" + (i + 1) + "-" + this.makeUniqueName();
                slideElement.setDrawNameAttribute(slideName);
            }
            slideNameList.add(slideName);
        }
        this.hasCheckSlideName = true;
    }

    public Iterator<OdfDrawPage> getSlides() {
        this.checkAllSlideName();
        OfficePresentationElement contentRoot = null;
        try {
            contentRoot = this.getContentRoot();
        }
        catch (Exception e) {
            Logger.getLogger(OdfPresentationDocument.class.getName()).log(Level.SEVERE, null, e);
            return null;
        }
        ArrayList<OdfDrawPage> slideList = new ArrayList<OdfDrawPage>();
        NodeList slideNodes = contentRoot.getElementsByTagNameNS(OdfNamespace.newNamespace(OdfNamespaceNames.DRAW).toString(), "page");
        for (int i = 0; i < slideNodes.getLength(); ++i) {
            DrawPageElement slideElement = (DrawPageElement)((Object)slideNodes.item(i));
            slideList.add(OdfDrawPage.getInstance(slideElement));
        }
        return slideList.iterator();
    }

    public void deleteSlideByIndex(int index) {
        this.checkAllSlideName();
        OfficePresentationElement contentRoot = null;
        try {
            contentRoot = this.getContentRoot();
        }
        catch (Exception e) {
            Logger.getLogger(OdfPresentationDocument.class.getName()).log(Level.SEVERE, null, e);
            return;
        }
        NodeList slideNodes = contentRoot.getElementsByTagNameNS(OdfNamespace.newNamespace(OdfNamespaceNames.DRAW).toString(), "page");
        if (index >= slideNodes.getLength() || index < 0) {
            throw new IndexOutOfBoundsException("the specified Index is out of slide count when call deleteSlideByIndex method.");
        }
        DrawPageElement slideElement = (DrawPageElement)((Object)slideNodes.item(index));
        this.deleteLinkRef(slideElement);
        this.deleteStyleRef(slideElement);
        contentRoot.removeChild((Node)((Object)slideElement));
        this.AdjustNotePageNumber(index);
    }

    private void deleteStyleRef(DrawPageElement slideEle) {
        try {
            int i;
            XPath xpath = this.getXPath();
            ArrayList<OdfElement> removeStyles = new ArrayList<OdfElement>();
            OdfOfficeAutomaticStyles autoStyles = this.getContentDom().getAutomaticStyles();
            NodeList stylesList = autoStyles.getChildNodes();
            for (i = 0; i < stylesList.getLength(); ++i) {
                DrawPageElement tempPage;
                NodeList styleNodes;
                int styleCnt;
                OdfElement node = (OdfElement)((Object)stylesList.item(i));
                String styleName = node.getAttributeNS(OdfNamespace.newNamespace(OdfNamespaceNames.STYLE).toString(), "name");
                if (styleName == null || (styleCnt = (styleNodes = (NodeList)xpath.evaluate("//*[@*='" + styleName + "']", (Object)this.getContentDom(), XPathConstants.NODESET)).getLength()) <= 1) continue;
                OdfElement elementFirst = (OdfElement)((Object)styleNodes.item(1));
                OdfElement elementLast = (OdfElement)((Object)styleNodes.item(styleCnt - 1));
                boolean isSamePage = false;
                if (elementFirst instanceof DrawPageElement && (tempPage = (DrawPageElement)elementFirst).equals(slideEle)) {
                    isSamePage = true;
                }
                short relationFirst = slideEle.compareDocumentPosition((Node)((Object)elementFirst));
                short relationLast = slideEle.compareDocumentPosition((Node)((Object)elementLast));
                if (((relationFirst & 0x10) <= 0 || (relationLast & 0x10) <= 0) && (!isSamePage || styleCnt != 1) || !(node instanceof OdfStyleBase)) continue;
                removeStyles.add(node);
            }
            for (i = 0; i < removeStyles.size(); ++i) {
                autoStyles.removeChild((Node)removeStyles.get(i));
            }
        }
        catch (Exception e) {
            Logger.getLogger(OdfPresentationDocument.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    private void deleteLinkRef(DrawPageElement slideEle) {
        try {
            XPath xpath = this.getXPath();
            NodeList linkNodes = (NodeList)xpath.evaluate("//*[@xlink:href]", (Object)this.getContentDom(), XPathConstants.NODESET);
            for (int i = 0; i < linkNodes.getLength(); ++i) {
                OdfFileEntry fileEntry;
                NodeList pathNodes;
                int refCount;
                OdfElement object = (OdfElement)((Object)linkNodes.item(i));
                String refObjPath = object.getAttributeNS(OdfNamespace.newNamespace(OdfNamespaceNames.XLINK).toString(), "href");
                short relation = slideEle.compareDocumentPosition((Node)((Object)object));
                if ((relation & 0x10) <= 0 || refObjPath == null || refObjPath.length() <= 0 || (refCount = (pathNodes = (NodeList)xpath.evaluate("//*[@xlink:href='" + refObjPath + "']", (Object)this.getContentDom(), XPathConstants.NODESET)).getLength()) != 1) continue;
                if (refObjPath.startsWith("./")) {
                    refObjPath = refObjPath.substring(2);
                }
                if ((fileEntry = this.getPackage().getFileEntry(refObjPath)) != null) {
                    this.getPackage().remove(refObjPath);
                    continue;
                }
                fileEntry = this.getPackage().getFileEntry(refObjPath + "/");
                this.RemoveEmbedDocument(refObjPath);
            }
        }
        catch (XPathExpressionException e) {
            Logger.getLogger(OdfPresentationDocument.class.getName()).log(Level.SEVERE, null, e);
        }
        catch (Exception e) {
            Logger.getLogger(OdfPresentationDocument.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    public void deleteSlideByName(String name) {
        this.checkAllSlideName();
        OfficePresentationElement contentRoot = null;
        try {
            contentRoot = this.getContentRoot();
        }
        catch (Exception e) {
            Logger.getLogger(OdfPresentationDocument.class.getName()).log(Level.SEVERE, null, e);
            return;
        }
        OdfDrawPage slide = this.getSlideByName(name);
        DrawPageElement slideElement = slide.getOdfElement();
        this.deleteLinkRef(slideElement);
        this.deleteStyleRef(slideElement);
        contentRoot.removeChild((Node)((Object)slideElement));
        this.AdjustNotePageNumber(0);
    }

    public OdfDrawPage copySlide(int source, int dest, String newName) {
        this.checkAllSlideName();
        OfficePresentationElement contentRoot = null;
        try {
            contentRoot = this.getContentRoot();
        }
        catch (Exception e) {
            Logger.getLogger(OdfPresentationDocument.class.getName()).log(Level.SEVERE, null, e);
            return null;
        }
        NodeList slideList = contentRoot.getElementsByTagNameNS(OdfNamespace.newNamespace(OdfNamespaceNames.DRAW).toString(), "page");
        int slideCount = slideList.getLength();
        if (source < 0 || source >= slideCount || dest < 0 || dest > slideCount) {
            throw new IndexOutOfBoundsException("the specified Index is out of slide count when call copySlide method.");
        }
        DrawPageElement sourceSlideElement = (DrawPageElement)((Object)slideList.item(source));
        DrawPageElement cloneSlideElement = (DrawPageElement)((Object)sourceSlideElement.cloneNode(true));
        cloneSlideElement.setDrawNameAttribute(newName);
        if (dest == slideCount) {
            contentRoot.appendChild((Node)((Object)cloneSlideElement));
        } else {
            DrawPageElement refSlide = (DrawPageElement)((Object)slideList.item(dest));
            contentRoot.insertBefore((Node)((Object)cloneSlideElement), (Node)((Object)refSlide));
        }
        this.AdjustNotePageNumber(Math.min(source, dest));
        this.hasCheckSlideName = false;
        this.checkAllSlideName();
        return OdfDrawPage.getInstance(cloneSlideElement);
    }

    public void moveSlide(int source, int dest) {
        this.checkAllSlideName();
        OfficePresentationElement contentRoot = null;
        try {
            contentRoot = this.getContentRoot();
        }
        catch (Exception e) {
            Logger.getLogger(OdfPresentationDocument.class.getName()).log(Level.SEVERE, null, e);
            return;
        }
        NodeList slideList = contentRoot.getElementsByTagNameNS(OdfNamespace.newNamespace(OdfNamespaceNames.DRAW).toString(), "page");
        int slideCount = slideList.getLength();
        if (source < 0 || source >= slideCount || dest < 0 || dest > slideCount) {
            throw new IndexOutOfBoundsException("the specified Index is out of slide count when call moveSlide method.");
        }
        DrawPageElement sourceSlide = (DrawPageElement)((Object)slideList.item(source));
        if (dest == slideCount) {
            contentRoot.appendChild((Node)((Object)sourceSlide));
        } else {
            DrawPageElement refSlide = (DrawPageElement)((Object)slideList.item(dest));
            contentRoot.insertBefore((Node)((Object)sourceSlide), (Node)((Object)refSlide));
        }
        this.AdjustNotePageNumber(Math.min(source, dest));
    }

    public void appendPresentation(OdfPresentationDocument srcDoc) {
        this.checkAllSlideName();
        OfficePresentationElement contentRoot = null;
        OdfFileDom contentDom = null;
        OfficePresentationElement srcContentRoot = null;
        try {
            contentRoot = this.getContentRoot();
            contentDom = this.getContentDom();
            srcContentRoot = srcDoc.getContentRoot();
        }
        catch (Exception e) {
            Logger.getLogger(OdfPresentationDocument.class.getName()).log(Level.SEVERE, null, e);
        }
        NodeList slideList = contentRoot.getElementsByTagNameNS(OdfNamespace.newNamespace(OdfNamespaceNames.DRAW).toString(), "page");
        int slideNum = slideList.getLength();
        OfficePresentationElement srcCloneContentRoot = (OfficePresentationElement)((Object)srcContentRoot.cloneNode(true));
        this.copyForeignLinkRef(srcCloneContentRoot);
        this.copyForeignStyleRef(srcCloneContentRoot, srcDoc);
        for (Node child = srcCloneContentRoot.getFirstChild(); child != null; child = child.getNextSibling()) {
            Node cloneElement = this.cloneForeignElement(child, contentDom, true);
            contentRoot.appendChild(cloneElement);
        }
        this.AdjustNotePageNumber(slideNum - 1);
        this.hasCheckSlideName = false;
        this.checkAllSlideName();
    }

    public OdfDrawPage copyForeignSlide(int destIndex, OdfPresentationDocument srcDoc, int srcIndex) {
        this.checkAllSlideName();
        OfficePresentationElement contentRoot = null;
        OdfFileDom contentDom = null;
        try {
            contentRoot = this.getContentRoot();
            contentDom = this.getContentDom();
        }
        catch (Exception e) {
            Logger.getLogger(OdfPresentationDocument.class.getName()).log(Level.SEVERE, null, e);
            return null;
        }
        NodeList slideList = contentRoot.getElementsByTagNameNS(OdfNamespace.newNamespace(OdfNamespaceNames.DRAW).toString(), "page");
        int slideCount = slideList.getLength();
        if (destIndex < 0 || destIndex > slideCount) {
            throw new IndexOutOfBoundsException("the specified Index is out of slide count when call copyForeignSlide method.");
        }
        OdfDrawPage sourceSlide = srcDoc.getSlideByIndex(srcIndex);
        DrawPageElement sourceSlideElement = sourceSlide.getOdfElement();
        DrawPageElement sourceCloneSlideElement = (DrawPageElement)((Object)sourceSlideElement.cloneNode(true));
        this.copyForeignLinkRef(sourceCloneSlideElement);
        this.copyForeignStyleRef(sourceCloneSlideElement, srcDoc);
        DrawPageElement cloneSlideElement = (DrawPageElement)((Object)this.cloneForeignElement((Node)((Object)sourceCloneSlideElement), contentDom, true));
        if (destIndex == slideCount) {
            contentRoot.appendChild((Node)((Object)cloneSlideElement));
        } else {
            DrawPageElement refSlide = (DrawPageElement)((Object)slideList.item(destIndex));
            contentRoot.insertBefore((Node)((Object)cloneSlideElement), (Node)((Object)refSlide));
        }
        this.AdjustNotePageNumber(destIndex);
        this.hasCheckSlideName = false;
        this.checkAllSlideName();
        return OdfDrawPage.getInstance(cloneSlideElement);
    }

    private void copyForeignLinkRef(OdfElement sourceCloneEle) {
        try {
            OdfDocument srcDoc = ((OdfFileDom)((Object)sourceCloneEle.getOwnerDocument())).getOdfDocument();
            HashMap<String, String> objectRenameMap = new HashMap<String, String>();
            XPath xpath = this.getXPath();
            NodeList linkNodes = (NodeList)xpath.evaluate("//*[@xlink:href]", (Object)sourceCloneEle, XPathConstants.NODESET);
            for (int i = 0; i <= linkNodes.getLength(); ++i) {
                InputStream is;
                OdfFileEntry fileEntry;
                OdfElement object = null;
                if (linkNodes.getLength() == i) {
                    if (!sourceCloneEle.hasAttributeNS(OdfNamespace.newNamespace(OdfNamespaceNames.XLINK).toString(), "href")) break;
                    object = sourceCloneEle;
                } else {
                    object = (OdfElement)((Object)linkNodes.item(i));
                }
                String refObjPath = object.getAttributeNS(OdfNamespace.newNamespace(OdfNamespaceNames.XLINK).toString(), "href");
                if (refObjPath == null || refObjPath.length() <= 0) continue;
                boolean hasPrefix = false;
                String prefix = "./";
                if (refObjPath.startsWith(prefix)) {
                    refObjPath = refObjPath.substring(2);
                    hasPrefix = true;
                }
                if ((fileEntry = this.getPackage().getFileEntry(refObjPath)) == null) {
                    fileEntry = this.getPackage().getFileEntry(refObjPath + "/");
                }
                String newObjPath = refObjPath;
                if (fileEntry != null) {
                    newObjPath = (String)objectRenameMap.get(refObjPath);
                    if (newObjPath == null) {
                        int dotIndex = refObjPath.indexOf(".");
                        newObjPath = dotIndex != -1 ? refObjPath.substring(0, dotIndex) + "-" + this.makeUniqueName() + refObjPath.substring(dotIndex) : refObjPath + "-" + this.makeUniqueName();
                        objectRenameMap.put(refObjPath, newObjPath);
                    }
                    object.setAttributeNS(OdfNamespace.newNamespace(OdfNamespaceNames.XLINK).toString(), "xlink:href", hasPrefix ? prefix + newObjPath : newObjPath);
                }
                if ((is = srcDoc.getPackage().getInputStream(refObjPath)) != null) {
                    String mediaType = srcDoc.getPackage().getFileEntry(refObjPath).getMediaType();
                    this.getPackage().insert(is, newObjPath, mediaType);
                    continue;
                }
                OdfDocument embedDoc = srcDoc.getEmbeddedDocument(refObjPath);
                if (embedDoc == null) continue;
                this.embedDocument(newObjPath, embedDoc);
            }
        }
        catch (Exception e) {
            Logger.getLogger(OdfPresentationDocument.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    private void copyForeignStyleRef(OdfElement sourceCloneEle, OdfPresentationDocument doc) {
        try {
            OdfElement cloneStyleElement;
            XPath xpath = this.getXPath();
            String styleQName = "style:name";
            NodeList srcStyleDefNodeList = (NodeList)xpath.evaluate("//*[@" + styleQName + "]", (Object)doc.getContentDom(), XPathConstants.NODESET);
            HashMap<OdfElement, List<OdfElement>> srcContentStyleCloneEleList = new HashMap<OdfElement, List<OdfElement>>();
            HashMap<OdfElement, OdfElement> appendContentStyleList = new HashMap<OdfElement, OdfElement>();
            this.getCopyStyleList(null, sourceCloneEle, styleQName, srcStyleDefNodeList, srcContentStyleCloneEleList, appendContentStyleList, true);
            srcStyleDefNodeList = (NodeList)xpath.evaluate("//*[@" + styleQName + "]", (Object)doc.getStylesDom(), XPathConstants.NODESET);
            HashMap<OdfElement, List<OdfElement>> srcStylesStyleCloneEleList = new HashMap<OdfElement, List<OdfElement>>();
            HashMap<OdfElement, OdfElement> appendStylesStyleList = new HashMap<OdfElement, OdfElement>();
            this.getCopyStyleList(null, sourceCloneEle, styleQName, srcStyleDefNodeList, srcStylesStyleCloneEleList, appendStylesStyleList, true);
            this.InsertCollectedStyle(styleQName, srcContentStyleCloneEleList, this.getContentDom(), appendContentStyleList);
            this.InsertCollectedStyle(styleQName, srcStylesStyleCloneEleList, this.getStylesDom(), appendStylesStyleList);
            styleQName = "draw:name";
            srcStyleDefNodeList = (NodeList)xpath.evaluate("//*[@" + styleQName + "]", (Object)doc.getStylesDom(), XPathConstants.NODESET);
            HashMap<OdfElement, List<OdfElement>> srcDrawStyleCloneEleList = new HashMap<OdfElement, List<OdfElement>>();
            HashMap<OdfElement, OdfElement> appendDrawStyleList = new HashMap<OdfElement, OdfElement>();
            for (OdfElement styleElement : appendContentStyleList.keySet()) {
                cloneStyleElement = appendContentStyleList.get((Object)styleElement);
                this.getCopyStyleList(styleElement, cloneStyleElement, styleQName, srcStyleDefNodeList, srcDrawStyleCloneEleList, appendDrawStyleList, false);
            }
            for (OdfElement styleElement : appendStylesStyleList.keySet()) {
                cloneStyleElement = appendStylesStyleList.get((Object)styleElement);
                this.getCopyStyleList(styleElement, cloneStyleElement, styleQName, srcStyleDefNodeList, srcDrawStyleCloneEleList, appendDrawStyleList, false);
            }
            this.InsertCollectedStyle(styleQName, srcDrawStyleCloneEleList, this.getStylesDom(), appendDrawStyleList);
        }
        catch (Exception e) {
            Logger.getLogger(OdfPresentationDocument.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    private void InsertCollectedStyle(String styleQName, HashMap<OdfElement, List<OdfElement>> srcStyleCloneEleList, OdfFileDom dom, HashMap<OdfElement, OdfElement> appendStyleList) {
        try {
            OdfElement cloneStyleElement;
            XPath xpath = this.getXPath();
            String stylePrefix = OdfNamespace.getPrefixPart(styleQName);
            String styleLocalName = OdfNamespace.getLocalPart(styleQName);
            String styleURI = OdfNamespace.getNamespaceURIByPrefix(stylePrefix);
            NodeList destStyleNodeList = (NodeList)xpath.evaluate("//*[@" + styleQName + "]", (Object)dom, XPathConstants.NODESET);
            for (OdfElement styleElement : srcStyleCloneEleList.keySet()) {
                cloneStyleElement = appendStyleList.get((Object)styleElement);
                if (cloneStyleElement == null) {
                    cloneStyleElement = (OdfElement)((Object)styleElement.cloneNode(true));
                    appendStyleList.put(styleElement, cloneStyleElement);
                }
                String styleName = styleElement.getAttributeNS(styleURI, styleLocalName);
                List<String> newStyleNameList = this.styleRenameMap.get(styleName);
                OdfElement destStyleElement = null;
                if (newStyleNameList == null && (destStyleElement = this.IsStyleNameExist(destStyleNodeList, styleName)) == null) continue;
                String newStyleName = null;
                if (newStyleNameList == null) {
                    newStyleNameList = new ArrayList<String>();
                    newStyleName = styleName + "-" + this.makeUniqueName();
                    newStyleNameList.add(newStyleName);
                    this.styleRenameMap.put(styleName, newStyleNameList);
                } else {
                    for (int i = 0; i < newStyleNameList.size(); ++i) {
                        String styleNameIter = newStyleNameList.get(i);
                        OdfElement destStyleElementWithNewName = this.IsStyleNameExist(destStyleNodeList, styleNameIter);
                        cloneStyleElement.setAttributeNS(styleURI, styleQName, styleNameIter);
                        if (destStyleElementWithNewName == null || !destStyleElementWithNewName.equals((Object)cloneStyleElement)) continue;
                        newStyleName = styleNameIter;
                        break;
                    }
                    if (newStyleName == null) {
                        newStyleName = styleName + "-" + this.makeUniqueName();
                        newStyleNameList.add(newStyleName);
                    }
                }
                if (!this.changeStyleRefName(srcStyleCloneEleList.get((Object)styleElement), styleName, newStyleName)) continue;
                cloneStyleElement.setAttributeNS(styleURI, styleQName, newStyleName);
                String displayName = cloneStyleElement.getAttributeNS(styleURI, "display-name");
                if (displayName == null || displayName.length() <= 0) continue;
                cloneStyleElement.setAttributeNS(styleURI, stylePrefix + ":display-name", displayName + newStyleName.substring(newStyleName.length() - 8));
            }
            for (OdfElement styleElement : appendStyleList.keySet()) {
                cloneStyleElement = appendStyleList.get((Object)styleElement);
                String newStyleName = cloneStyleElement.getAttributeNS(styleURI, styleLocalName);
                Boolean isAppended = this.styleAppendMap.get(newStyleName);
                if (isAppended != null && isAppended.booleanValue()) continue;
                this.styleAppendMap.put(newStyleName, new Boolean(true));
                OdfElement cloneForeignStyleElement = (OdfElement)((Object)this.cloneForeignElement((Node)((Object)cloneStyleElement), dom, true));
                String styleElePath = this.getElementPath(styleElement);
                this.appendForeignStyleElement(cloneForeignStyleElement, dom, styleElePath);
                this.copyForeignLinkRef(cloneStyleElement);
            }
        }
        catch (Exception e) {
            Logger.getLogger(OdfPresentationDocument.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    private void getCopyStyleList(OdfElement ele, OdfElement cloneEle, String styleQName, NodeList srcStyleNodeList, HashMap<OdfElement, List<OdfElement>> copyStyleEleList, HashMap<OdfElement, OdfElement> appendStyleList, boolean loop) {
        try {
            XPath xpath = this.getXPath();
            String stylePrefix = OdfNamespace.getPrefixPart(styleQName);
            String styleLocalName = OdfNamespace.getLocalPart(styleQName);
            String styleURI = OdfNamespace.getNamespaceURIByPrefix(stylePrefix);
            String cloneEleStr = cloneEle.toString();
            for (int i = 0; i < srcStyleNodeList.getLength(); ++i) {
                OdfElement styleElement = (OdfElement)((Object)srcStyleNodeList.item(i));
                String styleName = styleElement.getAttributeNS(styleURI, styleLocalName);
                if (styleName == null) continue;
                int index = 0;
                index = cloneEleStr.indexOf("=\"" + styleName + "\"", index);
                while (index >= 0) {
                    String subStr = cloneEleStr.substring(0, index);
                    int lastSpaceIndex = subStr.lastIndexOf(32);
                    String attrStr = subStr.substring(lastSpaceIndex + 1, index);
                    NodeList styleRefNodes = (NodeList)xpath.evaluate("//*[@" + attrStr + "='" + styleName + "']", (Object)cloneEle, XPathConstants.NODESET);
                    boolean isExist = false;
                    for (int j = 0; j <= styleRefNodes.getLength(); ++j) {
                        OdfElement styleRefElement = null;
                        if (j == styleRefNodes.getLength()) {
                            isExist = this.IsStyleNameRefExist((Node)((Object)cloneEle), styleName, false);
                            if (!isExist) continue;
                            styleRefElement = cloneEle;
                        } else {
                            OdfElement tmpElement = (OdfElement)((Object)styleRefNodes.item(j));
                            if (!this.IsStyleNameRefExist((Node)((Object)tmpElement), styleName, false)) continue;
                            styleRefElement = tmpElement;
                        }
                        boolean hasLoopStyleDef = true;
                        if (copyStyleEleList.get((Object)styleElement) == null) {
                            ArrayList styleRefEleList = new ArrayList();
                            copyStyleEleList.put(styleElement, styleRefEleList);
                            hasLoopStyleDef = false;
                        }
                        copyStyleEleList.get((Object)styleElement).add(styleRefElement);
                        OdfElement cloneStyleElement = appendStyleList.get((Object)styleElement);
                        if (cloneStyleElement == null) {
                            cloneStyleElement = (OdfElement)((Object)styleElement.cloneNode(true));
                            appendStyleList.put(styleElement, cloneStyleElement);
                        }
                        if (!loop || hasLoopStyleDef) continue;
                        this.getCopyStyleList(styleElement, cloneStyleElement, styleQName, srcStyleNodeList, copyStyleEleList, appendStyleList, loop);
                    }
                    index = cloneEleStr.indexOf("=\"" + styleName + "\"", index + styleName.length());
                }
            }
        }
        catch (Exception e) {
            Logger.getLogger(OdfPresentationDocument.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    private void appendForeignStyleElement(OdfElement cloneStyleEle, OdfFileDom dom, String styleElePath) {
        StringTokenizer token = new StringTokenizer(styleElePath, "/");
        boolean isExist = true;
        Node iterNode = dom.getFirstChild();
        Object parentNode = dom;
        while (token.hasMoreTokens()) {
            String onePath = token.nextToken();
            while (iterNode != null && isExist) {
                String path = iterNode.getNamespaceURI();
                String prefix = iterNode.getPrefix();
                path = prefix == null ? path + "@" + iterNode.getLocalName() : path + "@" + prefix + ":" + iterNode.getLocalName();
                if (!path.equals(onePath)) {
                    iterNode = iterNode.getNextSibling();
                    continue;
                }
                parentNode = iterNode;
                iterNode = iterNode.getFirstChild();
                break;
            }
            if (iterNode != null) continue;
            if (isExist) {
                isExist = false;
            }
            StringTokenizer token2 = new StringTokenizer(onePath, "@");
            OdfElement newElement = dom.createElementNS(OdfName.newName(token2.nextToken(), token2.nextToken()));
            parentNode.appendChild((Node)((Object)newElement));
            parentNode = newElement;
        }
        parentNode.appendChild((Node)((Object)cloneStyleEle));
    }

    private String getElementPath(OdfElement styleEle) {
        String path = "";
        Node parentNode = styleEle.getParentNode();
        while (!(parentNode instanceof OdfFileDom)) {
            String qname = null;
            String prefix = parentNode.getPrefix();
            qname = prefix == null ? parentNode.getLocalName() : prefix + ":" + parentNode.getLocalName();
            path = parentNode.getNamespaceURI() + "@" + qname + "/" + path;
            parentNode = parentNode.getParentNode();
        }
        return path;
    }

    private boolean changeStyleRefName(List<OdfElement> list, String oldStyleName, String newStyleName) {
        boolean rtn = false;
        block2: for (int index = 0; index < list.size(); ++index) {
            OdfElement element = list.get(index);
            NamedNodeMap attributes = element.getAttributes();
            if (attributes == null) continue;
            for (int i = 0; i < attributes.getLength(); ++i) {
                Node item = attributes.item(i);
                String value = item.getNodeValue();
                if (!oldStyleName.equals(value)) continue;
                try {
                    item.setNodeValue(newStyleName);
                    rtn = true;
                    continue block2;
                }
                catch (IllegalArgumentException e) {
                    return false;
                }
            }
        }
        return rtn;
    }

    private boolean IsStyleNameRefExist(Node element, String styleName, boolean deep) {
        NamedNodeMap attributes = element.getAttributes();
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                Node item = attributes.item(i);
                if (!item.getNodeValue().equals(styleName) || item.getNodeName().equals("style:name")) continue;
                return true;
            }
        }
        if (deep) {
            for (Node childNode = element.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
                if (!this.IsStyleNameRefExist(childNode, styleName, true)) {
                    continue;
                }
                return true;
            }
        }
        return false;
    }

    private OdfElement IsStyleNameExist(NodeList nodeList, String styleName) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            OdfElement element = (OdfElement)((Object)nodeList.item(i));
            String name = element.getAttributeNS(OdfNamespace.newNamespace(OdfNamespaceNames.STYLE).toString(), "name");
            if (!name.equals(styleName)) continue;
            return element;
        }
        return null;
    }

    private String makeUniqueName() {
        return String.format("a%06x", (int)(Math.random() * 1.6777215E7));
    }

    public Node cloneForeignElement(Node element, OdfFileDom dom, boolean deep) {
        this.checkAllSlideName();
        if (element instanceof OdfElement) {
            OdfElement cloneElement = dom.createElementNS(((OdfElement)((Object)element)).getOdfName());
            NamedNodeMap attributes = element.getAttributes();
            if (attributes != null) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Node item = attributes.item(i);
                    String qname = null;
                    String prefix = item.getPrefix();
                    qname = prefix == null ? item.getLocalName() : prefix + ":" + item.getLocalName();
                    cloneElement.setAttributeNS(item.getNamespaceURI(), qname, item.getNodeValue());
                }
            }
            if (deep) {
                for (Node childNode = element.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
                    cloneElement.appendChild(this.cloneForeignElement(childNode, dom, true));
                }
            }
            return cloneElement;
        }
        return dom.createTextNode(element.getNodeValue());
    }

    public OdfDrawPage newSlide(int index, String name, OdfDrawPage.SlideLayout slideLayout) {
        String pageLayoutName;
        this.checkAllSlideName();
        OfficePresentationElement contentRoot = null;
        try {
            contentRoot = this.getContentRoot();
        }
        catch (Exception e) {
            Logger.getLogger(OdfPresentationDocument.class.getName()).log(Level.SEVERE, null, e);
            return null;
        }
        NodeList slideList = contentRoot.getElementsByTagNameNS(OdfNamespace.newNamespace(OdfNamespaceNames.DRAW).toString(), "page");
        int slideCount = slideList.getLength();
        if (index < 0 || index > slideCount) {
            throw new IndexOutOfBoundsException("the specified Index is out of slide count when call newSlide method.");
        }
        DrawPageElement refStyleSlide = null;
        int refSlideIndex = 0;
        if (index > 0) {
            refSlideIndex = index - 1;
        }
        refStyleSlide = (DrawPageElement)((Object)slideList.item(refSlideIndex));
        String masterPageStyleName = "Default";
        String masterName = refStyleSlide.getDrawMasterPageNameAttribute();
        if (masterName != null) {
            masterPageStyleName = masterName;
        }
        DrawPageElement newSlideElement = contentRoot.newDrawPageElement(masterPageStyleName);
        newSlideElement.setDrawNameAttribute(name);
        String drawStyleName = refStyleSlide.getDrawStyleNameAttribute();
        if (drawStyleName != null) {
            newSlideElement.setDrawStyleNameAttribute(drawStyleName);
        }
        if ((pageLayoutName = refStyleSlide.getPresentationPresentationPageLayoutNameAttribute()) != null) {
            newSlideElement.setPresentationPresentationPageLayoutNameAttribute(pageLayoutName);
        }
        this.setSlideLayout(newSlideElement, slideLayout);
        NodeList noteNodes = refStyleSlide.getElementsByTagNameNS(OdfNamespace.newNamespace(OdfNamespaceNames.PRESENTATION).toString(), "notes");
        if (noteNodes.getLength() > 0) {
            PresentationNotesElement notePage = (PresentationNotesElement)((Object)noteNodes.item(0));
            PresentationNotesElement cloneNotePage = (PresentationNotesElement)((Object)notePage.cloneNode(true));
            newSlideElement.appendChild((Node)((Object)cloneNotePage));
        }
        if (index < slideCount) {
            DrawPageElement refSlide = (DrawPageElement)((Object)slideList.item(index));
            contentRoot.insertBefore((Node)((Object)newSlideElement), (Node)((Object)refSlide));
        }
        this.AdjustNotePageNumber(index);
        this.hasCheckSlideName = false;
        this.checkAllSlideName();
        return OdfDrawPage.getInstance(newSlideElement);
    }

    private void AdjustNotePageNumber(int startIndex) {
        try {
            OfficePresentationElement contentRoot = this.getContentRoot();
            NodeList slideList = contentRoot.getElementsByTagNameNS(OdfNamespace.newNamespace(OdfNamespaceNames.DRAW).toString(), "page");
            for (int i = startIndex; i < this.getSlideCount(); ++i) {
                PresentationNotesElement notePage;
                NodeList thumbnailList;
                DrawPageElement page = (DrawPageElement)((Object)slideList.item(i));
                NodeList noteNodes = page.getElementsByTagNameNS(OdfNamespace.newNamespace(OdfNamespaceNames.PRESENTATION).toString(), "notes");
                if (noteNodes.getLength() <= 0 || (thumbnailList = (notePage = (PresentationNotesElement)((Object)noteNodes.item(0))).getElementsByTagNameNS(OdfNamespace.newNamespace(OdfNamespaceNames.DRAW).toString(), "page-thumbnail")).getLength() <= 0) continue;
                DrawPageThumbnailElement thumbnail = (DrawPageThumbnailElement)((Object)thumbnailList.item(0));
                thumbnail.setDrawPageNumberAttribute(i + 1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setSlideLayout(DrawPageElement page, OdfDrawPage.SlideLayout slideLayout) {
        if (slideLayout == null) {
            slideLayout = OdfDrawPage.SlideLayout.BLANK;
        }
        OdfOfficeStyles styles = this.getOrCreateDocumentStyles();
        if (slideLayout.toString().equals(OdfDrawPage.SlideLayout.TITLE_ONLY.toString())) {
            String layoutName = "AL1T" + this.makeUniqueName();
            try {
                StylePresentationPageLayoutElement layout = styles.newStylePresentationPageLayoutElement(layoutName);
                layout.newPresentationPlaceholderElement("title", "2.058cm", "1.743cm", "23.91cm", "3.507cm");
            }
            catch (Exception e1) {
                Logger.getLogger(OdfPresentationDocument.class.getName()).log(Level.SEVERE, null, e1);
            }
            page.setPresentationPresentationPageLayoutNameAttribute(layoutName);
            DrawFrameElement frame1 = page.newDrawFrameElement();
            frame1.setProperty(StyleGraphicPropertiesElement.Shadow, "true");
            frame1.setProperty(StyleGraphicPropertiesElement.AutoGrowHeight, "true");
            frame1.setProperty(StyleGraphicPropertiesElement.MinHeight, "3.507");
            frame1.setPresentationStyleNameAttribute(frame1.getStyleName());
            frame1.setDrawLayerAttribute("layout");
            frame1.setSvgHeightAttribute("3.006cm");
            frame1.setSvgWidthAttribute("24.299cm");
            frame1.setSvgXAttribute("1.35cm");
            frame1.setSvgYAttribute("0.717cm");
            frame1.setPresentationClassAttribute(PresentationClassAttribute.Value.TITLE.toString());
            frame1.setPresentationPlaceholderAttribute(new Boolean(true));
            frame1.newDrawTextBoxElement();
        } else if (slideLayout.toString().equals(OdfDrawPage.SlideLayout.TITLE_OUTLINE.toString())) {
            String layoutName = this.makeUniqueName();
            try {
                styles = super.getStylesDom().getOfficeStyles();
                if (styles == null) {
                    styles = super.getStylesDom().newOdfElement(OdfOfficeStyles.class);
                }
                StylePresentationPageLayoutElement layout = styles.newStylePresentationPageLayoutElement(layoutName);
                layout.newPresentationPlaceholderElement("title", "2.058cm", "1.743cm", "23.91cm", "3.507cm");
                layout.newPresentationPlaceholderElement("outline", "2.058cm", "1.743cm", "23.91cm", "3.507cm");
            }
            catch (Exception e1) {
                Logger.getLogger(OdfPresentationDocument.class.getName()).log(Level.SEVERE, null, e1);
            }
            page.setPresentationPresentationPageLayoutNameAttribute(layoutName);
            DrawFrameElement frame1 = page.newDrawFrameElement();
            frame1.setProperty(StyleGraphicPropertiesElement.Shadow, "true");
            frame1.setProperty(StyleGraphicPropertiesElement.AutoGrowHeight, "true");
            frame1.setProperty(StyleGraphicPropertiesElement.MinHeight, "3.507");
            frame1.setPresentationStyleNameAttribute(frame1.getStyleName());
            frame1.setDrawLayerAttribute("layout");
            frame1.setSvgHeightAttribute("3.006cm");
            frame1.setSvgWidthAttribute("24.299cm");
            frame1.setSvgXAttribute("1.35cm");
            frame1.setSvgYAttribute("0.717cm");
            frame1.setPresentationClassAttribute(PresentationClassAttribute.Value.TITLE.toString());
            frame1.setPresentationPlaceholderAttribute(new Boolean(true));
            frame1.newDrawTextBoxElement();
            DrawFrameElement frame2 = page.newDrawFrameElement();
            frame2.setProperty(StyleGraphicPropertiesElement.FillColor, "#ffffff");
            frame2.setProperty(StyleGraphicPropertiesElement.MinHeight, "13.114");
            frame2.setPresentationStyleNameAttribute(frame2.getStyleName());
            frame2.setDrawLayerAttribute("layout");
            frame2.setSvgHeightAttribute("11.629cm");
            frame2.setSvgWidthAttribute("24.199cm");
            frame2.setSvgXAttribute("1.35cm");
            frame2.setSvgYAttribute("4.337cm");
            frame2.setPresentationClassAttribute(PresentationClassAttribute.Value.OUTLINE.toString());
            frame2.setPresentationPlaceholderAttribute(new Boolean(true));
            frame2.newDrawTextBoxElement();
        } else if (slideLayout.toString().equals(OdfDrawPage.SlideLayout.TITLE_PLUS_TEXT.toString())) {
            String layoutName = this.makeUniqueName();
            try {
                styles = super.getStylesDom().getOfficeStyles();
                if (styles == null) {
                    styles = super.getStylesDom().newOdfElement(OdfOfficeStyles.class);
                }
                StylePresentationPageLayoutElement layout = styles.newStylePresentationPageLayoutElement(layoutName);
                layout.newPresentationPlaceholderElement("title", "2.058cm", "1.743cm", "23.91cm", "1.743cm");
                layout.newPresentationPlaceholderElement("subtitle", "2.058cm", "5.838cm", "23.91cm", "13.23cm");
            }
            catch (Exception e1) {
                Logger.getLogger(OdfPresentationDocument.class.getName()).log(Level.SEVERE, null, e1);
            }
            page.setPresentationPresentationPageLayoutNameAttribute(layoutName);
            DrawFrameElement frame1 = page.newDrawFrameElement();
            frame1.setProperty(StyleGraphicPropertiesElement.AutoGrowHeight, "true");
            frame1.setProperty(StyleGraphicPropertiesElement.MinHeight, "3.507");
            frame1.setPresentationStyleNameAttribute(frame1.getStyleName());
            frame1.setDrawLayerAttribute("layout");
            frame1.setSvgHeightAttribute("3.006cm");
            frame1.setSvgWidthAttribute("24.299cm");
            frame1.setSvgXAttribute("1.35cm");
            frame1.setSvgYAttribute("0.717cm");
            frame1.setPresentationClassAttribute(PresentationClassAttribute.Value.TITLE.toString());
            frame1.setPresentationPlaceholderAttribute(new Boolean(true));
            frame1.newDrawTextBoxElement();
            DrawFrameElement frame2 = page.newDrawFrameElement();
            frame2.setProperty(StyleGraphicPropertiesElement.AutoGrowHeight, "true");
            frame2.setProperty(StyleGraphicPropertiesElement.MinHeight, "3.507");
            frame2.setPresentationStyleNameAttribute(frame2.getStyleName());
            frame2.setDrawLayerAttribute("layout");
            frame2.setSvgHeightAttribute("11.88cm");
            frame2.setSvgWidthAttribute("24.299cm");
            frame2.setSvgXAttribute("1.35cm");
            frame2.setSvgYAttribute("4.712cm");
            frame2.setPresentationClassAttribute(PresentationClassAttribute.Value.SUBTITLE.toString());
            frame2.setPresentationPlaceholderAttribute(new Boolean(true));
            frame2.newDrawTextBoxElement();
        } else if (slideLayout.toString().equals(OdfDrawPage.SlideLayout.TITLE_PLUS_2_TEXT_BLOCK.toString())) {
            String layoutName = this.makeUniqueName();
            try {
                styles = super.getStylesDom().getOfficeStyles();
                if (styles == null) {
                    styles = super.getStylesDom().newOdfElement(OdfOfficeStyles.class);
                }
                StylePresentationPageLayoutElement layout = styles.newStylePresentationPageLayoutElement(layoutName);
                layout.newPresentationPlaceholderElement("outline", "2.058cm", "1.743cm", "23.91cm", "1.743cm");
                layout.newPresentationPlaceholderElement("outline", "1.35cm", "4.212cm", "11.857cm", "11.629cm");
                layout.newPresentationPlaceholderElement("outline", "4.212cm", "13.8cm", "11.857cm", "11.629cm");
            }
            catch (Exception e1) {
                Logger.getLogger(OdfPresentationDocument.class.getName()).log(Level.SEVERE, null, e1);
            }
            DrawFrameElement frame1 = page.newDrawFrameElement();
            frame1.setProperty(StyleGraphicPropertiesElement.AutoGrowHeight, "true");
            frame1.setProperty(StyleGraphicPropertiesElement.MinHeight, "3.507");
            frame1.setPresentationStyleNameAttribute(frame1.getStyleName());
            frame1.setDrawLayerAttribute("layout");
            frame1.setSvgHeightAttribute("3.006cm");
            frame1.setSvgWidthAttribute("24.299cm");
            frame1.setSvgXAttribute("1.35cm");
            frame1.setSvgYAttribute("0.717cm");
            frame1.setPresentationClassAttribute(PresentationClassAttribute.Value.TITLE.toString());
            frame1.setPresentationPlaceholderAttribute(new Boolean(true));
            frame1.newDrawTextBoxElement();
            DrawFrameElement frame2 = page.newDrawFrameElement();
            frame2.setProperty(StyleGraphicPropertiesElement.AutoGrowHeight, "true");
            frame2.setProperty(StyleGraphicPropertiesElement.MinHeight, "3.507");
            frame2.setPresentationStyleNameAttribute(frame2.getStyleName());
            frame2.setDrawLayerAttribute("layout");
            frame2.setSvgHeightAttribute("11.629cm");
            frame2.setSvgWidthAttribute("11.857cm");
            frame2.setSvgXAttribute("1.35cm");
            frame2.setSvgYAttribute("4.212cm");
            frame2.setPresentationClassAttribute(PresentationClassAttribute.Value.OUTLINE.toString());
            frame2.setPresentationPlaceholderAttribute(new Boolean(true));
            frame2.newDrawTextBoxElement();
            DrawFrameElement frame3 = page.newDrawFrameElement();
            frame3.setProperty(StyleGraphicPropertiesElement.AutoGrowHeight, "true");
            frame3.setProperty(StyleGraphicPropertiesElement.MinHeight, "3.507");
            frame3.setPresentationStyleNameAttribute(frame3.getStyleName());
            frame3.setDrawLayerAttribute("layout");
            frame3.setSvgHeightAttribute("11.62cm");
            frame3.setSvgWidthAttribute("11.857cm");
            frame3.setSvgXAttribute("13.8cm");
            frame3.setSvgYAttribute("4.212cm");
            frame3.setPresentationClassAttribute(PresentationClassAttribute.Value.OUTLINE.toString());
            frame3.setPresentationPlaceholderAttribute(new Boolean(true));
            frame3.newDrawTextBoxElement();
            page.setPresentationPresentationPageLayoutNameAttribute(layoutName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OdfMediaType {
        PRESENTATION(OdfDocument.OdfMediaType.PRESENTATION),
        PRESENTATION_TEMPLATE(OdfDocument.OdfMediaType.PRESENTATION_TEMPLATE);

        private final OdfDocument.OdfMediaType mMediaType;

        private OdfMediaType(OdfDocument.OdfMediaType mediaType) {
            this.mMediaType = mediaType;
        }

        public String toString() {
            return this.mMediaType.toString();
        }

        public OdfDocument.OdfMediaType getOdfMediaType() {
            return this.mMediaType;
        }

        public String getName() {
            return this.mMediaType.getName();
        }

        public String getSuffix() {
            return this.mMediaType.getSuffix();
        }

        public static OdfDocument.OdfMediaType getOdfMediaType(String mediaType) {
            return OdfDocument.OdfMediaType.getOdfMediaType(mediaType);
        }
    }
}

