/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.type;

import java.util.regex.Pattern;
import org.odftoolkit.odfdom.type.OdfDataType;

public class NamespacedToken
implements OdfDataType {
    private String mNamespacedToken;
    private static final Pattern namespacedTokenPattern = Pattern.compile("^[0-9a-zA-Z_]+:[0-9a-zA-Z._\\-]+$");

    public NamespacedToken(String namespacedToken) throws IllegalArgumentException {
        if (!NamespacedToken.isValid(namespacedToken)) {
            throw new IllegalArgumentException("parameter is invalid for datatype NamespacedToken");
        }
        this.mNamespacedToken = namespacedToken;
    }

    public String toString() {
        return this.mNamespacedToken;
    }

    public static NamespacedToken valueOf(String stringValue) throws IllegalArgumentException {
        return new NamespacedToken(stringValue);
    }

    public static boolean isValid(String stringValue) {
        return stringValue != null && namespacedTokenPattern.matcher(stringValue).matches();
    }
}

