/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.smooth;

import bibliothek.extension.gui.dock.theme.smooth.SmoothChanger;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.themes.basic.BasicStationTitle;
import bibliothek.gui.dock.title.DockTitleVersion;
import bibliothek.util.Colors;

public class SmoothDefaultStationTitle
extends BasicStationTitle {
    private int current = 0;
    private SmoothChanger changer = new SmoothChanger(2){

        protected int destination() {
            if (SmoothDefaultStationTitle.this.isActive()) {
                return 0;
            }
            return 1;
        }

        protected void repaint(int[] current) {
            SmoothDefaultStationTitle.this.current = current[0];
            SmoothDefaultStationTitle.this.updateColors();
        }
    };

    public void setActive(boolean active) {
        super.setActive(active);
        if (this.changer != null) {
            this.changer.trigger();
        }
    }

    public SmoothDefaultStationTitle(Dockable dockable, DockTitleVersion origin) {
        super(dockable, origin);
    }

    public int getDuration() {
        return this.changer.getDuration();
    }

    public void setDuration(int duration) {
        this.changer.setDuration(duration);
    }

    protected void updateColors() {
        super.updateColors();
        if (this.changer != null) {
            int duration = this.getDuration();
            if (this.isActive() && this.current != duration || !this.isActive() && this.current != 0) {
                double ratio = (double)this.current / (double)duration;
                this.setForeground(Colors.between(this.getInactiveTextColor(), this.getActiveTextColor(), ratio));
                this.setBackground(Colors.between(this.getInactiveColor(), this.getActiveColor(), ratio));
            }
        }
    }
}

