/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.incubator.meta;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.odftoolkit.odfdom.OdfElement;
import org.odftoolkit.odfdom.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.dc.DcCreatorElement;
import org.odftoolkit.odfdom.dom.element.dc.DcDateElement;
import org.odftoolkit.odfdom.dom.element.dc.DcDescriptionElement;
import org.odftoolkit.odfdom.dom.element.dc.DcLanguageElement;
import org.odftoolkit.odfdom.dom.element.dc.DcSubjectElement;
import org.odftoolkit.odfdom.dom.element.dc.DcTitleElement;
import org.odftoolkit.odfdom.dom.element.meta.MetaAutoReloadElement;
import org.odftoolkit.odfdom.dom.element.meta.MetaCreationDateElement;
import org.odftoolkit.odfdom.dom.element.meta.MetaDocumentStatisticElement;
import org.odftoolkit.odfdom.dom.element.meta.MetaEditingCyclesElement;
import org.odftoolkit.odfdom.dom.element.meta.MetaEditingDurationElement;
import org.odftoolkit.odfdom.dom.element.meta.MetaGeneratorElement;
import org.odftoolkit.odfdom.dom.element.meta.MetaHyperlinkBehaviourElement;
import org.odftoolkit.odfdom.dom.element.meta.MetaInitialCreatorElement;
import org.odftoolkit.odfdom.dom.element.meta.MetaKeywordElement;
import org.odftoolkit.odfdom.dom.element.meta.MetaPrintDateElement;
import org.odftoolkit.odfdom.dom.element.meta.MetaPrintedByElement;
import org.odftoolkit.odfdom.dom.element.meta.MetaTemplateElement;
import org.odftoolkit.odfdom.dom.element.meta.MetaUserDefinedElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeDocumentMetaElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeMetaElement;
import org.odftoolkit.odfdom.incubator.meta.OdfMetaAutoReload;
import org.odftoolkit.odfdom.incubator.meta.OdfMetaDocumentStatistic;
import org.odftoolkit.odfdom.incubator.meta.OdfMetaHyperlinkBehaviour;
import org.odftoolkit.odfdom.incubator.meta.OdfMetaTemplate;
import org.odftoolkit.odfdom.type.Duration;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OdfOfficeMeta {
    private OfficeMetaElement mOfficeMetaElement;

    public OdfOfficeMeta(OdfFileDom metaDom) {
        OfficeDocumentMetaElement metaEle = OdfElement.findFirstChildNode(OfficeDocumentMetaElement.class, (Node)((Object)metaDom));
        this.mOfficeMetaElement = OdfElement.findFirstChildNode(OfficeMetaElement.class, (Node)((Object)metaEle));
    }

    public OfficeMetaElement getOfficeMetaElement() {
        return this.mOfficeMetaElement;
    }

    public String getGenerator() {
        MetaGeneratorElement metaGenerator = OdfElement.findFirstChildNode(MetaGeneratorElement.class, (Node)((Object)this.mOfficeMetaElement));
        if (metaGenerator != null) {
            return metaGenerator.getTextContent();
        }
        return null;
    }

    public void setGenerator(String generator) {
        MetaGeneratorElement metaGenerator = OdfElement.findFirstChildNode(MetaGeneratorElement.class, (Node)((Object)this.mOfficeMetaElement));
        if (metaGenerator == null) {
            metaGenerator = this.mOfficeMetaElement.newMetaGeneratorElement();
        }
        metaGenerator.setTextContent(generator);
    }

    public String getTitle() {
        DcTitleElement titleEle = OdfElement.findFirstChildNode(DcTitleElement.class, (Node)((Object)this.mOfficeMetaElement));
        if (titleEle != null) {
            return titleEle.getTextContent();
        }
        return null;
    }

    public void setTitle(String title) {
        DcTitleElement titleEle = OdfElement.findFirstChildNode(DcTitleElement.class, (Node)((Object)this.mOfficeMetaElement));
        if (titleEle == null) {
            titleEle = this.mOfficeMetaElement.newDcTitleElement();
        }
        titleEle.setTextContent(title);
    }

    public String getDescription() {
        DcDescriptionElement descEle = OdfElement.findFirstChildNode(DcDescriptionElement.class, (Node)((Object)this.mOfficeMetaElement));
        if (descEle != null) {
            return descEle.getTextContent();
        }
        return null;
    }

    public void setDescription(String description) {
        DcDescriptionElement descEle = OdfElement.findFirstChildNode(DcDescriptionElement.class, (Node)((Object)this.mOfficeMetaElement));
        if (descEle == null) {
            descEle = this.mOfficeMetaElement.newDcDescriptionElement();
        }
        descEle.setTextContent(description);
    }

    public String getSubject() {
        DcSubjectElement subjectEle = OdfElement.findFirstChildNode(DcSubjectElement.class, (Node)((Object)this.mOfficeMetaElement));
        if (subjectEle != null) {
            return subjectEle.getTextContent();
        }
        return null;
    }

    public void setSubject(String subject) {
        DcSubjectElement subjectEle = OdfElement.findFirstChildNode(DcSubjectElement.class, (Node)((Object)this.mOfficeMetaElement));
        if (subjectEle == null) {
            subjectEle = this.mOfficeMetaElement.newDcSubjectElement();
        }
        subjectEle.setTextContent(subject);
    }

    public List<String> getKeywords() {
        ArrayList<String> keywords = new ArrayList<String>();
        MetaKeywordElement keywordEle = OdfElement.findFirstChildNode(MetaKeywordElement.class, (Node)((Object)this.mOfficeMetaElement));
        if (keywordEle != null) {
            MetaKeywordElement keywordNext;
            keywords.add(keywordEle.getTextContent());
            while ((keywordNext = OdfElement.findNextChildNode(MetaKeywordElement.class, (Node)((Object)keywordEle))) != null) {
                keywords.add(keywordNext.getTextContent());
                keywordEle = keywordNext;
            }
            return keywords;
        }
        return null;
    }

    public void setKeywords(List<String> keyList) {
        MetaKeywordElement keywordEle = OdfElement.findFirstChildNode(MetaKeywordElement.class, (Node)((Object)this.mOfficeMetaElement));
        ArrayList<MetaKeywordElement> toBeDeleted = new ArrayList<MetaKeywordElement>();
        if (keywordEle != null) {
            MetaKeywordElement keywordTmp;
            toBeDeleted.add(keywordEle);
            while ((keywordTmp = OdfElement.findNextChildNode(MetaKeywordElement.class, (Node)((Object)keywordEle))) != null) {
                keywordEle = keywordTmp;
                toBeDeleted.add(keywordTmp);
            }
        }
        for (MetaKeywordElement keyele : toBeDeleted) {
            this.mOfficeMetaElement.removeChild((Node)((Object)keyele));
        }
        for (int i = 0; i < keyList.size(); ++i) {
            MetaKeywordElement keywordElement = this.mOfficeMetaElement.newMetaKeywordElement();
            keywordElement.setTextContent(keyList.get(i));
        }
    }

    public void addKeyword(String keyword) {
        MetaKeywordElement keywordElement = this.mOfficeMetaElement.newMetaKeywordElement();
        keywordElement.setTextContent(keyword);
    }

    public List<String> getUserDefinedDataNames() {
        ArrayList<String> definedNames = new ArrayList<String>();
        MetaUserDefinedElement definedEle = OdfElement.findFirstChildNode(MetaUserDefinedElement.class, (Node)((Object)this.mOfficeMetaElement));
        if (definedEle != null) {
            MetaUserDefinedElement definedNext;
            definedNames.add(definedEle.getMetaNameAttribute());
            while ((definedNext = OdfElement.findNextChildNode(MetaUserDefinedElement.class, (Node)((Object)definedEle))) != null) {
                definedNames.add(definedNext.getMetaNameAttribute());
                definedEle = definedNext;
            }
            return definedNames;
        }
        return null;
    }

    public MetaUserDefinedElement getUserDefinedElementByAttributeName(String name) {
        MetaUserDefinedElement definedEle = OdfElement.findFirstChildNode(MetaUserDefinedElement.class, (Node)((Object)this.mOfficeMetaElement));
        if (definedEle != null) {
            MetaUserDefinedElement definedNext;
            if (definedEle.getMetaNameAttribute().equals(name)) {
                return definedEle;
            }
            while ((definedNext = OdfElement.findNextChildNode(MetaUserDefinedElement.class, (Node)((Object)definedEle))) != null) {
                if (definedNext.getMetaNameAttribute().equals(name)) {
                    return definedNext;
                }
                definedEle = definedNext;
            }
            return null;
        }
        return null;
    }

    public String getUserDefinedDataValue(String name) {
        MetaUserDefinedElement definedElement = this.getUserDefinedElementByAttributeName(name);
        if (definedElement != null) {
            return definedElement.getTextContent();
        }
        return null;
    }

    public String getUserDefinedDataType(String name) {
        MetaUserDefinedElement definedElement = this.getUserDefinedElementByAttributeName(name);
        if (definedElement != null) {
            return definedElement.getMetaValueTypeAttribute();
        }
        return null;
    }

    public void removeUserDefinedDataByName(String name) {
        MetaUserDefinedElement definedElement = this.getUserDefinedElementByAttributeName(name);
        if (definedElement != null) {
            this.mOfficeMetaElement.removeChild((Node)((Object)definedElement));
        }
    }

    public void setUserDefinedDataValue(String name, String value) {
        MetaUserDefinedElement definedElement = this.getUserDefinedElementByAttributeName(name);
        if (definedElement != null) {
            definedElement.setTextContent(value);
        }
    }

    public void setUserDefinedDataType(String name, String value) {
        MetaUserDefinedElement definedElement = this.getUserDefinedElementByAttributeName(name);
        if (definedElement != null) {
            definedElement.setMetaValueTypeAttribute(value);
        }
    }

    public void setUserDefinedData(String name, String type, String value) {
        MetaUserDefinedElement definedElement = this.getUserDefinedElementByAttributeName(name);
        if (definedElement != null) {
            if (type != null) {
                definedElement.setMetaValueTypeAttribute(type);
            }
            if (value != null) {
                definedElement.setTextContent(value);
            }
        } else {
            definedElement = this.mOfficeMetaElement.newMetaUserDefinedElement(name, type);
            definedElement.setTextContent(value);
        }
    }

    public String getInitialCreator() {
        MetaInitialCreatorElement iniCreatorEle = OdfElement.findFirstChildNode(MetaInitialCreatorElement.class, (Node)((Object)this.mOfficeMetaElement));
        if (iniCreatorEle != null) {
            return iniCreatorEle.getTextContent();
        }
        return null;
    }

    public void setInitialCreator(String initialCreator) {
        MetaInitialCreatorElement iniCreatorEle = OdfElement.findFirstChildNode(MetaInitialCreatorElement.class, (Node)((Object)this.mOfficeMetaElement));
        if (iniCreatorEle == null) {
            iniCreatorEle = this.mOfficeMetaElement.newMetaInitialCreatorElement();
        }
        iniCreatorEle.setTextContent(initialCreator);
    }

    public String getCreator() {
        DcCreatorElement creatorEle = OdfElement.findFirstChildNode(DcCreatorElement.class, (Node)((Object)this.mOfficeMetaElement));
        if (creatorEle != null) {
            return creatorEle.getTextContent();
        }
        return null;
    }

    public void setCreator(String creator) {
        DcCreatorElement creatorEle = OdfElement.findFirstChildNode(DcCreatorElement.class, (Node)((Object)this.mOfficeMetaElement));
        if (creatorEle == null) {
            creatorEle = this.mOfficeMetaElement.newDcCreatorElement();
        }
        creatorEle.setTextContent(creator);
    }

    public String getPrintedBy() {
        MetaPrintedByElement printedByEle = OdfElement.findFirstChildNode(MetaPrintedByElement.class, (Node)((Object)this.mOfficeMetaElement));
        if (printedByEle != null) {
            return printedByEle.getTextContent();
        }
        return null;
    }

    public void setPrintedBy(String printedBy) {
        MetaPrintedByElement printedByEle = OdfElement.findFirstChildNode(MetaPrintedByElement.class, (Node)((Object)this.mOfficeMetaElement));
        if (printedByEle == null) {
            printedByEle = this.mOfficeMetaElement.newMetaPrintedByElement();
        }
        printedByEle.setTextContent(printedBy);
    }

    public Calendar getCreationDate() {
        MetaCreationDateElement creationDateEle = OdfElement.findFirstChildNode(MetaCreationDateElement.class, (Node)((Object)this.mOfficeMetaElement));
        if (creationDateEle != null) {
            return this.stringToCalendar(creationDateEle.getTextContent());
        }
        return null;
    }

    public void setCreationDate(Calendar creationDate) {
        MetaCreationDateElement creationDateEle = OdfElement.findFirstChildNode(MetaCreationDateElement.class, (Node)((Object)this.mOfficeMetaElement));
        if (creationDateEle == null) {
            creationDateEle = this.mOfficeMetaElement.newMetaCreationDateElement();
        }
        creationDateEle.setTextContent(this.calendarToString(creationDate));
    }

    public Calendar getDcdate() {
        DcDateElement dcDateEle = OdfElement.findFirstChildNode(DcDateElement.class, (Node)((Object)this.mOfficeMetaElement));
        if (dcDateEle != null) {
            return this.stringToCalendar(dcDateEle.getTextContent());
        }
        return null;
    }

    public void setDcdate(Calendar dcdate) {
        DcDateElement dcDateEle = OdfElement.findFirstChildNode(DcDateElement.class, (Node)((Object)this.mOfficeMetaElement));
        if (dcDateEle == null) {
            dcDateEle = this.mOfficeMetaElement.newDcDateElement();
        }
        dcDateEle.setTextContent(this.calendarToString(dcdate));
    }

    public Calendar getPrintDate() {
        MetaPrintDateElement printDateEle = OdfElement.findFirstChildNode(MetaPrintDateElement.class, (Node)((Object)this.mOfficeMetaElement));
        if (printDateEle != null) {
            return this.stringToCalendar(printDateEle.getTextContent());
        }
        return null;
    }

    public void setPrintDate(Calendar printDate) {
        MetaPrintDateElement printDateEle = OdfElement.findFirstChildNode(MetaPrintDateElement.class, (Node)((Object)this.mOfficeMetaElement));
        if (printDateEle == null) {
            printDateEle = this.mOfficeMetaElement.newMetaPrintDateElement();
        }
        printDateEle.setTextContent(this.calendarToString(printDate));
    }

    public String getLanguage() {
        DcLanguageElement languageEle = OdfElement.findFirstChildNode(DcLanguageElement.class, (Node)((Object)this.mOfficeMetaElement));
        if (languageEle != null) {
            return languageEle.getTextContent();
        }
        return null;
    }

    public void setLanguage(String language) {
        DcLanguageElement languageEle = OdfElement.findFirstChildNode(DcLanguageElement.class, (Node)((Object)this.mOfficeMetaElement));
        if (languageEle == null) {
            languageEle = this.mOfficeMetaElement.newDcLanguageElement();
        }
        languageEle.setTextContent(language);
    }

    public Integer getEditingCycles() {
        MetaEditingCyclesElement editingCyclesEle = OdfElement.findFirstChildNode(MetaEditingCyclesElement.class, (Node)((Object)this.mOfficeMetaElement));
        if (editingCyclesEle != null) {
            return Integer.valueOf(editingCyclesEle.getTextContent());
        }
        return null;
    }

    public void setEditingCycles(Integer editingCycles) {
        MetaEditingCyclesElement editingCyclesEle = OdfElement.findFirstChildNode(MetaEditingCyclesElement.class, (Node)((Object)this.mOfficeMetaElement));
        if (editingCyclesEle == null) {
            editingCyclesEle = this.mOfficeMetaElement.newMetaEditingCyclesElement();
        }
        editingCyclesEle.setTextContent(String.valueOf(editingCycles));
    }

    public Duration getEditingDuration() {
        MetaEditingDurationElement editiingDurationEle = OdfElement.findFirstChildNode(MetaEditingDurationElement.class, (Node)((Object)this.mOfficeMetaElement));
        if (editiingDurationEle != null) {
            return Duration.valueOf(editiingDurationEle.getTextContent());
        }
        return null;
    }

    public void setEditingDuration(Duration editingDuration) {
        MetaEditingDurationElement editiingDurationEle = OdfElement.findFirstChildNode(MetaEditingDurationElement.class, (Node)((Object)this.mOfficeMetaElement));
        if (editiingDurationEle == null) {
            editiingDurationEle = this.mOfficeMetaElement.newMetaEditingDurationElement();
        }
        editiingDurationEle.setTextContent(editingDuration.toString());
    }

    public OdfMetaDocumentStatistic getDocumentStatistic() {
        MetaDocumentStatisticElement element = this.getDocumentStatisticElement();
        if (element != null) {
            return new OdfMetaDocumentStatistic(element);
        }
        return null;
    }

    public OdfMetaHyperlinkBehaviour getHyperlinkBehaviour() {
        MetaHyperlinkBehaviourElement element = this.getHyperlinkBehaviourElement();
        if (element != null) {
            return new OdfMetaHyperlinkBehaviour(element);
        }
        return null;
    }

    public OdfMetaAutoReload getAutoReload() {
        MetaAutoReloadElement element = this.getAutoReloadElement();
        if (element != null) {
            return new OdfMetaAutoReload(element);
        }
        return null;
    }

    public OdfMetaTemplate getTemplate() {
        MetaTemplateElement element = this.getTemplateElement();
        if (element != null) {
            return new OdfMetaTemplate(element);
        }
        return null;
    }

    private MetaDocumentStatisticElement getDocumentStatisticElement() {
        return OdfElement.findFirstChildNode(MetaDocumentStatisticElement.class, (Node)((Object)this.mOfficeMetaElement));
    }

    private MetaHyperlinkBehaviourElement getHyperlinkBehaviourElement() {
        return OdfElement.findFirstChildNode(MetaHyperlinkBehaviourElement.class, (Node)((Object)this.mOfficeMetaElement));
    }

    private MetaAutoReloadElement getAutoReloadElement() {
        return OdfElement.findFirstChildNode(MetaAutoReloadElement.class, (Node)((Object)this.mOfficeMetaElement));
    }

    private MetaTemplateElement getTemplateElement() {
        return OdfElement.findFirstChildNode(MetaTemplateElement.class, (Node)((Object)this.mOfficeMetaElement));
    }

    private Calendar stringToCalendar(String baseDate) {
        Calendar calendar = Calendar.getInstance();
        Date d1 = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        try {
            d1 = sdf.parse(baseDate);
        }
        catch (Exception e) {
            // empty catch block
        }
        calendar.setTime(d1);
        return calendar;
    }

    private String calendarToString(Calendar calendar) {
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").format(calendar.getTime());
    }
}

