% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BVSelection.R
\name{BVSelection}
\alias{BVSelection}
\alias{BVSelection.BVCNonSparse}
\alias{BVSelection.BVCSparse}
\title{Variable selection for a BVCfit object}
\usage{
BVSelection(obj, ...)

\method{BVSelection}{BVCNonSparse}(obj, burn.in = obj$burn.in, prob = 0.95, ...)

\method{BVSelection}{BVCSparse}(obj, burn.in = obj$burn.in, ...)
}
\arguments{
\item{obj}{BVCfit object.}

\item{...}{other BVSelection arguments}

\item{burn.in}{MCMC burn-in.}

\item{prob}{probability for credible interval, between 0 and 1. e.g. prob=0.95 leads to 95\% credible interval}
}
\value{
an object of class "BVSelection" is returned, which is a list with components:
\itemize{
\item method: method used for identifying important effects
\item indices: a list of indices and names of selected variables
\item summary: a summary of selected variables
}
}
\description{
Variable selection for a BVCfit object
}
\details{
For class 'BVCSparse', the median probability model (MPM) (Barbieri and Berger 2004) is used to identify predictors that are significantly associated
with the response variable. For class 'BVCNonSparse', variable selection is based on 95\% credible interval.
Please check the references for more details about the variable selection.
}
\examples{
data(gExp)
## sparse
spbayes=BVCfit(X, Y, Z, E, clin)
spbayes

selected = BVSelection(spbayes)
selected$indices

## non-sparse
spbayes=BVCfit(X, Y, Z, E, clin, sparse=FALSE)
spbayes

selected = BVSelection(spbayes)
selected

}
\references{
Ren, J., Zhou, F., Li, X., Chen, Q., Zhang, H., Ma, S., Jiang, Y., Wu, C. (2020) Semiparametric Bayesian variable selection for gene-environment interactions.
{\emph{Statistics in Medicine}, 39(5): 617– 638} \doi{10.1002/sim.8434}

Barbieri, M.M. and Berger, J.O. (2004). Optimal predictive model selection
{\emph{Ann. Statist}, 32(3):870–897}
}
\seealso{
\code{\link{BVCfit}}
}
