% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_manual_tour.r
\name{create_manip_space}
\alias{create_manip_space}
\title{Create a manipulation space to rotate the manip variable in.}
\usage{
create_manip_space(basis, manip_var)
}
\arguments{
\item{basis}{A (p, d) orthonormal numeric matrix,
the linear combination the original variables contribute to projection frame.
Required, no default.}

\item{manip_var}{The number of the variable/column to rotate.}
}
\value{
A (p, d + 1) orthonormal matrix, the manipulation space to
manipulate the projection in.
}
\description{
Typically called by \code{manual_tour()}. Creates a (p, d) orthonormal matrix,
the manipulation space from the given basis right concatenated with a zero
vector, with manip_var set to 1.
}
\examples{
flea_std <- tourr::rescale(tourr::flea[,1:6])

rb <- tourr::basis_random(n = ncol(flea_std))
create_manip_space(basis = rb, manip_var = 4)
}
