% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/9_data.r
\docType{data}
\name{PimaIndiansDiabetes_wide}
\alias{PimaIndiansDiabetes_wide}
\title{Pima Indians Diabetes Database}
\format{
Data frame with 392 observations of 9 variables:
8 numeric variables, and target factor diabetes.
}
\usage{
PimaIndiansDiabetes_wide
}
\description{
Formatted subset of \verb{mlbench's} \code{PimaIndiansDiabetes2} (not explicitly exported).
See \code{help(PimaIndiansDiabetes2, package = "mlbench")} for the original documentation.
}
\details{
The data set PimaIndiansDiabetes2 contains a corrected version of the
original data set. While the UCI repository index claims that there are no
missing values, closer inspection of the data shows several physical
impossibilities, e.g., blood pressure or body mass index of 0. In
PimaIndiansDiabetes2, all zero values of glucose, pressure, triceps, insulin
and mass have been set to NA, see also Wahba et al (1995) and Ripley (1996).

Data frame with 392 observations of 9 variables:
8 numeric variables, and target factor diabetes.
\itemize{
\item pregnant, Number of times pregnant
\item glucose, Plasma glucose concentration (glucose tolerance test)
\item pressure, Diastolic blood pressure (mm Hg)
\item triceps, Triceps skin fold thickness (mm)
\item insulin, 2-Hour serum insulin (mu U/ml)
\item mass, Body mass index (weight in kg/(height in m)\^2)
\item pedigree, Diabetes pedigree function
\item age, Age (years)
\item diabetes, Class variable (test for diabetes), either "pos" or "neg"
}

Reproducing this dataset:\preformatted{require("mlbench")
data(PimaIndiansDiabetes2)

d <- PimaIndiansDiabetes2
d <- d[complete.cases(d), ] ## Remove ~350 row-wise incomplete rows
PimaIndiansDiabetes_wide <- d
## save(PimaIndiansDiabetes_wide, file = "./data/PimaIndiansDiabetes_wide.rda")
}
}
\examples{
str(PimaIndiansDiabetes_wide)
\dontrun{
dat <- scale_sd(PimaIndiansDiabetes_wide[, 1:8])
clas <- PimaIndiansDiabetes_wide$diabetes
bas <- prcomp(dat)$rotation[, 1:2]
mvar <- which(abs(bas[, 1]) == max(abs(bas[, 1])))

play_manual_tour(basis = bas, data = dat, manip_var = mvar),
                 render_type = render_gganimate, color = clas, shape = clas)
}
}
\keyword{datasets}
