% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_functions.R
\name{add_functions}
\alias{add_functions}
\alias{add_arm}
\alias{add_intervention}
\alias{add_pr_outcome}
\alias{add_sec_outcome}
\alias{add_condition}
\alias{add_keyword}
\title{Add arms, interventions and outcomes to an existing xml document for upload
to clinicaltrials.gov}
\usage{
add_arm(ctxml, arm_label, arm_type, arm_desc)

add_intervention(ctxml, int_name, int_type, int_desc, arm_label)

add_pr_outcome(ctxml, name, time, description)

add_sec_outcome(ctxml, name, time, description)

add_condition(ctxml, condition)

add_keyword(ctxml, keyword)
}
\arguments{
\item{ctxml}{A xml document generated from the create_ctxml() function}

\item{arm_label}{Label assigned to arm of clinical trial. Arm means a
pre-specified group or subgroup of participant(s) in a clinical trial
assigned to receive specific intervention(s) (or no intervention).}

\item{arm_type}{Either Experimental, Active comparator, Placebo Comparator,
Sham Comparator, No Intervention, or Other.}

\item{arm_desc}{Description of the arm.}

\item{int_name}{Name of the intervention. For a drug, it is the generic name.}

\item{int_type}{Drug, Device, Biological/Vaccine, Procedure/Surgery,
Radiation, Behavioural, Genetic, Dietary Supplement, Combination Product,
Diagnostic Test, or Other.}

\item{int_desc}{Other details about the intervention not included in name.}

\item{name}{Name of outome measure.}

\item{time}{Time point(s) at which the measurement is assessed.}

\item{description}{Other details about the outcome measure not included in
the name}

\item{condition}{MeSH term for condition being studied in the trial, or
Focus of the Study}

\item{keyword}{Words or phrases that best describe the protocol. Keywords
help users find studies in the database.}
}
\value{
A xml document
}
\description{
These functions add arms, interventions, primary and secondary outcomes as
well as conditions and keywords to an xml document created using the
create_ctxml() function. Calls to these functions should not be assigned to
an object.
}
\details{
\itemize{
\item \code{add_arm()}: Adds an xml nodespace containing information about the arm
name, type and description to the xml document.
\item \code{add_intervention()}: Adds an xml nodespace containing information about
the intervention name, type, description and arm it is associated with to the
xml document.
\item \code{add_pr_outcome()}: Adds an xml nodespace containing information about the
outcome name, time frame for measurement and additional descriptive details
to the xml document.
\item \code{add_sec_outcome()}: Adds an xml nodespace containing information about the
outcome name, time frame for measurement and additional descriptive details
to the xml document.
\item \code{add_condition()}: Adds an xml nodespace containing a MeSH term for the
condition being studied in the trial, or Focus of the Study to the xml
document.
\item \code{add_keyword()}: Adds an xml nodespace containing a Words or phrases that
best describe the protocol. Keywords help users find studies in the database
to the xml document.
}
}
\examples{

args_ctxml <- list(
org_name = "UHNToronto",
org_study_id = "Foo trial 20190806",
brief_title = "Foo trial to test auto upload 20190806",
study_acronym = "N/A",
official_title = "Foo trial to test auto upload: A randomized trial new 20190806",
agency  = "Aaron Conway",
resp_party_type = "Sponsor-Investigator",
investigator_username = "aconway",
investigator_title ="Assistant Professor",
brief_summary = "Lay summary here",
start_date = "2019-10",
primary_compl =  "2020-12",
study_compl = "2020-12",
int_subtype = "Health Services Research",
phase = "N/A",
assignment = "Parallel",
allocation = "Randomized",
no_masking =  "False",
masked_subject = "True",
masked_caregiver = "True",
masked_investigator = "True",
masked_assessor = "True",
number_arms = 2,
sample_size = "40",
eligibility_criteria = "Inclusion Criteria
- Adults
Exclusion Criteria
- Children",
healthy_volunteers = "No",
genders_included = "Both",
gender_based = "No",
min_age = "1 years",
max_age = "N/A",
#Central contact
contact_first_name = "Aaron",
contact_last_name = "Conway",
contact_degrees = "PhD",
contact_phone = "649-728-8499",
contact_email = "aaron.conway@utoronto.ca",
#Overall official
official_first_name = "Aaron",
official_last_name ="Conway",
official_degrees = "PhD",
official_affiliation = "UHN",
official_role = "Study Principal Investigator",
#Sharing statements
ipd_sharing = "Yes",
ipd_description = "details",
ipd_protocol =  "True",
ipd_sap = "True",
ipd_icf = "True",
ipd_csr = "True",
ipd_code = "True",
ipd_time = "details",
ipd_criteria = "details",
ipd_url = "http://www.aaronconway.info"
)

ctxml <- do.call(create_ctxml, args_ctxml)


 add_arm(ctxml = ctxml, 
         arm_label = "Standard", 
         arm_type =  "Active Comparator", 
         arm_desc = "Manual upload to registry")

add_intervention(ctxml = ctxml, 
                 int_type =  "Device", 
                 int_name = "Registry entry",
                 int_desc = "The usual way to enter to the registry",
                 arm_label = "Standard")

add_pr_outcome(ctxml = ctxml,
               name = "correct upload",
               time = "As measured",
               description = "Insert description about the measure.")

add_sec_outcome(ctxml = ctxml,
                name = "time to upload",
                time = "As measured",
                description = "Insert description about the measure.")

add_condition(ctxml = ctxml,
              condition = "Cardiac")

add_keyword(ctxml = ctxml,
            keyword = "sedation")


}
