% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.R
\name{coef.spmodel}
\alias{coef.spmodel}
\alias{coef.splm}
\alias{coefficients.splm}
\alias{coef.spautor}
\alias{coefficients.spautor}
\title{Extract fitted model coefficients}
\usage{
\method{coef}{splm}(object, type = "fixed", ...)

\method{coefficients}{splm}(object, type = "fixed", ...)

\method{coef}{spautor}(object, type = "fixed", ...)

\method{coefficients}{spautor}(object, type = "fixed", ...)
}
\arguments{
\item{object}{A fitted model object from \code{\link[=splm]{splm()}} or \code{\link[=spautor]{spautor()}}.}

\item{type}{\code{"fixed"} for fixed effect coefficients, \code{"spcov"} for
spatial covariance parameter coefficients, or \code{"randcov"} for random effect
variance coefficients. Defaults to \code{"fixed"}. If \code{type = "spcov"}, the
coefficient vector is an \code{\link[=spcov_params]{spcov_params()}} object (which means that has class
matching the spatial covariance function used).}

\item{...}{Other arguments. Not used (needed for generic consistency).}
}
\value{
A named vector of coefficients.
}
\description{
coef extracts fitted model coefficients from \code{\link[=splm]{splm()}} or \code{\link[=spautor]{spautor()}}
fitted model objects. \code{coefficients} is an alias for it.
}
\examples{
spmod <- splm(z ~ water + tarp,
  data = caribou,
  spcov_type = "exponential", xcoord = x, ycoord = y
)
coef(spmod)
coefficients(spmod)
coef(spmod, type = "spcov")
}
