% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spcov_initial.R
\name{spcov_initial}
\alias{spcov_initial}
\title{Create a spatial covariance parameter initial object}
\usage{
spcov_initial(spcov_type, de, ie, range, extra, rotate, scale, known)
}
\arguments{
\item{spcov_type}{The spatial covariance function type. Available options include
\code{"exponential"}, \code{"spherical"}, \code{"gaussian"},
\code{"triangular"}, \code{"circular"}, \code{"cubic"},
\code{"pentaspherical"}, \code{"cosine"}, \code{"wave"},
\code{"jbessel"}, \code{"gravity"}, \code{"rquad"},
\code{"magnetic"}, \code{"matern"}, \code{"cauchy"}, \code{"pexponential"},
\code{"car"}, \code{"sar"}, and \code{"none"}.}

\item{de}{The spatially dependent (correlated) random error variance. Commonly referred to as
a partial sill.}

\item{ie}{The spatially independent (uncorrelated) random error variance. Commonly referred to as
a nugget.}

\item{range}{The correlation parameter.}

\item{extra}{An extra covariance parameter used when \code{spcov_type} is
\code{"matern"}, \code{"cauchy"}, \code{"pexponential"}, \code{"car"}, or
\code{"sar"}.}

\item{rotate}{Anisotropy rotation parameter (from 0 to \eqn{\pi} radians).
Not used if \code{spcov_type} is \code{"car"} or \code{"sar"}.}

\item{scale}{Anisotropy scale parameter (from 0 to 1).
Not used if \code{spcov_type} is \code{"car"} or \code{"sar"}.}

\item{known}{A character vector indicating which spatial covariance parameters are to be
assumed known. The value \code{"given"} is shorthand for assuming all
spatial covariance parameters given to \code{spcov_initial()} are assumed known.}
}
\value{
A list with two elements: \code{initial} and \code{is_known}.
\code{initial} is a named numeric vector indicating the spatial covariance parameters
with specified initial and/or known values. \code{is_known} is a named
numeric vector indicating whether the spatial covariance parameters in
\code{initial} are known or not. The class of the list
matches the value given to the \code{spcov_type} argument.
}
\description{
Create a spatial covariance parameter initial object that specifies
initial and/or known values to use while estimating spatial covariance parameters
with \code{\link[=splm]{splm()}}, \code{\link[=spglm]{spglm()}}, \code{\link[=spautor]{spautor()}}, or \code{\link[=spgautor]{spgautor()}}.
}
\details{
The \code{spcov_initial} list is later passed to \code{\link[=splm]{splm()}}, \code{\link[=spglm]{spglm()}}, \code{\link[=spautor]{spautor()}}, or \code{\link[=spgautor]{spgautor()}}.
\code{NA} values can be given for \code{ie}, \code{rotate}, and \code{scale}, which lets
these functions find initial values for parameters that are sometimes
otherwise assumed known (e.g., \code{rotate} and \code{scale} with \code{\link[=splm]{splm()}} and \code{\link[=spglm]{spglm()}}
and \code{ie} with \code{\link[=spautor]{spautor()}} and \code{\link[=spgautor]{spgautor()}}).
The spatial covariance functions can be generally expressed as
\eqn{de * R + ie * I}, where \eqn{de} is \code{de} above, \eqn{R}
is a matrix that controls the spatial dependence structure among observations,
\eqn{h}, \eqn{ie} is \code{ie} above, and \eqn{I} is and identity matrix.
Note that \eqn{de} and \eqn{ie} must be non-negative while \eqn{range}
must be positive, except when \code{spcov_type} is \code{car} or \code{sar},
in which case \eqn{range} must be between the reciprocal of the maximum
eigenvalue of \code{W} and the reciprocal of the minimum eigenvalue of
\code{W}. Parametric forms for \eqn{R} are given below, where \eqn{\eta = h / range}:
\itemize{
\item exponential: \eqn{exp(- \eta )}
\item spherical: \eqn{(1 - 1.5\eta + 0.5\eta^3) * I(h <= range)}
\item gaussian: \eqn{exp(- \eta^2 )}
\item triangular: \eqn{(1 - \eta) * I(h <= range)}
\item circular: \eqn{(1 - (2 / \pi) * (m * sqrt(1 - m^2) + sin^{-1}(m))) * I(h <= range), m = min(\eta, 1)}
\item cubic: \eqn{(1 - 7\eta^2 + 8.75\eta^3 - 3.5\eta^5 + 0.75\eta^7) * I(h <= range)}
\item pentaspherical: \eqn{(1 - 1.875\eta + 1.25\eta^3 - 0.375\eta^5) * I(h <= range)}
\item cosine: \eqn{cos(\eta)}
\item wave: \eqn{sin(\eta) / \eta * I(h > 0) + I(h = 0)}
\item jbessel: \eqn{Bj(h * range)}, Bj is Bessel-J function
\item gravity: \eqn{(1 + \eta^2)^{-0.5}}
\item rquad: \eqn{(1 + \eta^2)^{-1}}
\item magnetic: \eqn{(1 + \eta^2)^{-1.5}}
\item matern: \eqn{2^{1 - extra}/ \Gamma(extra) * \alpha^{extra} * Bk(\alpha, extra)}, \eqn{\alpha = (2extra * \eta)^{0.5}}, Bk is Bessel-K function wit  order \eqn{1/5 \le extra \le 5}
\item cauchy: \eqn{(1 + \eta^2)^{-extra}}, \eqn{extra > 0}
\item pexponential: \eqn{exp(h^{extra}/range)}, \eqn{0 < extra \le 2}
\item car: \eqn{(I - range * W)^{-1} * M}, weights matrix \eqn{W},
symmetry condition matrix \eqn{M}, observations with no neighbors
are given a unique variance
parameter called \eqn{extra}, \eqn{extra \ge 0}.
\item sar: \eqn{[(I - range * W)(I - range * W)^T]^{-1}},
weights matrix \eqn{W}, \eqn{^T} indicates matrix transpose,
observations with no neighbors are given a unique variance
parameter called \eqn{extra}, \eqn{extra \ge 0}.
\item none: \eqn{0}
}

All spatial covariance functions are valid in one spatial dimension. All
spatial covariance functions except \code{triangular} and \code{cosine} are
valid in two dimensions.

When the spatial covariance function is \code{car} or \code{sar}, \code{extra}
represents the variance parameter for the observations in \code{W} without
at least one neighbor (other than itself) -- these are called unconnected
observations. \code{extra} is only used if there is at least one unconnected
observation.
}
\examples{
# known de value 1 and initial range value 0.4
spcov_initial("exponential", de = 1, range = 0.4, known = c("de"))
# known ie value 0 and known range value 1
spcov_initial("gaussian", ie = 0, range = 1, known = c("given"))
# ie given NA
spcov_initial("car", ie = NA)
}
