% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/local.R
\name{PermutationGi}
\alias{PermutationGi}
\title{Permutation based Getis-Ord Gi or Gi* statistics for spatial hots pot analysis}
\usage{
PermutationGi(
  x,
  W,
  gstar = TRUE,
  n = 999,
  seed = 1,
  alternative = c("two.sided", "less", "greater"),
  p.adjust.method = "BH",
  return.permutation = FALSE,
  condition = 0
)
}
\arguments{
\item{x}{A numerical vector.}

\item{W}{A weight matrix across all observations, i.e inverse of a pairwise distance matrix.}

\item{gstar}{Whether to calculate the Gi* statistics, default is \code{TRUE}.}

\item{n}{The number of permutations to be conducted, set to 999 by default.}

\item{seed}{Random seed used. Default is 1.}

\item{alternative}{Alternative hypothesis used, default is \code{two.sided}.}

\item{p.adjust.method}{Method used for multiple comparisons correction, default is \code{BH}. See \code{\link[stats]{p.adjust}}.}

\item{return.permutation}{Return permutations. Default is \code{FALSE}.}

\item{condition}{Value under null hypothesis to compare with, default is 0.}
}
\value{
A list containing the following:
\itemize{
\item Gi, Gi or Gi* statistics.
\item p.val, permutation based p-value.
\item p.adj, adjusted p-values.
\item return.permutation, permutation used if returned.
\item params, parameters used to calculate local Moran's I.
}
}
\description{
Calculate permutation based p-value for Getis-Ord Gi or Gi* statistics.
}
\examples{
{
data.use <- quakes[1:100,]
W <- 1/as.matrix(dist(data.use[,1:2]))
diag(W) <- 0
res <- PermutationGi(data.use[,3], W)
}

}
\concept{local}
