% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantile_MC_sgdf.R
\name{quantile_MC_sgdf}
\alias{quantile_MC_sgdf}
\title{quantile() function for MC sample saved in a SpatialGridDataFrame}
\usage{
quantile_MC_sgdf(realizations, ...)
}
\arguments{
\item{realizations}{MC sample saved in SpatialGridDataFrame.}

\item{...}{additional parameters.}
}
\value{
SpatialGridDataFrame; quantiles of a MC sample
}
\description{
Calculates mean from MC realizations for each location in a map.
}
\examples{

set.seed(12345)
data(dem30m, dem30m_sd)
dem_crm <- makecrm(acf0 = 0.78, range = 321, model = "Exp")
demUM <- defineUM(uncertain = TRUE, distribution = "norm", 
                   distr_param = c(dem30m, dem30m_sd), crm = dem_crm)
\dontrun{
dem_sample <- genSample(UMobject = demUM, n = 50, samplemethod = "ugs",
                        nmax = 20, asList = FALSE)
dem_quantile <- quantile_MC_sgdf(dem_sample, probs = c(0.1, 0.9))
}

}
\author{
Kasia Sawicka
}
