% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_data.R
\name{prepare_data}
\alias{prepare_data}
\title{Prepare mouse-tracking trajectories for state-space modeling via Stan}
\usage{
prepare_data(
  X = NULL,
  preprocess = TRUE,
  N = 61,
  Z.formula = NULL,
  Z.contrast = "treatment",
  yT = "AUTO",
  yD = "AUTO"
)
}
\arguments{
\item{X}{(dataframe) a data frame of x-y trajectories and experimental design (see \code{Details})}

\item{preprocess}{(boolean) indicates whether x-y trajectories should be pre-processed (default \code{preprocess=TRUE})}

\item{N}{(integer) number of timesteps for trajectory normalization (default \code{N=61})}

\item{Z.formula}{(character) a formula of the contrasts for the model matrix Z (see \code{\link{model.matrix}})}

\item{Z.contrast}{(character) type of contrasts (default: treatment) for the model matrix Z (see \code{\link{model.matrix}})}

\item{yT}{(numeric) position in angles of the target. The default option yT="AUTO" will automatically determine the target position from the observed data}

\item{yD}{(numeric) position in angles of the distractor. The default option yD="AUTO" will automatically determine the target position from the observed data}
}
\value{
a list containing (i) the new dataframe of the pre-processed dataset (\code{X_processed}) and (ii) the needed data for \code{\link{run_ssm}}
}
\description{
Prepare mouse-tracking trajectories for state-space modeling via Stan
}
\details{
The function prepares the mouse-tracking trajectories to be modeled for the state-space analysis. It automatically processes trajectories according to time-normalization, translation, and atan2 conversion. 
Users can skip pre-processing by setting \code{preprocess=FALSE}.

The input dataframe \code{X} needs to be organized using the long format with information being organized as nested. In particular, \code{X} must contains the following variables:
\describe{
\item{sbj}{The ID number of participants}
\item{trial}{The ID number of trials}
\item{factors}{1,...,Q factors for the categorical variables of the design. They may have different levels.  }
\item{timestep}{The ID number of the recorded x-y trajectories}
\item{x}{The recorded x-trajectories associated to trials and experimental levels}
\item{y}{The recorded y-trajectories associated to trials and experimental levels}
}

See \code{\link{language}} and \code{\link{congruency}} as examples of datasets format required by \pkg{ssMousetrack} package.
}
\examples{

data(congruency)
dataout <- prepare_data(X = congruency,preprocess = TRUE,Z.formula = "~congruency*plausibility")
str(dataout)

}
