% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specc_cluster.R
\name{get_univarCox_result}
\alias{get_univarCox_result}
\title{Perform the univariate Cox proportional hazards regression analysis.}
\usage{
get_univarCox_result(DE_path_sur)
}
\arguments{
\item{DE_path_sur}{A matrix containing the activity values of all pathways in each sample, along with the survival time and survival status of the samples.Note that the column names of survival time and survival status must be "survival" and "event".}
}
\value{
A data frame containing the pathways' coefficient, HR, confidence interval, and survival related difference p-value .
}
\description{
The function `get_univarCox_result` is used to perform the univariate Cox proportional hazards regression analysis.
}
\examples{
#get path of the mutation annotation file.
data(cox_data)
#perform function `get_univarCox_result`.
res<-get_univarCox_result(cox_data)
}
