% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit-burrlioz.R
\name{ssd_fit_burrlioz}
\alias{ssd_fit_burrlioz}
\title{Fit Burrlioz Distributions}
\usage{
ssd_fit_burrlioz(
  data,
  left = "Conc",
  rescale = FALSE,
  control = list(),
  silent = FALSE
)
}
\arguments{
\item{data}{A data frame.}

\item{left}{A string of the column in data with the concentrations.}

\item{rescale}{A flag specifying whether to rescale concentration values by dividing by the geometric mean of the minimum and maximum positive finite values.}

\item{control}{A list of control parameters passed to \code{\link[stats:optim]{stats::optim()}}.}

\item{silent}{A flag indicating whether fits should fail silently.}
}
\value{
An object of class fitdists.
}
\description{
Fits 'burrIII3' distribution.
If shape1 parameter is at boundary returns 'lgumbel' (which is equivalent to inverse Weibull).
Else if shape2 parameter is at a boundary returns 'invpareto'.
Otherwise returns 'burrIII3'
}
\examples{
ssd_fit_burrlioz(ssddata::ccme_boron)
}
\seealso{
\code{\link[=ssd_fit_dists]{ssd_fit_dists()}}
}
