% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/config.R
\name{config}
\alias{config}
\alias{create_config}
\alias{get_config}
\alias{check_config}
\alias{write_config}
\title{Functions handling sship R package config}
\usage{
create_config(dir = ".")

write_config(config, dir = ".", filename = "_sship.yml")

get_config(dir = ".")

check_config(config)
}
\arguments{
\item{dir}{string providing path to configuration file}

\item{config}{list containing configuration}

\item{filename}{string defining config filename}
}
\value{
A status message or list of config
}
\description{
Functions handling sship R package config
}
\examples{
# Create a new config file from package default
create_config(dir = tempdir())

# Get config
config <- get_config(system.file("sship.yml", package = "sship"))

# Check if config is valid
check_config(config)

# Write config to file
write_config(config, dir = tempdir())
}
