% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/check.power.R
\name{check.power}
\alias{check.power}
\title{Average Power and True FDR Based on Voom and Limma Pipeline}
\usage{
check.power(arg, k, fdr, mu, disp, logfc)
}
\arguments{
\item{arg}{a list of global parameters to pass into the function, such as total number of genes,
proportion of non-differentially expressed genes and treatment groups. See Details for more information.}

\item{k}{number of iterations.}

\item{fdr}{the false discovery rate to be controlled.}

\item{mu}{a scalar of mean counts in control group from which to simulate.}

\item{disp}{a scalar of dispersion parameter from which to simulate.}

\item{logfc}{log fold change between treatment group and control group.}
}
\value{
\item{pow_bh_ave}{average power when controlling FDR by Benjamini
and Hochberg (1995) method.}

\item{fdr_bh_ave}{true false discovery rate when controlling FDR by Benjamini
and Hochberg (1995) method.}

\item{pow_bh_ave}{average power when controlling FDR by q-value procedure
(Storey et al., 2004).}

\item{fdr_bh_ave}{true false discovery rate when controlling FDR by q-value procedure
(Storey et al., 2004).}
}
\description{
For the voom and limma pipeline method, when we control false discovery rate by using both Benjamini
and Hochberg (1995) method and q-value procedure (Storey et al., 2004), \code{check.power} calculates
average power and true FDR for given sample size, user-specified proportions of non-differentially
expressed genes, number of iterations, FDR level to control,
mean counts in control group, dispersion, and log fold change.
}
\details{
\code{arg = list(nG, pi0, group)} where \code{nG} is the total number of genes, \code{pi0}
is the proportion of non-differentially expressed genes, and \code{group} is the treatment groups.
}
\examples{
library(edgeR)
library(qvalue)
arg = list(
  nG = 10000,
  pi0 = 0.8,
  group = rep(c(1, 2), each = 13)
)

k <- 2                                   ## number of simulations (defined by user)
fdr <- 0.05                              ## the false discovery rate to be controlled
mu <- 10                                 ## mean counts in control group for all genes
disp <- 0.1                              ## dispersion for all genes
logfc <- log(2)                          ## log fold change for up-regulated genes

check.power(arg, k, fdr, mu, disp, logfc)
}
\author{
Ran Bi \email{biran@iastate.edu}, Peng Liu \email{pliu@iastate.edu}
}
\references{
Benjamini, Y. and Hochberg, Y. (1995) Controlling the false discovery rate: a practical and
powerful approach to multiple testing. \emph{J. R. Stat. Soc. B}, 57, 289-300.

Storey, J. D., Taylor, J. E. and Siegmund, D. (2004) Strong control, conservative point estimation and
simultaneous rates: a unified approach. \emph{J. R. Stat. Soc. B}, 66, 187- 205.
}

