% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{ind_skewed_t_densities_Cpp}
\alias{ind_skewed_t_densities_Cpp}
\title{Calculate log independent multivariate skewed t densities}
\usage{
ind_skewed_t_densities_Cpp(
  obs,
  means,
  impact_matrices,
  alpha_mt,
  all_nu,
  all_lambda,
  minval,
  posdef_tol
)
}
\arguments{
\item{obs}{a \eqn{(T \times d)} matrix such that the \eqn{i}th row contains the vector
\eqn{y_{i}=(y_{1i},...,y_{di})} \eqn{(dx1)}. That is, the initial values are
excluded but the last observations is included.}

\item{means}{a \eqn{(T \times d)} matrix such that the \eqn{i}th row contains the
conditional mean of the process \eqn{\mu_{y,i}}.}

\item{impact_matrices}{a size \eqn{d\times d \times M} \code{arma::cube} (3D array in R), where each slice contains an
invertible (d x d) impact matrix of each regime.}

\item{alpha_mt}{a \eqn{(T \times M)} matrix such that \code{[t, m]} contains the time t
transition weights of the \eqn{m}th regime.}

\item{all_nu}{a numeric vector of length \eqn{d}, containing the degrees of freedom parameters for each component.}

\item{all_lambda}{a numeric vector of length \eqn{d}, containing the skewness parameters for each component.}

\item{minval}{the value that will be returned if the parameter vector does not lie in the parameter space
(excluding the identification condition).}

\item{posdef_tol}{numerical tolerance for positive definiteness of the error term covariance matrices: if
the error term covariance matrix of any regime has eigenvalues smaller than this, the parameter is considered
to be outside the parameter space. Note that if the tolerance is too small, numerical evaluation of the
log-likelihood might fail and cause error.}
}
\value{
A numeric vector of length \eqn{T}, where each element represents the computed density component for
 the corresponding observation.
}
\description{
Calculates logs of independent multivariate skewed t densities with varying mean
  and impact matrix (including the constant terms of the density). The varying impact matrix
  is calculated within the function from the impact matrices of the regimes and transition weights.
}
\details{
Returns \code{minval} if the impact matrix \eqn{B_t} is not invertible for some t up to the numerical tolerance
 \code{posdef_tol}.
}
\keyword{internal}
