% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stab_dist.R
\name{stab_dist}
\alias{stab_dist}
\alias{stab_dist.default}
\title{Stability Distance in AMMI}
\usage{
stab_dist(.data, .y, .rep, .gen, .env, .m = 2)

\method{stab_dist}{default}(.data, .y, .rep, .gen, .env, .m = 2)
}
\arguments{
\item{.data}{data.frame}

\item{.y}{Response Variable}

\item{.rep}{Replication Factor}

\item{.gen}{Genotypes Factor}

\item{.env}{Environment Factor}

\item{.m}{No of PCs retained}
}
\value{
Stability Distance
}
\description{
Stability Distance of Genotypes in Additive ANOVA for Genotypes by Environment Interaction (GEI) model
}
\examples{
data(ge_data)
YieldDist <-
     stab_dist(
            .data = ge_data
          , .y    = Yield
          , .rep  = Rep
          , .gen  = Gen
          , .env  = Env
          , .m    = 2
      )
YieldDist

}
\author{
\enumerate{
         \item Muhammad Yaseen (\email{myaseen208@gmail.com})
         \item Kent M. Edkridge (\email{keskridge1@unl.edu})
         }
}
