require(stacomiR)

stacomi(gr_interface=FALSE,
	login_window=FALSE,
	database_expected=FALSE)

\dontrun{
  r_mig_char<-new("report_mig_char")
  baseODBC<-get("baseODBC",envir=envir_stacomi)
  baseODBC[c(2,3)]<-rep("logrami",2)
  assign("baseODBC",baseODBC,envir_stacomi)
  sch<-get("sch",envir=envir_stacomi)
  assign("sch","logrami.",envir_stacomi)
  # here parqual is not in the list
  # so this is equivalent to parqual=NULL
  # default for echantillon is "with"
  r_mig_char<-choice_c(r_mig_char,
	  dc=c(107,108,101),
	  taxa=c("Salmo salar"),
	  stage=c('5','11','BEC','BER','IND'),
	  parquan=c('A124','C001','1786','1785'),
	  horodatedebut="2012-01-01",
	  horodatefin="2012-12-31",
	  silent=FALSE)
  # r_mig_char<-charge(r_mig_char) not necessary there
  r_mig_char<-connect(r_mig_char)
  
}	
# load the dataset generated by previous lines
data("r_mig_char")
# age will be plotted as a qualitative variable
r_mig_char<-setasqualitative(r_mig_char,par='A124',
    breaks=c(0,1.5,2.5,10),
    label=c("age 1","age 2","age 3"))
r_mig_char<-calcule(r_mig_char,silent=TRUE)
plot(r_mig_char,plot.type="quant",silent=TRUE)
# one quantitative parameter found, manual choice of color
plot(r_mig_char,plot.type="quant",color_parm=c("C001"="red"),silent=TRUE)
plot(r_mig_char,plot.type="qual",silent=TRUE)
plot(r_mig_char,plot.type="crossed")
plot(r_mig_char,plot.type="crossed",
    color_parm=c("age 1"="#379ec6","age 2"="#173957","age 3"="#b09953"))
xt<-xtable(r_mig_char)
# use method print.xtable to get the output
\dontrun{
# An example with several years
  r_mig_char<-new("report_mig_char")
  baseODBC<-get("baseODBC",envir=envir_stacomi)
  baseODBC[c(2,3)]<-rep("logrami",2)
  assign("baseODBC",baseODBC,envir_stacomi)
  sch<-get("sch",envir=envir_stacomi)
  assign("sch","logrami.",envir_stacomi)
# here parqual is not in the list
# so this is equivalent to parqual=NULL
  r_mig_char<-choice_c(r_mig_char,
	  dc=c(107,108,101),
	  taxa=c("Salmo salar"),
	  stage=c('5','11','BEC','BER','IND'),
	  parquan=c('A124','C001','1786','1785'),
	  horodatedebut="2009-01-01",
	  horodatefin="2012-12-31",
	  #echantillon="with", # alternative "without"
	  silent=FALSE)
# r_mig_char<-charge(r_mig_char) not necessary there
  r_mig_char<-connect(r_mig_char)
# load the dataset generated by previous lines
  r_mig_char<-setasqualitative(r_mig_char,par='A124',
      breaks=c(0,1.5,2.5,10),
      label=c("age 1","age 2","age 3"))
  r_mig_char<-calcule(r_mig_char,silent=TRUE)
  
}

