% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_mig.R
\docType{methods}
\name{write_database,report_mig-method}
\alias{write_database,report_mig-method}
\alias{write_database.report_mig}
\title{Command line method to write the daily and monthly counts to the 
t_bilanmigrationjournalier_bjo table}
\usage{
\S4method{write_database}{report_mig}(object, silent = TRUE,
  check_for_bjo = TRUE)
}
\arguments{
\item{object}{an object of class \code{\linkS4class{report_mig}}}

\item{silent}{: TRUE to avoid messages}

\item{check_for_bjo}{: do you want to check if data are already present in the bjo table, and delete them,
this param was added otherwise connect method when called from report_mig_interannual runs in loops}
}
\description{
Daily values are needed to compare migrations from year to year, by the class \link{report_mig_interannual-class}. They are added by
by this function.
}
\note{
the user is asked whether or not he wants to overwrite data, if no
data are present in the database, the import is done anyway. The name of the database
is retrieved from the odbc link
}
\examples{
\dontrun{
stacomi(gr_interface=FALSE,login_window=FALSE,database_expected=FALSE) 
data("r_mig")
r_mig<-calcule(r_mig)
write_database(report_mig=r_mig,silent=FALSE)
}
}
\author{
Cedric Briand \email{cedric.briand"at"eptb-vilaine.fr}
}

