% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stars.R
\name{read_stars}
\alias{read_stars}
\title{read raster/array dataset from file or connection}
\usage{
read_stars(.x, ..., options = character(0), driver = character(0),
  sub = TRUE, quiet = FALSE, NA_value = NA_real_, along = NA)
}
\arguments{
\item{.x}{if character, name of file(s) to read; if list: list with arrays}

\item{...}{ignored}

\item{options}{character; opening options}

\item{driver}{character; driver to use for opening file}

\item{sub}{integer or logical; sub-datasets to be read}

\item{quiet}{logical; print progress output?}

\item{NA_value}{numeric value to be used for conversion into NA values; by default this is read from the input file}

\item{along}{character or integer; in case \code{.x} contains multiple files, along which dimension should objects be merged? \code{NA} will merge arrays as new attributes if all objects have identical dimensions, or else try to merge along time if time stamps differ. A positive value (or name) will merge along that dimension, or create a new dimension.}
}
\value{
object of class \code{stars}
}
\description{
read raster/array dataset from file or connection
}
\examples{
tif = system.file("tif/L7_ETMs.tif", package = "stars")
(x1 = read_stars(tif))
(x2 = read_stars(c(tif, tif)))
(x3 = read_stars(c(tif, tif), along = "band"))
(x4 = read_stars(c(tif, tif), along = "new_dimensions")) # create 4-dimensional array
x1o = read_stars(tif, options = "OVERVIEW_LEVEL=1")
}
