% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimensions.R
\name{st_dimensions}
\alias{st_dimensions}
\alias{st_dimensions.stars}
\alias{st_dimensions<-}
\alias{st_dimensions<-.stars}
\alias{st_dimensions<-.list}
\alias{st_dimensions.array}
\alias{st_dimensions.default}
\alias{st_set_dimensions}
\alias{st_get_dimension_values}
\title{get dimensions from stars object}
\usage{
st_dimensions(.x, ...)

\method{st_dimensions}{stars}(.x, ...)

st_dimensions(x) <- value

\method{st_dimensions}{stars}(x) <- value

\method{st_dimensions}{list}(x) <- value

\method{st_dimensions}{array}(.x, ...)

\method{st_dimensions}{default}(
  .x,
  ...,
  .raster,
  affine = c(0, 0),
  cell_midpoints = FALSE,
  point = FALSE
)

st_set_dimensions(
  .x,
  which,
  values = NULL,
  point = NULL,
  names = NULL,
  xy,
  ...
)

st_get_dimension_values(.x, which, ..., where = NA, max = FALSE, center = NA)
}
\arguments{
\item{.x}{object to retrieve dimensions information from}

\item{...}{further arguments}

\item{x}{object of class \code{dimensions}}

\item{value}{new object of class \code{dimensions}, with matching dimensions}

\item{.raster}{length 2 character array with names (if any) of the raster dimensions}

\item{affine}{numeric; specify parameters of the affine transformation}

\item{cell_midpoints}{logical; if \code{TRUE} AND the dimension values are strictly regular, the values are interpreted as the cell midpoint values rather than the cell offset values when calculating offset (i.e., the half-cell-size correction is applied); can have a value for each dimension, or else is recycled}

\item{point}{logical; does the pixel value (measure) refer to a point (location) value or to an pixel (area) summary value?}

\item{which}{integer or character; index or name of the dimension to be changed}

\item{values}{values for this dimension (e.g. \code{sfc} list-column), or length-1 \code{dimensions} object}

\item{names}{character; vector with new names for all dimensions, or with the single new name for the dimension indicated by \code{which}}

\item{xy}{length-2 character vector; (new) names for the \code{x} and \code{y} raster dimensions}

\item{where}{character, one of 'start', 'center' or 'end'. Set to NA (default) to ignore and use \code{max} and \code{center} explictly.  This argument provides a convenient alternative to setting \code{max} and \code{center}.}

\item{max}{logical; if \code{TRUE} return the end, rather than the beginning of an interval}

\item{center}{logical; if \code{TRUE} return the center of an interval; if \code{NA} return the center for raster dimensions, and the start of intervals in other cases}
}
\value{
the \code{dimensions} attribute of \code{x}, of class \code{dimensions}
}
\description{
get dimensions from stars object
}
\details{
dimensions can be specified in two ways. The simplest is to pass a vector with numeric values for a numeric dimension, or character values for a categorical dimension. Parameter \code{cell_midpoints} is used to specify whether numeric values refer to the offset (start) of a dimension interval (default), or to the center; the center case is only available for regular dimensions. For rectilinear numeric dimensions, one can specify either a vector with cell borders (start values), or a data.frame with two columns named "start" and "end", with the respective interval start and end values. In the first case, the end values are computed from the start values by assuming the last two intervals have equal width.
}
\examples{
x = read_stars(system.file("tif/L7_ETMs.tif", package = "stars"))
# Landsat 7 ETM+ band semantics: https://landsat.gsfc.nasa.gov/the-enhanced-thematic-mapper-plus/
# set bands to values 1,2,3,4,5,7:
(x1 = st_set_dimensions(x, "band", values = c(1,2,3,4,5,7), names = "band_number", point = TRUE))
# set band values as bandwidth
rbind(c(0.45,0.515), c(0.525,0.605), c(0.63,0.69), c(0.775,0.90), c(1.55,1.75), c(2.08,2.35)) \%>\%
  units::set_units("um") -> bw # or: units::set_units(µm) -> bw
# set bandwidth midpoint:
(x2 = st_set_dimensions(x, "band", values = 0.5 * (bw[,1]+bw[,2]), 
   names = "bandwidth_midpoint", point = TRUE))
# set bandwidth intervals:
(x3 = st_set_dimensions(x, "band", values = make_intervals(bw), names = "bandwidth"))
m = matrix(1:20, nrow = 5, ncol = 4)
dim(m) = c(x = 5, y = 4) # named dim
(s = st_as_stars(m))
st_get_dimension_values(s, 'x', where = "start")
st_get_dimension_values(s, 'x', center = FALSE)
st_get_dimension_values(s, 'x', where = "center")
st_get_dimension_values(s, 'x', center = TRUE)
st_get_dimension_values(s, 'x', where = "end")
st_get_dimension_values(s, 'x', max = TRUE)
}
