% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/renviron_d.R, R/rprofile_d.R, R/startup.R
\name{renviron_d}
\alias{renviron_d}
\alias{renviron}
\alias{rprofile_d}
\alias{rprofile}
\alias{startup}
\title{Load .Renviron.d and .Rprofile.d directories during the R startup process}
\usage{
renviron_d(
  sibling = FALSE,
  all = FALSE,
  unload = FALSE,
  skip = NA,
  dryrun = NA,
  debug = NA,
  paths = NULL
)

rprofile_d(
  sibling = FALSE,
  all = FALSE,
  check = NA,
  unload = FALSE,
  skip = NA,
  on_error = c("error", "warning", "immediate.warning", "message", "ignore"),
  dryrun = NA,
  debug = NA,
  paths = NULL
)

startup(
  sibling = FALSE,
  all = FALSE,
  on_error = c("error", "warning", "immediate.warning", "message", "ignore"),
  keep = c("options"),
  check = NA,
  unload = TRUE,
  skip = NA,
  dryrun = NA,
  debug = dryrun
)
}
\arguments{
\item{sibling}{If \code{TRUE}, then only \file{.Renviron.d/} and
\file{.Rprofile.d/} directories with a sibling \file{.Renviron} and
\file{.Rprofile} in the same location will be considered.}

\item{all}{If \code{TRUE}, then \emph{all} \file{.Renviron.d/} and \file{.Rprofile.d/}
directories found on \link[base:Startup]{the R startup search path} are
processed, otherwise only the \emph{first ones} found.}

\item{unload}{If \code{TRUE}, then the package is unloaded afterward, otherwise
not.}

\item{skip}{If \code{TRUE}, startup directories will be skipped.  If \code{NA}, they
will be skipped if command-line options \code{--vanilla}, \code{--no-init-file},
and / or \code{--no-environ} were specified.}

\item{dryrun}{If \code{TRUE}, everything is done except the processing of the
startup files.}

\item{debug}{If \code{TRUE}, debug messages are outputted, otherwise not.}

\item{paths}{(internal) character vector of directories.}

\item{check}{If \code{TRUE}, then the content of startup files are validated.}

\item{on_error}{Action taken when an error is detected when sourcing an
Rprofile file.  It is not possible to detect error in Renviron files;
they are always ignored with a message that cannot be captured.}

\item{keep}{Specify what information should remain after this function
complete.  The default is to keep \verb{startup.session.*} options
as recorded by \code{\link[=startup_session_options]{startup_session_options()}}.}
}
\description{
Initiates \R using all files under \file{.Renviron.d/} and / or
\file{.Rprofile.d/} directories (or in subdirectories thereof).
}
\details{
The above is done in addition the \file{.Renviron} and \file{.Rprofile}
files that are supported by the built-in \link[base:Startup]{startup process}
of \R.
}
\section{Functions}{
\itemize{
\item \code{renviron_d()}: Initiate using \file{.Renviron.d/} files

\item \code{rprofile_d()}: Initiate using \file{.Rprofile.d/} files

\item \code{startup()}: \code{renviron_d()} followed by \code{rprofile_d()} and then the
package is unloaded

}}
\section{User-specific installation}{

In order for \file{.Rprofile.d} and \file{.Renviron.d} directories to be
included during the \R startup process, a user needs to add
\code{startup::startup()} to \file{~/.Rprofile}.  Adding this can also be done
by calling \code{\link[=install]{install()}} once.
}

\section{Site-wide installation}{

An alternative to having each user add \code{startup::startup()} in their own
\file{~/.Rprofile} file, is to add it to the site-wide \file{Rprofile.site}
file (see \link[base:Startup]{?Startup}).
The advantage of such a site-wide installation, is that the users do not
have to have a \file{.Rprofile} file for \file{.Rprofile.d} and
\file{.Renviron.d} directories to work.
For this to work for all users automatically, the \pkg{startup} package
should also be installed in the site-wide library.
}

\examples{
\dontrun{
# The most common way to use the package is to add
# the following call to the ~/.Rprofile file.
startup::startup()

# To process ~/.Renviron.d/ files, and then any ./.Renviron.d/ files,
# followed by  ~/.Rprofile.d/ files, and then any ./.Rprofile.d/ files,
# add the following call to the ~/.Rprofile file.
startup::startup(all = TRUE)

# For finer control of on exactly what files are used
# functions renviron_d() and rprofile_d() are also available:

# Initiate first .Renviron.d/ found on search path
startup::renviron_d()

# Initiate all .Rprofile.d/ directories found on the startup search path
startup::rprofile_d(all = TRUE)
}

}
