% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HDR.R, R/extraDistr.R, R/invgamma.R, R/vgam.R
\name{HDR}
\alias{HDR}
\alias{HDR.norm}
\alias{HDR.lnorm}
\alias{HDR.t}
\alias{HDR.cauchy}
\alias{HDR.f}
\alias{HDR.beta}
\alias{HDR.chisq}
\alias{HDR.gamma}
\alias{HDR.weibull}
\alias{HDR.exp}
\alias{HDR.unif}
\alias{HDR.hyper}
\alias{HDR.geom}
\alias{HDR.binom}
\alias{HDR.pois}
\alias{HDR.nbinom}
\alias{HDR.arcsine}
\alias{HDR.betapr}
\alias{HDR.fatigue}
\alias{HDR.gompertz}
\alias{HDR.gpd}
\alias{HDR.huber}
\alias{HDR.kumar}
\alias{HDR.tnorm}
\alias{HDR.invchisq}
\alias{HDR.invexp}
\alias{HDR.invgamma}
\alias{HDR.benini}
\alias{HDR.frechet}
\alias{HDR.gengamma}
\alias{HDR.gumbelII}
\alias{HDR.lgamma}
\title{Highest density region (HDR)}
\usage{
HDR.norm(
  cover.prob,
  mean = 0,
  sd = 1,
  gradtol = 1e-10,
  steptol = 1e-10,
  iterlim = 100
)

HDR.lnorm(
  cover.prob,
  meanlog = 0,
  sdlog = 1,
  gradtol = 1e-10,
  steptol = 1e-10,
  iterlim = 100
)

HDR.t(cover.prob, df, ncp = 0, gradtol = 1e-10, steptol = 1e-10, iterlim = 100)

HDR.cauchy(
  cover.prob,
  location = 0,
  scale = 1,
  gradtol = 1e-10,
  steptol = 1e-10,
  iterlim = 100
)

HDR.f(
  cover.prob,
  df1,
  df2,
  ncp = 0,
  gradtol = 1e-10,
  steptol = 1e-10,
  iterlim = 100
)

HDR.beta(
  cover.prob,
  shape1,
  shape2,
  ncp = 0,
  gradtol = 1e-10,
  steptol = 1e-10,
  iterlim = 100
)

HDR.chisq(
  cover.prob,
  df,
  ncp = 0,
  gradtol = 1e-10,
  steptol = 1e-10,
  iterlim = 100
)

HDR.gamma(
  cover.prob,
  shape,
  rate = 1,
  scale = 1/rate,
  gradtol = 1e-10,
  steptol = 1e-10,
  iterlim = 100
)

HDR.weibull(
  cover.prob,
  shape,
  scale = 1,
  gradtol = 1e-10,
  steptol = 1e-10,
  iterlim = 100
)

HDR.exp(cover.prob, rate, gradtol = 1e-10, steptol = 1e-10, iterlim = 100)

HDR.unif(
  cover.prob,
  min = 0,
  max = 1,
  gradtol = 1e-10,
  steptol = 1e-10,
  iterlim = 100
)

HDR.hyper(cover.prob, m, n, k, gradtol = 1e-10, steptol = 1e-10, iterlim = 100)

HDR.geom(cover.prob, prob, gradtol = 1e-10, steptol = 1e-10, iterlim = 100)

HDR.binom(
  cover.prob,
  size,
  prob,
  gradtol = 1e-10,
  steptol = 1e-10,
  iterlim = 100
)

HDR.pois(cover.prob, lambda, gradtol = 1e-10, steptol = 1e-10, iterlim = 100)

HDR.nbinom(
  cover.prob,
  size,
  prob,
  mu,
  gradtol = 1e-10,
  steptol = 1e-10,
  iterlim = 100
)

HDR.arcsine(
  cover.prob,
  min = 0,
  max = 1,
  gradtol = 1e-10,
  steptol = 1e-10,
  iterlim = 100
)

HDR.betapr(
  cover.prob,
  shape1,
  shape2,
  scale = 1,
  gradtol = 1e-10,
  steptol = 1e-10,
  iterlim = 100
)

HDR.fatigue(
  cover.prob,
  alpha,
  beta = 1,
  mu = 0,
  gradtol = 1e-10,
  steptol = 1e-10,
  iterlim = 100
)

HDR.gompertz(
  cover.prob,
  shape = 1,
  scale = 1,
  gradtol = 1e-10,
  steptol = 1e-10,
  iterlim = 100
)

HDR.gpd(
  cover.prob,
  mu = 0,
  sigma = 1,
  xi = 0,
  location = mu,
  scale = sigma,
  shape = xi,
  gradtol = 1e-10,
  steptol = 1e-10,
  iterlim = 100
)

HDR.huber(
  cover.prob,
  mu,
  sigma,
  epsilon,
  gradtol = 1e-10,
  steptol = 1e-10,
  iterlim = 100
)

HDR.kumar(
  cover.prob,
  a = 1,
  b = 1,
  shape1 = a,
  shape2 = b,
  gradtol = 1e-10,
  steptol = 1e-10,
  iterlim = 100
)

HDR.tnorm(
  cover.prob,
  mean = 0,
  sd = 1,
  a = -Inf,
  b = Inf,
  min = a,
  max = b,
  gradtol = 1e-10,
  steptol = 1e-10,
  iterlim = 100
)

HDR.invchisq(
  cover.prob,
  df,
  ncp = 0,
  gradtol = 1e-10,
  steptol = 1e-10,
  iterlim = 100
)

HDR.invexp(
  cover.prob,
  rate = 1,
  gradtol = 1e-10,
  steptol = 1e-10,
  iterlim = 100
)

HDR.invgamma(
  cover.prob,
  shape,
  rate = 1,
  scale = 1/rate,
  gradtol = 1e-10,
  steptol = 1e-10,
  iterlim = 100
)

HDR.benini(
  cover.prob,
  shape,
  y0,
  scale = y0,
  gradtol = 1e-10,
  steptol = 1e-10,
  iterlim = 100
)

HDR.frechet(
  cover.prob,
  shape,
  scale = 1,
  location = 0,
  gradtol = 1e-10,
  steptol = 1e-10,
  iterlim = 100
)

HDR.gengamma(
  cover.prob,
  d,
  k,
  shape1 = d,
  shape2 = k,
  rate = 1,
  scale = 1/rate,
  gradtol = 1e-10,
  steptol = 1e-10,
  iterlim = 100
)

HDR.gumbelII(
  cover.prob,
  shape,
  scale = 1,
  gradtol = 1e-10,
  steptol = 1e-10,
  iterlim = 100
)

HDR.lgamma(
  cover.prob,
  shape = 1,
  scale = 1,
  location = 0,
  gradtol = 1e-10,
  steptol = 1e-10,
  iterlim = 100
)
}
\arguments{
\item{cover.prob}{The probability coverage for the HDR (scalar between zero and one).  The significance level for the HDR i is \code{1-cover.prob}.}

\item{gradtol}{Parameter for the nlm optimisation - a positive scalar giving the tolerance at which the scaled gradient is considered close enough to zero to terminate the algorithm (see [\code{nlm} doccumentation](https://stat.ethz.ch/R-manual/R-patched/library/stats/html/nlm.html)).}

\item{steptol}{Parameter for the nlm optimisation - a positive scalar providing the minimum allowable relative step length (see [\code{nlm} doccumentation](https://stat.ethz.ch/R-manual/R-patched/library/stats/html/nlm.html)).}

\item{iterlim}{Parameter for the nlm optimisation - a positive integer specifying the maximum number of iterations to be performed before the program is terminated (see [\code{nlm} doccumentation](https://stat.ethz.ch/R-manual/R-patched/library/stats/html/nlm.html)).}

\item{shape1, shape2, ncp, location, scale, df, rate, df1, df2, meanlog, sdlog, mean, sd, min, max, shape, size, prob, m, n, k, mu, lambda, alpha, beta, sigma, xi, epsilon, a, b, y0, d}{Distribution parameters.}
}
\value{
An interval object with classes \code{hdr} and \code{interval} containing the highest density region and related information.
}
\description{
\code{HDR.xxxx} returns the highest density region (HDR) for a chosen distribution.
}
\details{
This function computes the highest density region (HDR) for a univariate distribution in the \code{stats} package.  The functions for
the HDR for different distributions are named in the form \code{HDR.xxxx} where the \code{xxxx} refers to the distribution
(e.g., \code{HDR.chisq}, \code{HDR.gamma}, \code{HDR.norm}, etc.).  The user can use any univariate distribution in the \code{stats} package,
and the function accepts parameters from the specified distribution (see table below).  The output of the function is an interval of classes
\code{hdr} and \code{interval} giving the highest density region and some related information pertaining to the distribution and the
computation of the HDR (for information on intervals, see the \code{sets} package). If the input distribution is continuous then the
HDR is a real interval, and if the input distribution discrete then the HDR is a discrete interval.  For non-trivial cases the computation
is done by optimisation using the \code{nlm} function.

\tabular{lccc}{
  Using \code{stats} \tab Continuous    \tab        \tab       \cr
  HDR.arcsine \tab min      \tab max    \tab       \cr
  HDR.beta    \tab shape1   \tab shape2 \tab ncp   \cr
  HDR.cauchy  \tab location \tab scale  \tab       \cr
  HDR.chisq   \tab df       \tab ncp    \tab       \cr
  HDR.exp     \tab rate     \tab        \tab       \cr
  HDR.f       \tab df1      \tab df2    \tab ncp   \cr
  HDR.gamma   \tab shape    \tab rate   \tab scale \cr
  HDR.lnorm   \tab meanlog  \tab sdlog  \tab       \cr
  HDR.norm    \tab mean     \tab sd     \tab       \cr
  HDR.t       \tab df       \tab ncp    \tab       \cr
  HDR.unif    \tab min      \tab max    \tab       \cr
  HDR.weibull \tab shape    \tab scale  \tab       \cr
   \tab     \tab   \tab       \cr
  Using \code{stats} \tab Discrete      \tab        \tab       \cr
  HDR.binom   \tab size     \tab prob   \tab       \cr
  HDR.geom    \tab prob     \tab        \tab       \cr
  HDR.hyper   \tab m        \tab n      \tab k     \cr
  HDR.nbinom  \tab size     \tab prob   \tab mu    \cr
  HDR.pois    \tab lambda   \tab        \tab       \cr 
   \tab     \tab   \tab       \cr
  Using \code{extraDistr} \tab \tab     \tab       \cr
  HDR.betapr  \tab shape1   \tab shape2 \tab scale \cr
  HDR.fatigue \tab alpha    \tab beta   \tab mu    \cr
  HDR.gompertz\tab shape    \tab scale  \tab       \cr
  HDR.gpd     \tab mu,location\tab sigma, scale\tab shape, xi\cr
  HDR.huber   \tab mu       \tab sigma  \tab epsilon \cr
  HDR.kumar   \tab a,shape1 \tab b,shape2 \tab     \cr
  HDR.tnorm   \tab mean     \tab sd     \tab a, b, min, max \cr
   \tab     \tab   \tab       \cr
  Using \code{invgamma} \tab \tab       \tab       \cr
  HDR.invchisq\tab df       \tab ncp    \tab       \cr
  HDR.invexp  \tab rate     \tab        \tab       \cr
  HDR.invgamma\tab shape    \tab rate   \tab scale \cr
   \tab     \tab   \tab       \cr
  Using \code{VGAM} \tab    \tab        \tab       \cr
  HDR.benini  \tab shape    \tab y0     \tab scale \cr
  HDR.frechet \tab shape    \tab scale  \tab location\cr
  HDR.gengamma\tab  d, shape1 \tab k, shape2 \tab rate, scale \cr
  HDR.gumbelII\tab shape    \tab scale  \tab       \cr
  HDR.lgamma  \tab shape    \tab scale  \tab location\cr
  }

The table above shows the parameters in each of the distributions.  Some have default values, but most need to be specified.  (For the gamma
distribution you should specify either the \code{rate} or \code{scale} but not both.)
}
\examples{
HDR.norm(.95)
}
