% Generated by roxygen2 (4.0.2): do not edit by hand
\name{fill_gap}
\alias{fill_gap}
\alias{fill_gap_}
\title{Add rows corresponding to gaps in some variable}
\usage{
fill_gap(x, ..., along_with = NULL, units = NULL, by = NULL,
  full = FALSE, roll = FALSE, rollends = if (roll == "nearest") c(TRUE,
  TRUE) else if (roll >= 0) c(FALSE, TRUE) else c(TRUE, FALSE))

fill_gap_(x, ..., .dots, along_with = NULL, units = NULL, by = NULL,
  full = FALSE, roll = FALSE, rollends = if (roll == "nearest") c(TRUE,
  TRUE) else if (roll >= 0) c(FALSE, TRUE) else c(TRUE, FALSE))
}
\arguments{
\item{x}{A data.table}

\item{...}{Variables to keep (beyond the by and along_with variable). Default to all variables. See the \link[dplyr]{select} documentation.}

\item{along_with}{Numeric variable along which gaps should be filled. Default to last key. ee the \link[dplyr]{select} documentation.}

\item{units}{A character when along_with is a date( one of "second",  "minute", "hour", "day", "week", "month", "quarter", "year").}

\item{by}{Variables by which to group. Default to keys (or to keys minus last if along_with is unspecified). ee the \link[dplyr]{select} documentation.}

\item{full}{A boolean. When full = FALSE (default) rows are filled with respect to min and max of \code{...} within each group. When full = TRUE, rows are filled with respect to min and max of \code{...} in the whole datasets.}

\item{roll}{When roll is a positive number, this limits how far values are carried forward. roll=TRUE is equivalent to roll=+Inf. When roll is a negative number, values are rolled backwards; i.e., next observation carried backwards (NOCB). Use -Inf for unlimited roll back. When roll is "nearest", the nearest value is joined to.}

\item{rollends}{A logical vector length 2 (a single logical is recycled). When rolling forward (e.g. roll=TRUE) if a value is past the last observation within each group defined by the join columns, rollends[2]=TRUE will roll the last value forwards. rollends[1]=TRUE will roll the first value backwards if the value is before it. If rollends=FALSE the value of i must fall in a gap in x but not after the end or before the beginning of the data, for that group defined by all but the last join column. When roll is a finite number, that limit is also applied when rolling the end}

\item{.dots}{Used to work around non-standard evaluation.}
}
\description{
Add rows corresponding to gaps in some variable
}
\examples{
library(data.table)
DT <- data.table(
    id    = c(1, 1, 1, 2),
    year  = c(1992, 1989, 1991, 1992),
    value = c(4.1, 4.5, 3.3, 3.2)
)
fill_gap(DT, value, along_with = year, by = id)
library(lubridate)
DT[, date:= mdy(c("03/01/1992", "04/03/1992", "07/15/1992", "08/21/1992"))]
DT[, datem :=  floor_date(date, "month")]
fill_gap(DT, value, along_with = datem , units = "month", by = id)
}

