% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/setpanel.R
\name{is.panel}
\alias{is.panel}
\alias{is.panel_}
\alias{setpanel}
\alias{setpanel_}
\title{Check whether data.table is a panel data}
\usage{
is.panel(x, ...)

is.panel_(x, vars)

setpanel(x, ...)

setpanel_(x, vars)
}
\arguments{
\item{x}{a vector or matrix}

\item{...}{id variables. Last is time variable}

\item{vars}{Used to work around non standard evaluation}
}
\value{
The function \code{is.panel} checks no data variable is missing and that there are no duplicates for (id, along_with). The function \code{setpanel} reorders data.table in place if \code{is.panel} is \code{TRUE}
}
\description{
Check whether data.table is a panel data
}
\examples{
library(data.table)
DT <- data.table(
    id    = c(1, 1, 1, 2, 2),
    year  = c(1991, 1993, NA, 1992, 1992),
    value = c(4.1, 4.5, 3.3, 3.2, 5.2)
)
is.panel(DT, id, year)
DT <- na.omit(DT, cols = "year")
is.panel(DT, id, year)
DT <- unique(DT, by = c("id", "year"))
is.panel(DT, id, year)
setpanel(DT, id, year)
}

