% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_binmean.R
\name{stat_binmean}
\alias{stat_binmean}
\title{Plot the mean of y over the mean of x within bins of x.}
\usage{
stat_binmean(mapping = NULL, data = NULL, geom = "point",
  position = "identity", show.legend = NA, inherit.aes = TRUE,
  na.rm = FALSE, n = 20, ...)
}
\arguments{
\item{mapping}{The aesthetic mapping, usually constructed with
\code{\link{aes}} or \code{\link{aes_string}}. Only needs to be set
at the layer level if you are overriding the plot defaults.}

\item{data}{A layer specific dataset - only needed if you want to override
the plot defaults.}

\item{geom}{The geometric object to use display the data}

\item{position}{The position adjustment to use for overlapping points
on this layer}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link{borders}}.}

\item{na.rm}{If \code{FALSE} (the default), removes missing values with
a warning.  If \code{TRUE} silently removes missing values.}

\item{n}{number of x-bins. Default to 20. Set to zero if you want to use distinct value of x for grouping.}

\item{...}{other arguments passed on to \code{\link{layer}}. This can
include aesthetics whose values you want to set, not map. See
\code{\link{layer}} for more details.}
}
\value{
a data.frame with additional columns:
  \item{xtile}{bins for x}
  \item{x}{mean of x}
  \item{y}{mean of y}
}
\description{
Plot the mean of y over the mean of x within bins of x.
}
\examples{
library(ggplot2)
g <- ggplot(iris, aes(x = Sepal.Width , y = Sepal.Length)) 
g + stat_binmean(n = 10)
g + stat_binmean(n = 10) + stat_smooth(method = "lm", se = FALSE)
g + stat_binmean(n = 0) 
g <- ggplot(iris, aes(x = Sepal.Width , y = Sepal.Length, color = Species))
g + stat_binmean(n = 10)
g + stat_binmean(n = 10) + stat_smooth(method = "lm", se = FALSE)
}

