% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createFitMod.R
\name{plot.fitMod}
\alias{plot.fitMod}
\title{Plot function for class fitMod}
\usage{
\method{plot}{fitMod}(
  x,
  ...,
  plotType = c("rawPred", "corrPred", "herit", "effDim", "variance", "timeLapse",
    "spatial"),
  timePoints = names(x),
  title = NULL,
  output = TRUE,
  outFile = NULL,
  outFileOpts = NULL
)
}
\arguments{
\item{x}{An object of class fitMod.}

\item{...}{Extra plot options. Described per plotType in their respective
section.}

\item{plotType}{A single character string indicating which plot should be
made. See the sections below for a detailed explanation of the plots.}

\item{timePoints}{A character or numeric vector indicating the time points
to be plotted. When using a character string to reference a time point, the
value has to be an exact match to one of the existing timePoints. When using
a number it will be matched by its number ("timeNumber") in the timePoints
attribute of the TP object.}

\item{title}{A character string used as title for the plot. If \code{NULL} a
default title is added to the plot depending on \code{plotType}.}

\item{output}{Should the plot be output to the current device? If
\code{FALSE} only a (list of) ggplot object(s) is invisibly returned. Ignored if
\code{outFile} is specified.}

\item{outFile}{A character string indicating the .pdf file or .gif file
(for \code{plotType} = "timeLapse") to which the plots should be written.}

\item{outFileOpts}{A named list of extra options for the pdf outfile, e.g.
width and height. See \code{\link[grDevices]{pdf}} for all possible options.}
}
\value{
Depending on the plot type either a ggplot object or a list of
ggplot objects is invisibly returned.
}
\description{
Plotting function for objects of class \code{fitMod}. Seven different types
of plots can be made for an object of class \code{fitMod}. A detailed
description and optional extra parameters for the different plots is given
in the sections below.
}
\section{rawPred plot}{

Plots the raw data (colored dots) overlayed with the predicted values from
the fitted model (black dots). For each genotype a plot is made per
plot/plant over time. These plots are put together in a 5x5 grid. By using
the parameter \code{genotypes} a selection of genotypes can be plotted.
Extra parameter options:
\describe{
\item{genotypes}{A character vector indicating the genotypes to be plotted.}
\item{plotChecks}{Should the check genotypes be included in the plot?}
\item{plotLine}{Should the data be displayed as lines? Default is
\code{FALSE}.}
}
}

\section{corrPred plot}{

Plots the spatially corrected data (colored dots) overlayed with the
predicted values from the fitted model (black dors). For each genotype a plot
is made per plot/plant over time. These plots are put together in a 5x5 grid.
By using the parameter \code{genotypes} a selection of genotypes can be
plotted. Extra parameter options:
\describe{
\item{genotypes}{A character vector indicating the genotypes to be plotted.}
\item{plotChecks}{Should the check genotypes be included in the plot?}
\item{plotLine}{Should the data be displayed as lines? Default is
\code{FALSE}.}
}
}

\section{herit plot}{

Plots the heritability over time. This plot is only available when genotype
is fitted as random factor in the model. If \code{geno.decomp} is used when
fitting the model, heritabilities are plotted for each level of geno.decomp
in a single plot. Extra parameter options:
\describe{
\item{yLim}{A numerical vector of length two, used for setting the limits of
the y-axis of the plot. If values outside of the plotting range are given,
then these are ignored.}
}
}

\section{effDim plot}{

Plots the effective dimension over time for models fitted using SpATS.
Extra parameter options:
\describe{
\item{whichED}{A character vector indicating which effective dimensions
should be plotted. This should be a subset of "colId", "rowId", "fCol",
"fRow", "fColRow", "colfRow", "fColfRow" and "surface". When
\code{useRepId = TRUE}, the effective dimensions of "colId" and "rowId"
become "RepId:colId" and "RepId:rowId". Default all effective dimensions
are plotted.}
\item{EDType}{A character string specifying if the effective dimension
("dimension") or the ratio of effective dimensions ("ratio") should be
plotted. Default the dimensions are plotted.}
\item{yLim}{A numerical vector of length two, used for setting the limits of
the y-axis of the plot. If values outside of the plotting range are given,
then these are ignored.}
}
}

\section{variance plot}{

Plots the residual, column and row variances over time for the fitted models.
Extra parameter options:
\describe{
\item{yLim}{A numerical vector of length two, used for setting the limits of
the y-axis of the plot. If values outside of the plotting range are given,
then these are ignored.}
}
}

\section{timeLapse plot}{

Creates a time lapse of the spatial trends of models fitted using SpATS over
time.
}

\section{spatial plot}{

Creates five plots per time point, spatial plots of the raw data,
fitted values, residuals and either BLUEs or BLUPs, and a histogram of the
BLUEs or BLUPs. When SpATS was used for modeling an extra plot with the
fitted spatial trend is included Extra parameter options:
\describe{
\item{spaTrend}{A character string indicating how the spatial trend should
be displayed. Either "raw" for raw values, or "percentage" for displaying
as a percentage of the original phenotypic values.}
}
}

\examples{
\donttest{
## Using the first example dataset (PhenovatorDat1):
## Create an object of class TP.
phenoTP <- createTimePoints(dat = PhenovatorDat1,
                            experimentName = "Phenovator",
                            genotype = "Genotype",
                            timePoint = "timepoints",
                            repId = "Replicate",
                            plotId = "pos",
                            rowNum = "y", colNum = "x",
                            addCheck = TRUE,
                            checkGenotypes = c("check1", "check2",
                                               "check3", "check4"))

## Fit a SpATS model on three points:
modPhenoSp <- fitModels(TP = phenoTP,
                        trait = "EffpsII",
                        timePoints = c(1, 6, 36))

## Plot the spatial trends for one time point:
plot(modPhenoSp,
     timePoints = 36,
     plotType = "spatial",
     spaTrend = "percentage")
}

\dontrun{
## Create a time lapse of all available time points:
plot(modPhenoSp,
     plotType = "timeLapse",
     outFile = "TimeLapse_modPhenoSp.gif")
}

\donttest{
## Plot the corrected values for a subset of four genotypes:
plot(modPhenoSp,
     plotType = "corrPred",
     genotypes = c("check1", "check2", "G007", "G058") )

## Plot the effective dimensions of all available time points in the model
## for a subset of effective dimensions:
plot(modPhenoSp,
     plotType = "effDim",
     whichED = c("colId", "rowId", "fColRow","colfRow"),
     EDType = "ratio")
}

}
\seealso{
Other functions for spatial modeling: 
\code{\link{fitModels}()},
\code{\link{getCorrected}()},
\code{\link{getEffDims}()},
\code{\link{getGenoPred}()},
\code{\link{getHerit}()},
\code{\link{getVar}()},
\code{\link{summary.fitMod}()}
}
\concept{functions for spatial modeling}
