% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runme.R
\name{rnw2pdf}
\alias{rnw2pdf}
\title{Convert (Sweave & compile) an Rnw or lyx file to PDF}
\usage{
rnw2pdf(
  fn = NULL,
  wd = NULL,
  ...,
  engine = "knitr",
  purl = TRUE,
  tangle = purl,
  backup = TRUE,
  clean = TRUE,
  quiet = TRUE,
  verbose = !quiet,
  envir = parent.frame(),
  encoding = getOption("encoding")
)
}
\arguments{
\item{fn}{One or more file names, should end in either ".Rnw" or
".lyx"}

\item{wd}{Directory in which the file to be converted
exists. Leave NULL default if is in current working directory.}

\item{...}{Other parameters, not used at the moment.}

\item{engine}{"knitr" or "Sweave"}

\item{purl}{Default TRUE. Synonym of tangle: extract R code chunks}

\item{tangle}{Same as purl, both parameters have same result}

\item{backup}{Default TRUE. Will create backup copies of pdf, R, Rnw
files before replacing them. Uses \code{kutils::file.backup}}

\item{clean}{Default TRUE. Remove intermediate LaTeX files when
using texi2pdf}

\item{quiet}{Default = TRUE.  No output unless an error occurs.
Antonym for \code{verbose}.}

\item{verbose}{Default = \code{!quiet}. Antonym for
\code{quiet}. Functions try to reduce amount of screen
output. Knitr functions that use \code{quiet} flag will be set to
\code{!verbose}.}

\item{envir}{environment for evaluation, see \code{knitr}
documents, defaults to parent.frame().}

\item{encoding}{character encoding, defaults from user options}
}
\value{
names of pdf output files
}
\description{
Documents saved with suffix ".lyx" or ".Rnw" will be converted.
Note it is very important to specify the engine for the code
chunks correctly, this can be either "Sweave" or "knitr".
}
\examples{
\donttest{
tdir <- tempdir()
fmt <- "rnw2pdf-guide-sweave"
dirout <- initWriteup(fmt, dir = file.path(tdir, fmt))
print(dirout)
list.files(dirout)
of1 <- try(rnw2pdf("skeleton.Rnw", engine = "Sweave", wd = dirout, backup = TRUE))
if(inherits(of1, "try-error")){
    MESSG <- paste("Compiling the markdown file failed, perhaps",
                   "there is an R or LaTeX error.", 
                   "Run again with parameters verbose=TRUE",
                   "and clean=FALSE")
    print(MESSG)
} else {
    ## Check the result file:
    MESSG <- paste("Check the directory", dirout, "for results.")
    print(MESSG)
    list.files(dirout)
    if(interactive() && file.exists(of1)) {
        browseURL(of1)
    }
}
unlink(dirout)
}
}
\author{
Paul Johnson <pauljohn@ku.edu>
}
