% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geoMean.r
\name{geoMean}
\alias{geoMean}
\title{Geometric mean}
\usage{
geoMean(x, prop0 = FALSE, na.rm = TRUE)
}
\arguments{
\item{x}{Numeric list.}

\item{prop0}{Logical, if \code{FALSE} (default) then if any value in \code{x} equals 0 then the output will be zero. If \code{TRUE}, then zero values will be removed before calculation of the geometric mean.}

\item{na.rm}{Logical, if \code{TRUE} then remove \code{NA} values first.}
}
\value{
Numeric.
}
\description{
Geometric mean, with optional removal of \code{NA}'s and propagation of zeros.
}
\details{
Adapted from Paul McMurdie on \href{https://stackoverflow.com/questions/2602583/geometric-mean-is-there-a-built-in}{StackOverflow}.
}
\examples{

x <- seq(0.01, 1, by=0.01)
mean(x)
geoMean(x)
x <- seq(0, 1, by=0.01)
mean(x)
geoMean(x)
geoMean(x, prop0=TRUE)

}
