% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hist2d.r
\name{hist2d}
\alias{hist2d}
\title{Two-dimensional histogram}
\usage{
hist2d(x, breaks1 = "Sturges", breaks2 = "Sturges", right = TRUE, ...)
}
\arguments{
\item{x}{Data frame or matrix with at least two columns. Only first two columns are used to tally frequencies.}

\item{breaks1}{One of the following describing how breaks for the first variable are calculated:
\itemize{
\item Numeric vector: Breakpoints for bins for the first variable.
\item Single integer: The number of bins into which to tally values of the first variable.
\item Function: To compute the vector of breakpoints.
\item Function: To compute the number of cells. Used as a suggestion only (see \code{\link[graphics]{hist}}).
\item Character: The name of a function to compute the number of cells (see the \emph{Details} section in \code{\link[graphics]{hist}}). Used as a suggestion only (see \code{\link[graphics]{hist}}).
}}

\item{breaks2}{Same as \code{breaks1} but for the second variable.}

\item{right}{Logical, if \code{TRUE} (default) then use left-open and right-closed intervals.}

\item{...}{Arguments to pass to \code{\link[graphics]{hist}}.}
}
\value{
Object of class \code{matrix} and \code{histogram2d}. Columns pertain to bins of \code{x1} and rows \code{x2}. Column names and row names are mid-points of bins.
}
\description{
Two-dimensional histogram
}
\examples{

x1 <- rnorm(1000)
x2 <- 0.5 * x1 * rnorm(1000)
x <- data.frame(x1=x1, x2=x2)
hist2d(x)

}
\seealso{
\code{\link[graphics]{hist}}
}
