#  File R/control.utilities.R in package statnet.common, part of the Statnet suite
#  of packages for network analysis, http://statnet.org .
#
#  This software is distributed under the GPL-3 license.  It is free,
#  open source, and has the attribution requirements (GPL Section 7) at
#  http://statnet.org/attribution
#
#  Copyright 2003-2013 Statnet Commons
#######################################################################
check.control.class <- function(OKnames={sc <- sys.calls(); as.character(sc[[length(sc)-1]][[1]])}, myname={sc <- sys.calls(); as.character(sc[[length(sc)-1]][[1]])}, control=get("control",pos=parent.frame())){
  funs <- paste("control", OKnames, sep=".")
  
  if(inherits(control, funs[1])) return(TRUE)
  
  for(fun in funs[-1]) # If there is only one, that's a null vector, so it just terminates.
    if(inherits(control, fun)){
      warning("Using ", fun,"(...) as the control parameter of ",myname,"(...) is suboptimal and may overwrite some settings that should be preserved. Use ",funs[1],"(...) instead.")
      return(FALSE)
    }
  
  stop("Invalid control parameters for ",myname,"(...): ",class(control)[1],"(...). Use ",funs[1],"(...) to construct them instead.", call.=FALSE)
}

set.control.class <- function(myname={sc <- sys.calls(); as.character(sc[[length(sc)-1]][[1]])}, control=get("control",pos=parent.frame())){
  class(control) <- c(myname, "control.list")
  control
}

print.control.list <- function(x, ...){
  cat("Control parameter list generated by", class(x)[1], "or equivalent. Non-NULL parameters:\n")
  for(name in names(x)){
    if(!is.null(x[[name]])){
      cat(name,": ",sep="")
      if(is.list(x[[name]])) print(x[[name]]) else cat(x[[name]],"\n")
    }
  }
}
