#' statnetWeb: A graphical user interface for network analysis.
#'
#' The statnetWeb package makes it easy to run
#' descriptive statistics, graphics and statistical analyses of network data 
#' via an intuitive graphical user interface.  
#' It is an Rshiny application based on 
#' the Statnet suite of network analysis packages  
#' See https://statnet.org for more information.
#'
#' @name statnetWeb

#' @keywords internal
"_PACKAGE"

#' @import shiny
#' @import ergm
#' @import network
#' @import lattice
#' @import latticeExtra
#' @importFrom sna betweenness
#' @importFrom sna centralization
#' @importFrom sna closeness
#' @importFrom sna degree
#' @importFrom sna evcent
#' @importFrom sna gden
#' @importFrom sna geodist
#' @importFrom sna graphcent
#' @importFrom sna grecip
#' @importFrom sna gtrans
#' @importFrom sna infocent
#' @importFrom sna rgnm
#' @importFrom sna rgraph
#' @importFrom sna symmetrize
#' @importFrom RColorBrewer brewer.pal

NULL
