% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{police_boundaries}
\alias{police_boundaries}
\title{Police force boundaries in England (2016)}
\format{An sf data frame}
\description{
This dataset represents the 43 police forces in England and Wales.
These are described on the
\href{https://en.wikipedia.org/wiki/List_of_police_forces_of_the_United_Kingdom}{Wikipedia page}.
on UK police forces.
}
\details{
The geographic boundary data were taken from the UK government's
official geographic data portal.
See http://geoportal.statistics.gov.uk/
}
\note{
These were generated using the script in the
\code{data-raw} directory (\code{misc.Rmd} file) in the package's GitHub repo:
\href{https://github.com/ITSLeeds/stats19}{github.com/ITSLeeds/stats19}.
}
\examples{
nrow(police_boundaries)
police_boundaries[police_boundaries$pfa16nm == "West Yorkshire", ]
sf:::plot.sf(police_boundaries)
}
\keyword{datasets}
